#include <dxsound.h>

#define DSENUMRET_CANCEL FALSE
#define DSENUMRET_TRUE	 TRUE

BOOL CALLBACK DirectSoundEnumCallback (LPGUID lpGuid,
													LPCSTR lpstrDescription, LPCSTR lpstrModule,
													LPVOID lpContext);

HRESULT CreateDirectSound(HWND hwnd)
{
	HRESULT ddrval;

	ddrval = DirectSoundEnumerate(DirectSoundEnumCallback, NULL);
	if(DS_OK != ddrval)
		return ddrval;

	if(NULL == lpDS)
	{
		// Create directsound object
		ddrval = DirectSoundCreate(NULL, &lpDS, NULL);
		if(DS_OK != ddrval)
			return ddrval;
	}

	// Set the cooperation level for the directsound object
	ddrval = lpDS->SetCooperativeLevel(hwnd, DSSCL_NORMAL);
	if(DS_OK != ddrval)
		return ddrval;

	return DS_OK;
}

BOOL CALLBACK DirectSoundEnumCallback(LPGUID lpGuid,
												  LPCSTR lpstrDescription, LPCSTR lpstrModule,
												  LPVOID lpContext)
{
	if(NULL != lpGuid)
	{
		// We have found a sound device
		if(DS_OK != DirectSoundCreate(lpGuid, &lpDS, NULL))
			return DSENUMRET_CANCEL;
	}

	return DSENUMRET_TRUE;
}

HRESULT CreateDirectSoundBuffer(LPDIRECTSOUNDBUFFER &lpDSBuffer, LPCSTR lpFileName)
{
	HRESULT ddrval;

	CWave wave(lpFileName);

	// Get the wave information
	DWORD dwDataLen = wave.GetDataLen();

	WAVEFORMATEX wfFormat;
	wave.GetFormat(wfFormat);

	// Setup the DS buffer description
	DSBUFFERDESC dsbd;
	memset(&dsbd, 0, sizeof(DSBUFFERDESC));

	dsbd.dwSize 		 = sizeof(DSBUFFERDESC);
	dsbd.dwFlags		 = DSBCAPS_CTRLDEFAULT | DSBCAPS_STATIC;
	dsbd.dwBufferBytes = dwDataLen;
	dsbd.lpwfxFormat	 = &wfFormat;

	// Setup the directsound buffer description
	ddrval = lpDS->CreateSoundBuffer(&dsbd, &lpDSBuffer, NULL);
	if(DS_OK != ddrval)
		return ddrval;

	// Lock the directsound buffer
	LPBYTE lpDSBuffData = NULL;
	ddrval = lpDSBuffer->Lock(0, dwDataLen, (LPLPVOID)&lpDSBuffData, &dwDataLen, NULL, 0, 0);
	if(DS_OK != ddrval)
		return ddrval;

	// Write wave data to the directsound buffer
	dwDataLen = wave.GetData(lpDSBuffData, dwDataLen);

	// Unlock the DS buffer
	ddrval = lpDSBuffer->Unlock(lpDSBuffData, dwDataLen, NULL, 0);
	if(DS_OK != ddrval)
		return ddrval;

	return DS_OK;
}

void ReleaseDirectSound()
{
	// Release the directsound object
	if(NULL != lpDS)
	{
		lpDS->Release();
		lpDS = NULL;
	}
}

HRESULT RestoreDirectSoundBuffer(LPDIRECTSOUNDBUFFER &lpDSBuffer, LPCSTR lpFileName)
{
	// Restore the buffer
	HRESULT ddrval = lpDSBuffer->Restore();
	if(DS_OK != ddrval)
		return ddrval;

	// Re-initialize the buffer
	return CreateDirectSoundBuffer(lpDSBuffer, lpFileName);
}

