#include <dxsound.h>
#include <dx3d.h>

CRITICAL_SECTION	  critical_section;

DWORD 				  timerID;				 // the ID of timer
DWORD 				  dwTimeTick;			 // the interval of timer
DWORD 				  dwFPS; 				 // frames per second

HIC hic;

// values for video stream
LPDIRECTDRAWSURFACE lpDDSurface; 		 // directdraw surface for video stream
PAVISTREAM			  aviVideoStream; 	 // video stream pointer

LPBITMAPINFOHEADER  lpSourceFormat; 	 // extract video stream to bitmap format
LPBITMAPV4HEADER	  lpTarget;

LPBYTE				  lpSource; 			 // pointer for one frame of video stream
LPBYTE				  lpDest;				 //

DWORD 				  dwLinePitch;
DWORD 				  dwLength;

DWORD 				  dwIndex;				  // display the position of dwIndex frame
DWORD 				  dwFrames; 			  // the number of frames

// values for sound stream
LPDIRECTSOUNDBUFFER lpDSBuffer;			  // directsound buffer for audio stream
PAVISTREAM			  aviSoundStream; 	  // sound stream pointer

LPWAVEFORMATEX 	  lpSoundFormat;		  // extract audio stream to wave file format

DWORD 				  dwLoadPos;			  // the position of audio stream
DWORD 				  dwLoadSize;			  // size of audio stream

DWORD 				  dwSoundFramesAhead;


void CALLBACK GetFrameTimer (UINT, UINT, DWORD, DWORD, DWORD);

void PlayVideoStream 		 (int frame);
void PlayAudioStream 		 ();

HRESULT AVILoad(LPCSTR lpFileName, BOOL fIsPlay)
{
	if(!Stop_AVI)
		AVIStop();

	LONG dwFormatLength;

	AVIFileInit();

	// video stream
	AVIStreamOpenFromFile(&aviVideoStream, lpFileName, streamtypeVIDEO, 0, OF_READ, NULL);
	AVIStreamFormatSize(aviVideoStream, 0, &dwFormatLength);

	lpSourceFormat = (LPBITMAPINFOHEADER)calloc(1, dwFormatLength);
	lpTarget 		= (LPBITMAPV4HEADER)calloc(1, max(dwFormatLength, sizeof(BITMAPV4HEADER)));

	AVIStreamReadFormat(aviVideoStream, 0, lpSourceFormat, &dwFormatLength);
	if(640 < lpSourceFormat->biWidth || 480 < lpSourceFormat->biHeight)
	{
		AVIStreamRelease(aviVideoStream);
		AVIFileExit();

		return DDERR_NOTFOUND;
	}

	// Create the directdraw surface
	DDSURFACEDESC ddsd;
	memset(&ddsd, 0, sizeof(DDSURFACEDESC));

	ddsd.dwSize 		  = sizeof(DDSURFACEDESC);
	ddsd.dwFlags		  = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwWidth		  = lpSourceFormat->biWidth;
	ddsd.dwHeight		  = lpSourceFormat->biHeight;

	HRESULT ddrval = lpDD->CreateSurface(&ddsd, &lpDDSurface, NULL);
	if(DD_OK != ddrval)
	{
		AVIStreamRelease(aviVideoStream);
		AVIFileExit();

		return ddrval;
	}

	lpDDSurface->GetSurfaceDesc(&ddsd);

	memcpy(lpTarget, lpSourceFormat, dwFormatLength);

	lpTarget->bV4Size 			= max(sizeof(dwFormatLength), sizeof(BITMAPV4HEADER));
	lpTarget->bV4BitCount		= (USHORT)ddsd.ddpfPixelFormat.dwRGBBitCount;
	lpTarget->bV4V4Compression = BI_BITFIELDS;
	if(24 == lpTarget->bV4BitCount) lpTarget->bV4V4Compression = BI_RGB;

	lpTarget->bV4ClrUsed 		= 0;
	lpTarget->bV4RedMask 		= ddsd.ddpfPixelFormat.dwRBitMask;
	lpTarget->bV4GreenMask		= ddsd.ddpfPixelFormat.dwGBitMask;
	lpTarget->bV4BlueMask		= ddsd.ddpfPixelFormat.dwBBitMask;
	lpTarget->bV4AlphaMask		= ddsd.ddpfPixelFormat.dwRGBAlphaBitMask;
	lpTarget->bV4SizeImage		= (0xFFFFFFFC & (3 + lpTarget->bV4Width)) * lpTarget->bV4Height * (lpTarget->bV4BitCount >> 3);

	// How many are frames?
	dwFrames = AVIStreamLength(aviVideoStream);

	AVISTREAMINFO asi;
	AVIStreamInfo(aviVideoStream, &asi, sizeof(AVISTREAMINFO));

	dwLength = (DWORD)(lpSourceFormat->biWidth * lpSourceFormat->biHeight * (lpSourceFormat->biBitCount >> 3));

	if(asi.dwSuggestedBufferSize)
		if(asi.dwSuggestedBufferSize < dwLinePitch)
			dwLength = asi.dwSuggestedBufferSize;

	dwLinePitch = lpTarget->bV4Width * (lpTarget->bV4BitCount >> 3);

	dwTimeTick = (1000 * asi.dwScale + (asi.dwRate >> 1)) / asi.dwRate;	  // time interval
	dwFPS 	  = asi.dwRate / asi.dwScale; 										  // frame per second

	double fps = (double)asi.dwRate / (double)asi.dwScale;

	lpSource = (LPBYTE)calloc(1, dwLength);
	lpDest	= (LPBYTE)calloc(1, lpTarget->bV4SizeImage);

	hic = ICDecompressOpen(ICTYPE_VIDEO, asi.fccHandler, lpSourceFormat, (LPBITMAPINFOHEADER)lpTarget);

	ICDecompressBegin(hic, lpSourceFormat, (LPBITMAPINFOHEADER)lpTarget);

	// audio stream
	AVIStreamOpenFromFile(&aviSoundStream, lpFileName, streamtypeAUDIO, 0, OF_READ, NULL);
	AVIStreamFormatSize(aviSoundStream, 0, &dwFormatLength);

	lpSoundFormat = (LPWAVEFORMATEX)calloc(1, dwFormatLength);

	AVIStreamReadFormat(aviSoundStream, 0, lpSoundFormat, &dwFormatLength);
	AVIStreamInfo(aviSoundStream, &asi, sizeof(AVISTREAMINFO));

	dwSoundFramesAhead = asi.dwInitialFrames / asi.dwScale;
//   dwLoadSize			= (lpSoundFormat->nAvgBytesPerSec + dwFPS - 1) / dwFPS;
	dwLoadSize			 = DWORD((lpSoundFormat->nAvgBytesPerSec + dwFPS - 1) / fps);

	// Create the directsound buffer
	DSBUFFERDESC dsbd;
	memset(&dsbd, 0, sizeof(DSBUFFERDESC));

	dsbd.dwSize 		 = sizeof(DSBUFFERDESC);
	dsbd.dwFlags		 = 0;
	dsbd.dwBufferBytes = dwLoadSize * dwFPS;
	dsbd.dwReserved	 = 0;
	dsbd.lpwfxFormat	 = lpSoundFormat;

	ddrval = lpDS->CreateSoundBuffer(&dsbd, &lpDSBuffer, NULL);
	if(DS_OK != ddrval)
	{
		Release(lpDDSurface);

		AVIStreamRelease(aviVideoStream);
		AVIFileExit();

		return ddrval;
	}

	if(fIsPlay)
		return AVIPlay();

	return DD_OK;
}

HRESULT AVIPlay()
{
	InitializeCriticalSection(&critical_section);

	ClearScreen();
	ClearScreen();

	PlayAudioStream();
	PlayVideoStream(0);

	lpDSBuffer->Play(0, 0, DSBPLAY_LOOPING);

	timerID = timeSetEvent(dwTimeTick, 5, GetFrameTimer, NULL, TIME_PERIODIC);

	Stop_AVI = FALSE;

	return DD_OK;
}

void PlayAudioStream()
{
	LPVOID data1, data2;
	DWORD  size1, size2;

	// output audio stream
	lpDSBuffer->Lock(dwLoadPos * dwLoadSize, dwLoadSize, &data1, &size1, &data2, &size2, 0);
	AVIStreamRead(aviSoundStream, dwIndex * dwLoadSize >> 1, dwLoadSize >> 1, data1, dwLoadSize, NULL, NULL);
	lpDSBuffer->Unlock(data1, size1, data2, size2);

	dwLoadPos++;
	dwLoadPos %= dwFPS;
}

void PlayVideoStream(int frame)
{
	frame -= dwSoundFramesAhead;

	// output video stream
	if(0				 > frame)	 return;
	if((DWORD)frame > dwFrames) return;

	AVIStreamRead(aviVideoStream, frame, 1, lpSource, dwLength, NULL, NULL);

	EnterCriticalSection(&critical_section);
	ICDecompress(hic, 0, lpSourceFormat, lpSource, (LPBITMAPINFOHEADER)lpTarget, lpDest);
	LeaveCriticalSection(&critical_section);
}

void AVIStop()
{
	if(Stop_AVI)
		return;

	if(0 != timerID)
	{
		lpDSBuffer->Stop();

		// release the directsound  surface
		Release(lpDSBuffer);

		timeKillEvent(timerID);
		Sleep(dwTimeTick);

		timerID = 0;
	}

	// release the directdraw surface
	Release(lpDDSurface);

	DeleteCriticalSection(&critical_section);

	// AVI file release
	AVIStreamRelease(aviVideoStream);
	AVIStreamRelease(aviSoundStream);

	ICDecompressEnd(hic);
	ICClose(hic);

	AVIFileExit();

	if(NULL != lpSourceFormat) free(lpSourceFormat);
	if(NULL != lpTarget) 		free(lpTarget);

	if(NULL != lpSource) 		free(lpSource);
	if(NULL != lpDest)			free(lpDest);

	if(NULL != lpSoundFormat)	free(lpSoundFormat);

	dwIndex	 = 0; 							  // the first frame
	dwLoadPos = 0; 							  // the first sound data
	Stop_AVI  = TRUE; 						  // don't play AVI
}

void CALLBACK GetFrameTimer(UINT, UINT, DWORD, DWORD, DWORD)
{
	dwIndex++;

	if(dwFrames <= dwIndex)
	{
		AVIStop();
		return;
	}

	PlayAudioStream();
	PlayVideoStream(dwIndex);

	DDSURFACEDESC ddsd;
	memset(&ddsd, 0, sizeof(DDSURFACEDESC));

	ddsd.dwSize = sizeof(DDSURFACEDESC);
	lpDDSurface->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL);

	LPBYTE _lpSource = lpDest + dwLinePitch * (lpTarget->bV4Height - 1);
	LPBYTE _lpDest   = (LPBYTE)ddsd.lpSurface;

	EnterCriticalSection(&critical_section);
	for(int i = 0; i < (int)lpTarget->bV4Height; i++)
	{
		memcpy(_lpDest, _lpSource, dwLinePitch);

		_lpDest	 += ddsd.lPitch;
		_lpSource -= dwLinePitch;
	}
	LeaveCriticalSection(&critical_section);

	lpDDSurface->Unlock(&ddsd);

	lpDDSurfaceBackBuffer->BltFast(0, 0, lpDDSurface, NULL, DDBLTFAST_WAIT);

	Flip();
}

