#define INITGUID
#include <dx3d.h>

BOOL WINAPI DirectDrawEnumCallback (LPGUID lpGUID, LPSTR lpDriverDesc, LPSTR lpDriverName, LPVOID lpContext);

HRESULT CreateDirectDraw(HWND hwnd)
{
	HRESULT ddrval;

	// If a 3D capable directdraw driver is available, use it as the directdraw device, otherwise, use the HEL.
	ddrval = DirectDrawEnumerate(DirectDrawEnumCallback, NULL);
	if(DD_OK != ddrval)
		return ddrval;

	// Create the directdraw/3d driver object and get the directdraw interface to that object.
	if(NULL == lpDD)
	{
		ddrval = DirectDrawCreate(NULL, &lpDD, NULL);
		if(DD_OK != ddrval)
			return ddrval;
	}

	// Create the directdraw2 interface to that object.
	ddrval = lpDD->QueryInterface(IID_IDirectDraw2, (LPVOID *)&lpDD2);
	if(DD_OK != ddrval)
		return ddrval;

	// Set the cooperative level to exclusive mode for fullscreen.
	ddrval = lpDD->SetCooperativeLevel(hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
	if(DD_OK != ddrval)
		return ddrval;

	// Set the video mode to 640 x 480 x 16(default).
	ddrval = lpDD->SetDisplayMode(640, 480, 16);
	if(DD_OK != ddrval)
		return ddrval;

	// Setup surface caps for a front buffer.
	DDSURFACEDESC ddsd;
	memset(&ddsd, 0, sizeof(DDSURFACEDESC));

	ddsd.dwSize 			  = sizeof(DDSURFACEDESC);
	ddsd.dwFlags			  = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps	  = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX | DDSCAPS_3DDEVICE | DDSCAPS_VIDEOMEMORY;
	ddsd.dwBackBufferCount = 1;

	// Create primary surface.
	ddrval = lpDD->CreateSurface(&ddsd, &lpDDSurfacePrimary, NULL);
	if(DD_OK != ddrval)
		return ddrval;

	// Grab the render surface (back buffer) from the primary surface (front buffer).
	DDSCAPS ddscCaps;
	ddscCaps.dwCaps = DDSCAPS_BACKBUFFER | DDSCAPS_3DDEVICE;

	ddrval = lpDDSurfacePrimary->GetAttachedSurface(&ddscCaps, &lpDDSurfaceBackBuffer);
	if(DD_OK != ddrval)
		return ddrval;

	// Twice
	ClearScreen();
	ClearScreen();

	// For angle of cosine and sine
	PrecomputeRadian();

	return DD_OK;
}

BOOL WINAPI DirectDrawEnumCallback(LPGUID lpGUID, LPSTR lpDriverDesc, LPSTR lpDriverName, LPVOID lpContext)
{
	// Create the directdraw device using this driver. If it fails, just move on to the next driver.
	if(DD_OK != DirectDrawCreate(lpGUID, &lpDD, NULL))
		return DDENUMRET_OK;

	// Get the capabilities of this directdraw driver. If it fails, just move on to the next driver.
	DDCAPS HALCaps, HELCaps;
	memset(&HALCaps, 0, sizeof(DDCAPS));
	HALCaps.dwSize = sizeof(DDCAPS);

	memset(&HELCaps, 0, sizeof(DDCAPS));
	HELCaps.dwSize = sizeof(DDCAPS);

	// Get the capabilities of this directdraw driver.
	if(DD_OK != lpDD->GetCaps(&HALCaps, &HELCaps))
	{
		Release(lpDD);
		return DDENUMRET_OK;
	}

	// We have found a secondary 3d hardware device.
	if((NULL != lpGUID) && (HALCaps.dwCaps & DDCAPS_3D))
	{
		return DDENUMRET_CANCEL;
	}
	else
	{
		Release(lpDD);
		return DDENUMRET_OK;
	}
}

HRESULT Flip()
{
	HRESULT ddrval;

	do
	{
		ddrval = lpDDSurfacePrimary->Flip(NULL, DDFLIP_WAIT);
		if(DD_OK == ddrval)
			break;

		if(DDERR_SURFACELOST == ddrval)
		{
			ddrval = RestoreDirectDraw();
			if(DD_OK == ddrval)
				break;
		}

		if(DDERR_WASSTILLDRAWING != ddrval)
			break;
	} while(true);

	return DD_OK;
}

HRESULT RestoreDirectDraw()
{
	HRESULT ddrval;

	if(NULL != lpDDSurfacePrimary)
	{
		ddrval = lpDDSurfacePrimary->IsLost();
		if(DD_OK != ddrval)
		{
			ddrval = lpDDSurfacePrimary->Restore();
			if(DD_OK != ddrval)
				return ddrval;

			if(NULL != lpDDSurfaceZBuffer)
			{
				ddrval = lpDDSurfaceZBuffer->IsLost();
				if(DD_OK != ddrval)
				{
					ddrval = lpDDSurfaceZBuffer->Restore();
					if(DD_OK != ddrval)
						return ddrval;
				}
			}

			RestoreDirectX();
		}
	}

	return DD_OK;
}

void ReleaseDirectDraw()
{
  if(NULL != lpDDSurfaceZBuffer)
	{
		lpDDSurfaceBackBuffer->DeleteAttachedSurface(0, lpDDSurfaceZBuffer);
		Release(lpDDSurfaceZBuffer);
	}

	 Release(lpDDSurfacePrimary);

	if(NULL != lpDD)
		lpDD->RestoreDisplayMode();

	Release(lpDD2);
	Release(lpDD);
}

HRESULT ClearScreen()
{
	HRESULT ddrval;

	DDBLTFX ddbltfx;
	ddbltfx.dwSize 	  = sizeof(DDBLTFX);
	ddbltfx.dwFillColor = RGB_MAKE(0, 0, 0);

	// Use the blter to do a color fill to clear the back buffer
	ddrval = lpDDSurfaceBackBuffer->Blt(NULL, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddbltfx);
	if(DD_OK != ddrval)
		return ddrval;

	// We have rendered the back buffer, call flip so we can see it
	ddrval = lpDDSurfacePrimary->Flip(NULL, DDFLIP_WAIT);
	if(DD_OK != ddrval)
		return ddrval;

	return DD_OK;
}

