#include <dx3d.h>

#define NUMBER_OF_LIGHT  10

LPDIRECT3DMATERIAL2 lpD3DMaterialBackground;
D3DTEXTUREHANDLE	  hD3DMaterialBackground;

D3DDEVICEDESC		  d3dHELDeviceDesc;

GUID					  guidDevice;

LPDIRECT3DLIGHT	  lpD3DLight[NUMBER_OF_LIGHT];
int					  light_count;

HRESULT WINAPI EnumDeviceCallBack (LPGUID lpGuid,
											  LPSTR lpDeviceDescription, LPSTR lpDeviceName,
											  LPD3DDEVICEDESC lpD3DHALDeviceDesc,
											  LPD3DDEVICEDESC lpD3DHELDeviceDesc,
											  LPVOID lpUserArg);

DWORD FlagsToBitDepth(DWORD dwFlags);

HRESULT CreateDirect3D()
{
	HRESULT ddrval;

	// Get The direct3d interface.
	ddrval = lpDD->QueryInterface(IID_IDirect3D2, (LPVOID *)&lpD3D);
	if(D3D_OK != ddrval)
		return ddrval;

	// Enumerate the devices and pick one.
	lpD3D->EnumDevices(EnumDeviceCallBack, NULL);

	// Detemine the kind of memory (system or video) from which the background surface should be allocated.
	// Default is system memory.
	LPD3DDEVICEDESC lpD3DDeviceDesc		= &d3dHELDeviceDesc;
	DWORD 			 dwZBufferMemoryType = DDSCAPS_SYSTEMMEMORY;

	if(0 != d3dHALDeviceDesc.dcmColorModel)
	{
		// Device had a hardware raterizer. Currently this means that the background surface must in video memory.
		lpD3DDeviceDesc	  = &d3dHALDeviceDesc;
		dwZBufferMemoryType = DDSCAPS_VIDEOMEMORY;
	}

	// Create the z-buffer
	if(0 != d3dHALDeviceDesc.dwDeviceZBufferBitDepth)
	{
		DDSURFACEDESC ddsd;
		memset(&ddsd, 0, sizeof(DDSURFACEDESC));

		ddsd.dwSize 			  = sizeof(DDSURFACEDESC);
		ddsd.dwFlags			  = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT | DDSD_ZBUFFERBITDEPTH;
		ddsd.ddsCaps.dwCaps	  = DDSCAPS_ZBUFFER | DDSCAPS_VIDEOMEMORY;
		ddsd.dwWidth			  = 640;
		ddsd.dwHeight			  = 480;
		ddsd.dwZBufferBitDepth = FlagsToBitDepth(d3dHALDeviceDesc.dwDeviceZBufferBitDepth);

		ddrval = lpDD->CreateSurface(&ddsd, &lpDDSurfaceZBuffer, NULL);
		if(DD_OK != ddrval)
			return ddrval;

		// Attach z-buffer to rendering surface
		ddrval = lpDDSurfaceBackBuffer->AddAttachedSurface(lpDDSurfaceZBuffer);
		if(DD_OK != ddrval)
			return ddrval;
	}

	// Create an instance of the direct3d device
	ddrval = lpD3D->CreateDevice(guidDevice, lpDDSurfaceBackBuffer, &lpD3DDevice);
	if(D3D_OK != ddrval)
		return ddrval;

	// Create the direct3d viewport object
	ddrval = lpD3D->CreateViewport(&lpD3DViewport, NULL);
	if(D3D_OK != ddrval)
		return ddrval;

	// Add the viewport to the direct3d device
	ddrval = lpD3DDevice->AddViewport(lpD3DViewport);
	if(D3D_OK != ddrval)
		return ddrval;

	// Setup the viewport for a reasonable viewing area
	D3DVIEWPORT2 d3dViewport;
	memset(&d3dViewport, 0, sizeof(D3DVIEWPORT2));

	d3dViewport.dwSize		 = sizeof(D3DVIEWPORT2);
	d3dViewport.dwX			 = 0; 				  // If you are using D3DVERTEX or D3DLVERTEX vertices - that is,
	d3dViewport.dwY			 = 0; 				  // if Direct3D is performing the transformations -
	d3dViewport.dwWidth		 = 640;				  // you might want to set the last six members of this structure as follows:
	d3dViewport.dwHeight 	 = 480;
/* d3dViewport.dvClipX		 = D3DVAL(0.0);	*/ d3dViewport.dvClipX		 = D3DVAL(-1.0);
/* d3dViewport.dvClipY		 = D3DVAL(0.0);	*/ d3dViewport.dvClipY		 = D3DVAL(D3DVAL(d3dViewport.dwHeight) / D3DVAL(d3dViewport.dwWidth));
/* d3dViewport.dvClipWidth  = D3DVAL(640.0); */ d3dViewport.dvClipWidth  = D3DVAL(2.0);
/* d3dViewport.dvClipHeight = D3DVAL(480.0); */ d3dViewport.dvClipHeight = D3DVAL(2.0 * d3dViewport.dvClipY);
	d3dViewport.dvMinZ		 = D3DVAL(0.0);
	d3dViewport.dvMaxZ		 = D3DVAL(1.0);

	ddrval = lpD3DViewport->SetViewport2(&d3dViewport);
	if(D3D_OK != ddrval)
		return ddrval;

	// Update the direct3d device to use this viewport
	ddrval = lpD3DDevice->SetCurrentViewport(lpD3DViewport);
	if(D3D_OK != ddrval)
		return ddrval;

	// Create background material
	ddrval = lpD3D->CreateMaterial(&lpD3DMaterialBackground, NULL);
	if(D3D_OK != ddrval)
		return ddrval;

	D3DMATERIAL d3dMaterial;
	memset(&d3dMaterial, 0, sizeof(D3DMATERIAL));

	d3dMaterial.dwSize	  = sizeof(D3DMATERIAL);
	d3dMaterial.dwRampSize = 1;						 // When using the RAMP software rasterizer, textures in background materials should have a ramp size of one.

	ddrval = lpD3DMaterialBackground->SetMaterial(&d3dMaterial);
	if(D3D_OK != ddrval)
		return ddrval;

	ddrval = lpD3DMaterialBackground->GetHandle(lpD3DDevice, &hD3DMaterialBackground);
	if(D3D_OK != ddrval)
		return ddrval;

	ddrval = lpD3DViewport->SetBackground(hD3DMaterialBackground);
	if(D3D_OK != ddrval)
		return ddrval;

	return D3D_OK;
}

void ReleaseDirect3D()
{
	if(NULL != lpD3DDevice)
	{
		if(NULL != lpD3DViewport)
		{
			Release(lpD3DMaterialBackground);

			for(int i = 0; i < NUMBER_OF_LIGHT; i++)
					ReleaseLight(i + 1);

			lpD3DDevice->DeleteViewport(lpD3DViewport);
			Release(lpD3DViewport);
		}

		Release(lpD3DDevice);
	}

	Release(lpD3D);
}

HRESULT WINAPI EnumDeviceCallBack(LPGUID lpGuid,
											 LPSTR lpDeviceDescription, LPSTR lpDeviceName,
											 LPD3DDEVICEDESC lpD3DHALDeviceDesc,
											 LPD3DDEVICEDESC lpD3DHELDeviceDesc,
											 LPVOID lpUserArg)
{
	// If there is no hardware support the color model is zero
	BOOL fIsHardware = (0 != lpD3DHALDeviceDesc->dcmColorModel);

	LPD3DDEVICEDESC lpD3DDeviceDesc = (fIsHardware ? lpD3DHALDeviceDesc : lpD3DHELDeviceDesc);

	// Does the device render at the depth we want? (defalt depth is 16 bits)
	if(0 == (lpD3DDeviceDesc->dwDeviceRenderBitDepth & DDBD_16))
		return D3DENUMRET_OK;

	// The device must support Flat-shaded triangles
	if(D3DCOLOR_MONO == lpD3DDeviceDesc->dcmColorModel)
	{
		if(!(lpD3DDeviceDesc->dpcTriCaps.dwShadeCaps & D3DPSHADECAPS_COLORGOURAUDMONO))
			return D3DENUMRET_OK;				// No Gouraud shading. Skip this device
	}
	else
	{
		if(!(lpD3DDeviceDesc->dpcTriCaps.dwShadeCaps & D3DPSHADECAPS_COLORGOURAUDRGB))
			return D3DENUMRET_OK;			  // No Gouraud shading. Skip this device
	}

	if(!fIsHardware && (D3DCOLOR_RGB == lpD3DDeviceDesc->dcmColorModel))
	{
		// If this is software RGB and we already have found a software monochromatic renderer,
		// we are not interested. Skip this device
		return D3DENUMRET_OK;
	}

	memcpy(&guidDevice, lpGuid, sizeof(GUID));
	memcpy(&d3dHALDeviceDesc, lpD3DHALDeviceDesc, sizeof(D3DDEVICEDESC));
	memcpy(&d3dHELDeviceDesc, lpD3DHELDeviceDesc, sizeof(D3DDEVICEDESC));

	// If this is a hardware device, we have found what we are looking for
	if(fIsHardware)
		return D3DENUMRET_CANCEL;

	return D3DENUMRET_OK;
}

DWORD FlagsToBitDepth(DWORD dwFlags)
{
		  if(dwFlags & DDBD_1)	return 1;
	else if(dwFlags & DDBD_2)	return 2;
	else if(dwFlags & DDBD_4)	return 4;
	else if(dwFlags & DDBD_8)	return 8;
	else if(dwFlags & DDBD_16) return 16;
	else if(dwFlags & DDBD_24) return 24;
	else if(dwFlags & DDBD_32) return 32;
	else								return 0; // Oh, please...
}

int CreateLight(D3DLIGHT2 &light)
{
	HRESULT ddrval;

	// Create the light
	ddrval = lpD3D->CreateLight(&lpD3DLight[light_count], NULL);
	if(D3D_OK != ddrval)
		return 0;

	ddrval = lpD3DLight[light_count]->SetLight((LPD3DLIGHT)&light);
	if(D3D_OK != ddrval)
		return 0;

	ddrval = lpD3DViewport->AddLight(lpD3DLight[light_count]);
	if(D3D_OK != ddrval)
		return 0;

	light_count++;

	return light_count;
}

void ReleaseLight(int index)
{
	if(NUMBER_OF_LIGHT < index)
		return;

	index--;

	if(NULL != lpD3DLight[index])
	{
		lpD3DViewport->DeleteLight(lpD3DLight[index]);
		Release(lpD3DLight[index]);
	}
}

