#include <dxinput.h>
#include <dx3d.h>

BOOL fIsActive;

LRESULT CALLBACK WndProc (HWND hwnd, UINT iMessage, WPARAM wParam, LPARAM lParam);

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, char *lpszCmdLine, int iCmdShow)
{
	WNDCLASS wndclass;
	MSG		msg;

	char szAppName[] = "Direct X 5 SDK";

	wndclass.style 		  = 0;
	wndclass.lpfnWndProc   = WndProc;
	wndclass.cbClsExtra	  = 0;
	wndclass.cbWndExtra	  = 0;
	wndclass.hInstance	  = hInstance;
	wndclass.hIcon 		  = LoadIcon(NULL, IDI_APPLICATION);
	wndclass.hCursor		  = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass.lpszMenuName  = NULL;
	wndclass.lpszClassName = szAppName;

	RegisterClass(&wndclass);

	HWND hwnd = CreateWindowEx(WS_EX_TOPMOST, szAppName, szAppName,
										WS_POPUP, 0, 0, 640, 480,
										NULL, NULL, hInstance, NULL);

	ShowWindow(hwnd, iCmdShow);
	UpdateWindow(hwnd);

	while(true)
	{
		if(Quit_Program)
		{
			Quit_Program = FALSE;

			SendMessage(hwnd, WM_DESTROY, 0, 0);
		}

		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0 ))
			{
				return msg.wParam;
			}

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else if(fIsActive)
		{
			OnIdle(hwnd);
		}
		else
		{
			WaitMessage();
		}
	}
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT iMessage, WPARAM wParam, LPARAM lParam)
{
	switch(iMessage)
	{
		case WM_CREATE :
			CreateDirectX(((LPCREATESTRUCT)lParam)->hInstance, hwnd);
			return 0;

		case WM_ACTIVATEAPP :
			fIsActive = wParam;

			SyncronizeAcquire(fIsActive);
			return 0;

		case WM_DESTROY :
			ReleaseDirectX();

			PostQuitMessage(0);
			return 0;
	}

	return DefWindowProc(hwnd, iMessage, wParam, lParam);
}

