#include <dx3d.h>

D3DMATRIX identity;

void PrecomputeRadian()
{
	double angle = 0.0;

	double delta = PI2 / D3DVAL(RADIAN);

	for(int i = 0; i < RADIAN; i++)
	{
		cosine[i] = D3DVAL(cos(angle));
		sine[i]	 = D3DVAL(sin(angle));

		angle += delta;
	}

	identity._11 =
	identity._22 =
	identity._33 =
	identity._44 = D3DVAL(1.0);
}

D3DMATRIX CameraView(D3DVECTOR from, D3DVECTOR at, D3DVECTOR up, int roll)
{
	D3DMATRIX view = identity;

	D3DVECTOR view_direction;
	D3DVECTOR right;
	D3DVECTOR really_up;

	view_direction.x = at.x - from.x;
	view_direction.y = at.y - from.y;
	view_direction.z = at.z - from.z;

	view_direction = Normalize(view_direction);

	right 	 = CrossProduct(up, view_direction);
	really_up = CrossProduct(view_direction, right);

	right 	 = Normalize(right);
	really_up = Normalize(really_up);

	view._11 = right.x;
	view._21 = right.y;
	view._31 = right.z;
	view._12 = really_up.x;
	view._22 = really_up.y;
	view._32 = really_up.z;
	view._13 = view_direction.x;
	view._23 = view_direction.y;
	view._33 = view_direction.z;

	view._41 = -DotProduct(right, 			from);
	view._42 = -DotProduct(really_up,		from);
	view._43 = -DotProduct(view_direction, from);

	if(0 != roll)
		view = Multiply4x4Matrix(ConcatenateZRotate(-roll), view);

	return view;
}

D3DMATRIX PerspectiveProjection(D3DVALUE near_plane, D3DVALUE far_plane, int fov)
{
	D3DMATRIX projection = { D3DVAL(0.0), };

	D3DVALUE q = D3DVAL(GetSin(fov) / (1.0 - near_plane / far_plane));

	projection._11 =	GetCos(fov);
	projection._22 =	GetCos(fov);
	projection._33 =	q;
	projection._34 =	GetSin(fov);
	projection._43 = -q * near_plane;

	return projection;
}

D3DMATRIX ConcatenateTransport(D3DVECTOR v)
{
	D3DMATRIX matrix = identity;

	matrix._41 = v.x;
	matrix._42 = v.y;
	matrix._43 = v.z;

	return matrix;
}

D3DMATRIX ConcatenateScale(D3DVALUE scale)
{
	D3DMATRIX matrix = identity;

	matrix._11 = scale;
	matrix._22 = scale;
	matrix._33 = scale;

	return matrix;
}

D3DMATRIX ConcatenateXRotate(int yaw)
{
	D3DMATRIX matrix = identity;

	matrix._22 =  GetCos(yaw);
	matrix._32 = -GetSin(yaw);

	matrix._23 =  GetSin(yaw);
	matrix._33 =  GetCos(yaw);

	return matrix;
}

D3DMATRIX ConcatenateYRotate(int pitch)
{
	D3DMATRIX matrix = identity;

	matrix._11 =  GetCos(pitch);
	matrix._31 =  GetSin(pitch);

	matrix._13 = -GetSin(pitch);
	matrix._33 =  GetCos(pitch);

	return matrix;
}

D3DMATRIX ConcatenateZRotate(int roll)
{
	D3DMATRIX matrix = identity;

	matrix._11 =  GetCos(roll);
	matrix._21 = -GetSin(roll);

	matrix._12 =  GetSin(roll);
	matrix._22 =  GetCos(roll);

	return matrix;
}

D3DMATRIX Multiply4x4Matrix(D3DMATRIX a, D3DMATRIX b)
{
	D3DMATRIX c;

	c._11 = (a._11 * b._11) + (a._12 * b._21) + (a._13 * b._31);
	c._12 = (a._11 * b._12) + (a._12 * b._22) + (a._13 * b._32);
	c._13 = (a._11 * b._13) + (a._12 * b._23) + (a._13 * b._33);
	c._14 = 0;

	c._21 = (a._21 * b._11) + (a._22 * b._21) + (a._23 * b._31);
	c._22 = (a._21 * b._12) + (a._22 * b._22) + (a._23 * b._32);
	c._23 = (a._21 * b._13) + (a._22 * b._23) + (a._23 * b._33);
	c._24 = 0;

	c._31 = (a._31 * b._11) + (a._32 * b._21) + (a._33 * b._31);
	c._32 = (a._31 * b._12) + (a._32 * b._22) + (a._33 * b._32);
	c._33 = (a._31 * b._13) + (a._32 * b._23) + (a._33 * b._33);
	c._34 = 0;

	c._41 = (a._41 * b._11) + (a._42 * b._21) + (a._43 * b._31) + b._41;
	c._42 = (a._41 * b._12) + (a._42 * b._22) + (a._43 * b._32) + b._42;
	c._43 = (a._41 * b._13) + (a._42 * b._23) + (a._43 * b._33) + b._43;
	c._44 = 1;

	return c;
}

D3DVECTOR CrossProduct(D3DVECTOR u, D3DVECTOR v)
{
	D3DVECTOR c;

	c.x = u.y * v.z - u.z * v.y;
	c.y = u.z * v.x - u.x * v.z;
	c.z = u.x * v.y - u.y * v.x;

	return c;
}

D3DVALUE DotProduct(D3DVECTOR u, D3DVECTOR v)
{
	return u.x * v.x + u.y * v.y + u.z * v.z;
}

D3DVECTOR Normalize(D3DVECTOR u)
{
	D3DVALUE s = D3DVAL(sqrt(u.x * u.x + u.y * u.y + u.z * u.z));

	u.x /= s;
	u.y /= s;
	u.z /= s;

	return u;
}

