#include <dx3d.h>

HRESULT MappingData (LPDIRECTDRAWSURFACE &lpDDSurface, LPCSTR lpFileName, int x, int y, int dx, int dy);

HRESULT CreateDirectDrawSurface(LPDIRECTDRAWSURFACE &lpDDSurface, LPCSTR lpFileName, int x, int y, int dx, int dy)
{
	HBITMAP hBitmap = (HBITMAP)LoadImage(NULL, lpFileName, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE | LR_CREATEDIBSECTION);
	if(NULL == hBitmap)
		return DDERR_NOTFOUND;

	BITMAP bitmap;

	// Get size of the bitmap.
	GetObject(hBitmap, sizeof(BITMAP), &bitmap);

	DDSURFACEDESC ddsd;
	memset(&ddsd, 0, sizeof(DDSURFACEDESC));

	ddsd.dwSize 		  = sizeof(DDSURFACEDESC);
	ddsd.dwFlags		  = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwWidth		  = 0 == dx ? bitmap.bmWidth	: dx;
	ddsd.dwHeight		  = 0 == dy ? bitmap.bmHeight : dy;

	HRESULT ddrval;

	ddrval = lpDD->CreateSurface(&ddsd, &lpDDSurface, NULL);
	if(DD_OK != ddrval)
		return ddrval;

	ddrval = DirectDrawCopyBitmap(lpDDSurface, hBitmap, x, y, dx, dy);
	if(DD_OK != ddrval)
	{
		DeleteObject(hBitmap);
		return ddrval;
	}

	DeleteObject(hBitmap);

	// Set of color key.
	DDCOLORKEY ddck;
	ddck.dwColorSpaceHighValue = RGB_MAKE(0, 0, 0);
	ddck.dwColorSpaceLowValue	= ddck.dwColorSpaceHighValue;

	ddrval = lpDDSurface->SetColorKey(DDCKEY_SRCBLT, &ddck);
	if(DD_OK != ddrval)
		return ddrval;

	return DD_OK;
}

HRESULT DirectDrawCopyBitmap(LPDIRECTDRAWSURFACE &lpDDSurface, HBITMAP hBitmap, int x, int y, int dx, int dy)
{
	if(NULL == hBitmap || NULL == lpDDSurface)
		return DDERR_NOTFOUND;

	// Make sure this surface is restored.
	lpDDSurface->Restore();

	// Select bitmap into a memory device context so we can use it.
	HDC hdcImage = CreateCompatibleDC(NULL);
	if(NULL == hdcImage)
		return DDERR_NOTFOUND;

	SelectObject(hdcImage, hBitmap);

	DDSURFACEDESC ddsd;
	ddsd.dwSize  = sizeof(DDSURFACEDESC);
	ddsd.dwFlags = DDSD_HEIGHT | DDSD_WIDTH;

	// Get size of surface.
	lpDDSurface->GetSurfaceDesc(&ddsd);

	HDC hdc;
	HRESULT ddrval = lpDDSurface->GetDC(&hdc);
	if(DD_OK != ddrval)
		return ddrval;

	BitBlt(hdc, 0, 0, ddsd.dwWidth, ddsd.dwHeight, hdcImage, x, y, SRCCOPY);
	lpDDSurface->ReleaseDC(hdc);

	DeleteDC(hdcImage);

	return DD_OK;
}

HRESULT RestoreDirectDrawSurface(LPDIRECTDRAWSURFACE &lpDDSurface, LPCSTR lpFileName, int x, int y, int dx, int dy)
{
	HRESULT ddrval = lpDDSurface->Restore();
	if(DD_OK != ddrval)
		return ddrval;

	return MappingData(lpDDSurface, lpFileName, x, y, dx, dy);
}

HRESULT MappingData(LPDIRECTDRAWSURFACE &lpDDSurface, LPCSTR lpFileName, int x, int y, int dx, int dy)
{
	// Try to load the bitmap as a file
	HBITMAP hBitmap = (HBITMAP)LoadImage(NULL, lpFileName, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE | LR_CREATEDIBSECTION);

	if(NULL == hBitmap)
		return DDERR_NOTFOUND;

	HRESULT ddrval = DirectDrawCopyBitmap(lpDDSurface, hBitmap, x, y, dx, dy);
	if(DD_OK != ddrval)
		return ddrval;

	DeleteObject(hBitmap);

	return DD_OK;
}

