#include <mmstream.h>
#include <amstream.h>
#include <ddstream.h>
#include <dxinput.h>
#include <dx3d.h>

IMultiMediaStream 		*lpMMStream;

IMediaStream				*lpPrimaryVideoStream;
IDirectDrawMediaStream	*lpDDMStream;
IDirectDrawStreamSample *lpDDSSample;

BOOL VideoLoad(LPCSTR lpFileName, BOOL fIsPlay)
{
	if(!Stop_Video)
		VideoStop();

	CoInitialize(NULL);

	IAMMultiMediaStream *lpAMMMStream;

	CoCreateInstance(CLSID_AMMultiMediaStream, NULL, CLSCTX_INPROC_SERVER,
		IID_IAMMultiMediaStream, (LPVOID *)&lpAMMMStream);

	WCHAR wPath[MAX_PATH];
	MultiByteToWideChar(CP_ACP, 0, lpFileName, -1, wPath, sizeof(wPath) / sizeof(wPath[0]));

	lpAMMMStream->Initialize(STREAMTYPE_READ, AMMSF_NOGRAPHTHREAD, NULL);

	lpAMMMStream->AddMediaStream(lpDDSurfacePrimary, &MSPID_PrimaryVideo, 0, NULL);
	lpAMMMStream->AddMediaStream(NULL,					 &MSPID_PrimaryAudio, AMMSF_ADDDEFAULTRENDERER, NULL);
	lpAMMMStream->AddMediaStream(NULL,					 &MSPID_PrimaryAudio, AMMSF_ADDDEFAULTRENDERER, NULL);

	lpAMMMStream->OpenFile(wPath, AMMSF_RENDERTOEXISTING);

	lpMMStream = lpAMMMStream;

	if(fIsPlay)
		VideoPlay();

	return TRUE;
}

BOOL VideoPlay()
{
	Stop_Video = FALSE;

	ClearScreen();

	lpMMStream->GetMediaStream(MSPID_PrimaryVideo, &lpPrimaryVideoStream);
	lpPrimaryVideoStream->QueryInterface(IID_IDirectDrawMediaStream, (LPVOID *)&lpDDMStream);

	DDSURFACEDESC ddsd;
	memset(&ddsd, 0, sizeof(DDSURFACEDESC));

	ddsd.dwSize = sizeof(DDSURFACEDESC);
	lpDDMStream->GetFormat(&ddsd, NULL, NULL, NULL);

	RECT rect;
	rect.left	= 320 - (ddsd.dwWidth  / 2);
	rect.top 	= 240 - (ddsd.dwHeight / 2);
	rect.right	= rect.left + ddsd.dwWidth;
	rect.bottom = rect.top + ddsd.dwHeight;

	lpDDMStream->CreateSample(lpDDSurfacePrimary, &rect, 0, &lpDDSSample);
	lpMMStream->SetState(STREAMSTATE_RUN);

	VideoUpdate();

	return TRUE;
}

BOOL VideoUpdate()
{
	if(S_OK != lpDDSSample->Update(0, NULL, NULL, NULL))
	{
		VideoStop();

		return FALSE;
	}

	LPBYTE diKeyboard = GetKeyboardData();
	if(diKeyboard[DIK_ESCAPE])
		VideoStop();

	return TRUE;
}

BOOL VideoStop()
{
	if(Stop_Video)
		return TRUE;

	Stop_Video = TRUE;

	lpMMStream->SetState(STREAMSTATE_STOP);

	Release(lpDDSSample);
	Release(lpDDMStream);
	Release(lpPrimaryVideoStream);

	Release(lpMMStream);

	CoUninitialize();

	ClearScreen();

	return TRUE;
}

