#ifndef __DIRECT3D_H
#define __DIRECT3D_H

#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <vfw.h>
#include <ddraw.h>
#include <d3d.h>

#define RADIAN 0x0800
#define PI2 	6.28318530718

#define Release(x);		\
	if(NULL != x)			\
	{							\
		(x)->Release();	\
		x = NULL;			\
	}

#define GetCos(cos) cosine[(cos) & 0x07FF]
#define GetSin(sin) sine[(sin) & 0x07FF]

typedef struct _D3DTEXTUREMATERIAL
{
	LPDIRECTDRAWSURFACE lpDDSurfaceSystem;
	LPDIRECTDRAWSURFACE lpDDSurfaceVideo;

	D3DTEXTUREHANDLE	  hD3DTexture;

	LPDIRECT3DMATERIAL2 lpD3DMaterial;
	D3DMATERIALHANDLE   hD3DMaterial;
} D3DTEXTUREMATERIAL, *LPD3DTEXTUREMATERIAL;

// main.cpp
extern BOOL 					Quit_Program;

// ddraw.cpp
extern LPDIRECTDRAW			lpDD;
extern LPDIRECTDRAW2 		lpDD2;

extern LPDIRECTDRAWSURFACE lpDDSurfacePrimary;
extern LPDIRECTDRAWSURFACE lpDDSurfaceBackBuffer;

// d3d.cpp
extern LPDIRECT3D2			lpD3D;
extern LPDIRECT3DDEVICE2	lpD3DDevice;
extern LPDIRECT3DVIEWPORT2 lpD3DViewport;

extern LPDIRECTDRAWSURFACE lpDDSurfaceZBuffer;

extern D3DDEVICEDESC 		d3dHALDeviceDesc;

// avi.cpp
extern BOOL 					Stop_AVI;

// video.cpp
extern BOOL 					Stop_Video;

// matrix.cpp
extern D3DVALUE				cosine[RADIAN];
extern D3DVALUE				sine	[RADIAN];


// onidle.cpp
void		 OnIdle							(HWND hwnd);

void		 CreateDirectX 				(HINSTANCE hInstance, HWND hwnd);
void		 RestoreDirectX				();
void		 ReleaseDirectX				();

// ddraw.cpp
HRESULT	 CreateDirectDraw 			(HWND hwnd);
HRESULT	 RestoreDirectDraw			();
void		 ReleaseDirectDraw			();

HRESULT	 Flip 							();
HRESULT	 ClearScreen					();

// ddsurface.cpp
HRESULT	 CreateDirectDrawSurface	(LPDIRECTDRAWSURFACE &lpDDSurface, LPCSTR lpFileName, int x = 0, int y = 0, int dx = 0, int dy = 0);
HRESULT	 RestoreDirectDrawSurface	(LPDIRECTDRAWSURFACE &lpDDSurface, LPCSTR lpFileName, int x = 0, int y = 0, int dx = 0, int dy = 0);

HRESULT	 DirectDrawCopyBitmap		(LPDIRECTDRAWSURFACE &lpDDSurface, HBITMAP hBitmap,	int x = 0, int y = 0, int dx = 0, int dy = 0);

// d3d.cpp
HRESULT	 CreateDirect3D				();
void		 ReleaseDirect3D				();

int		 CreateLight					(D3DLIGHT2 &light);
void		 ReleaseLight					(int index);

// material.cpp
HRESULT	 CreateMaterial				(D3DTEXTUREMATERIAL &material, D3DCOLORVALUE diffuse, D3DCOLORVALUE ambient, D3DCOLORVALUE specular, LPCSTR lpFileName, int x = 0, int y = 0, int dx = 0, int dy = 0);
HRESULT	 RestoreMaterial				(D3DTEXTUREMATERIAL &material);
void		 ReleaseMaterial				(D3DTEXTUREMATERIAL &material);

// error.cpp
BOOL		 ErrorHandling 				(HWND hwnd, HRESULT hResult);

// fps.cpp
int		 GetFPS							();

// avi.cpp
HRESULT	 AVILoad 						(LPCSTR lpFileName, BOOL fIsPlay = TRUE);
HRESULT	 AVIPlay 						();
void		 AVIStop 						();

// video.cpp
BOOL      VideoLoad 						(LPCSTR lpFileName, BOOL fIsPlay = TRUE);
BOOL      VideoPlay 						();
BOOL      VideoUpdate					();
BOOL      VideoStop						();

// matrix.cpp
void		 PrecomputeRadian 			();
D3DMATRIX CameraView 					(D3DVECTOR from, D3DVECTOR at, D3DVECTOR up, int roll);
D3DMATRIX PerspectiveProjection		(D3DVALUE  near_plane, D3DVALUE far_plane, int fov);

D3DMATRIX ConcatenateTransport		(D3DVECTOR v);
D3DMATRIX ConcatenateScale 			(D3DVALUE  scale);
D3DMATRIX ConcatenateXRotate			(int		  yaw);
D3DMATRIX ConcatenateYRotate			(int		  pitch);
D3DMATRIX ConcatenateZRotate			(int		  roll);
D3DMATRIX ConcatenateRTS				(int yaw, int pitch, int roll, D3DVECTOR v, D3DVALUE scale = 0.0);

D3DMATRIX Multiply4x4Matrix			(D3DMATRIX a, D3DMATRIX b);
D3DVECTOR CrossProduct					(D3DVECTOR u, D3DVECTOR v);
D3DVALUE  DotProduct 					(D3DVECTOR u, D3DVECTOR v);
D3DVECTOR Normalize						(D3DVECTOR u);

#endif

