#ifndef __WAVE_H
#define __WAVE_H

#include <dxsound.h>

class CWave
{
	public:
		CWave 			  ();
		CWave 			  (LPCSTR lpFileName);

		~CWave			  ();

		BOOL	Create	  (LPCSTR lpFileName);

		BOOL	GetFormat  (WAVEFORMATEX& wfFormat) const;
		DWORD GetDataLen () const;
		DWORD GetData	  (BYTE*& pWaveData, DWORD dwMaxToCopy) const;

		BOOL	Play		  (BOOL bAsync = TRUE, BOOL bLooped = FALSE) const;

	private:
		BOOL	IsValid	  () const;
		BOOL	Free		  ();

		BYTE	*m_pImageData;
		DWORD m_dwImageLen;
};

#endif

