#include "geometri.h"

inline min(int a, int b)
{
	if ( a < b ) return a;
    else return b;
}

inline swap(int& a, int& b)
{
	int t = a;
    a = b;
    b = t;
}

int intersectLine(int p1x, int p1y, int p2x, int p2y, int p3x, int p3y, int p4x, int p4y)
{
    if ( p1x > p2x )
    {
    	swap(p1x, p2x);
        swap(p1y, p2y);
    }
    if ( p3x > p4x )
    {
    	swap(p3x, p4x);
        swap(p3y, p4y);
    }

    int r123 = ccw(p1x, p1y, p2x, p2y, p3x, p3y);
    int r124 = ccw(p1x, p1y, p2x, p2y, p4x, p4y);
    int r341 = ccw(p3x, p3y, p4x, p4y, p1x, p1y);
    int r342 = ccw(p3x, p3y, p4x, p4y, p2x, p2y);

    if ( (long long)r123 * r124 < 0 && (long long)r341 * r342 < 0 ) return 1;
    else if ( r123 == 0 )
    {
    	if ( r124 == 0 )
	    {
	    	if ( p3x <= p2x && p1x <= p4x ) return -1;
            else return 0;
	    }
        else if ( p1x <= p3x && p3x <= p2x ) return -1;
        else return 0;
    }
    else if ( r124 == 0 )
    {
    	if ( p1x <= p4x && p4x <= p2x ) return -1;
        else return 0;
    }
    else if ( r341 == 0 )
    {
    	if ( p3x <= p1x && p1x <= p4x ) return -1;
        else return 0;
    }
    else if ( r342 == 0 )
    {
    	if ( p3x <= p2x && p2x <= p4x ) return -1;
        else return 0;
    }

    return 0;
}

bool insidePolygon(int n, int p[], int x, int y, int maxx)
{
	int i;
    int count = 0;
    int ic;

    maxx = 3000;

    for ( i = 0; i < n-1; i ++ )
    {
    	ic = intersectLine(x, y, maxx, y, p[i*2], p[i*2+1], p[i*2+2], p[i*2+3]);

        if ( ic > 0 ) count ++;
        else if ( ic < 0 && min(p[i*2+1], p[i*2+3]) == y && p[i*2+1] != p[i*2+3] ) count ++;
    }

   	ic = intersectLine(x, y, maxx, y, p[i*2], p[i*2+1], p[0], p[1]);

    if ( ic > 0 ) count ++;
    else if ( ic < 0 && min(p[i*2+1], p[1]) == y && p[i*2+1] != p[1] ) count ++;

    return (count % 2 != 0);
}


