#if !(defined __MAP_H)

#define __MAP_H

#include <string.h>

#include "mapelem.h"

#define MAX_MAP_XS 2000
#define MAX_MAP_YS 2000

#define MIN_MAP_HEIGHT -3
#define MAX_MAP_HEIGHT 10

class Map
{
	friend class MapView;
public:
	Map() : mapdata(NULL), xs(0), ys(0) { };
    Map(int xsize, int ysize)
    : xs(xsize), ys(ysize), mapdata(new MapElem[(xsize+1)*(ysize+1)]) // never use xs*ys to initialize mapdata on this line - DJGPP bug?
    {
    	realxs = xsize+1;
        realys = ysize+1;
    }

    Map(Map& m) { copy(m); }
    Map& operator= (Map& m)
    {
    	copy(m);
    	return *this;
   	}

    int getXSize() const { return xs; }
    int getYSize() const { return ys; }
    MapElem getMapElem(int x, int y) const { return (mapdata[y*realxs + x]); }

    void setHeight(int xp, int yp, int h)
    {
        if ( h > MAX_MAP_HEIGHT ) h = MAX_MAP_HEIGHT;
        else if ( h < MIN_MAP_HEIGHT ) h = MIN_MAP_HEIGHT;
        getMapElemRef(xp, yp).height = h;
    }

    void raise(int xp, int yp)
    {
		if ( getMapElemRef(xp,yp).getHeight() < MAX_MAP_HEIGHT ) getMapElemRef(xp,yp).height ++;
    }

    void deepen(int xp,int yp)
    {
		if ( getMapElemRef(xp,yp).getHeight() > MIN_MAP_HEIGHT ) getMapElemRef(xp,yp).height --;
    }


    virtual ~Map() { delete [] mapdata; }

private:
	MapElem* mapdata;
    int xs, ys;
    int realxs, realys;

    MapElem& getMapElemRef(int x, int y) { return (mapdata[y*realxs + x]); }

protected:
    void copy(Map& m)
    {
    	xs = m.xs;
        ys = m.ys;
    	mapdata = new MapElem[realxs * realys];

        memcpy( mapdata, m.mapdata, (size_t)sizeof(MapElem)*realxs*realys );
    }
};

#endif
