#include "mapview.h"
#include "geometric.h"

int MapView::deltax[TILE_WIDTH*2-1][TILE_WIDTH*2-1];
int MapView::deltay[TILE_WIDTH*2-1][TILE_WIDTH*2-1];
int MapView::deltah[MAX_MAP_HEIGHT+MIN_MAP_HEIGHT];
int MapView::multblx[MAX_MAP_XS];
int MapView::multbly[MAX_MAP_YS];

#define DELTA_PREC TILE_WIDTH

void MapView::recalcTable()
{
	int modx, mody;
    for ( mody = -TILE_WIDTH+1; mody < TILE_WIDTH; mody ++ )
    {
    	for ( modx = -TILE_WIDTH+1; modx < TILE_WIDTH; modx ++ )
        {
		    deltax[mody+TILE_WIDTH-1][modx+TILE_WIDTH-1] = -(modx * HALF_TILE_XS - mody * HALF_TILE_XS)*DELTA_PREC / TILE_WIDTH + TILE_XS*DELTA_PREC;
		    deltay[mody+TILE_WIDTH-1][modx+TILE_WIDTH-1] = -(modx * HALF_TILE_YS + mody * HALF_TILE_YS)*DELTA_PREC / TILE_WIDTH - TILE_YS*DELTA_PREC;
        }
    }

    int i;
    for ( i = MIN_MAP_HEIGHT; i <= MAX_MAP_HEIGHT; i ++ )
    {
    	deltah[i-MIN_MAP_HEIGHT] = - i * TILE_HEIGHT;
    }

    for ( i = 0; i < MAX_MAP_XS; i ++ ) multblx[i] = i * HALF_TILE_XS;
    for ( i = 0; i < MAX_MAP_YS; i ++ ) multbly[i] = i * HALF_TILE_YS;
}

void MapView::initTable()
{
	bool initialized = false;

    if ( !initialized )
    {
    	recalcTable();
        initialized = true;
    }
}

void MapView::render(int xp, int yp) const
{
    int modx = xp % TILE_WIDTH;
    int mody = yp % TILE_WIDTH;

    int curX = screen->w + deltax[mody+TILE_WIDTH-1][modx+TILE_WIDTH-1] / DELTA_PREC;
    int curY = -HALF_TILE_YS + deltay[mody+TILE_WIDTH-1][modx+TILE_WIDTH-1] / DELTA_PREC - MIN_MAP_HEIGHT * TILE_HEIGHT;

	int i, j;
    int tmpX = 0, tmpY = 0;

    int mxs = map->getXSize() - 1;
    int mys = map->getYSize();

    xp /= TILE_WIDTH;
    yp /= TILE_WIDTH;

    int realdstx = xp+1;
    int finaldstx;

	/***********************************************/
    /*\                       \                    */
    /*  \                       \      Phrase 1    */
    /*    \                       \                */
    /*      \                       \              */
    /*        \        Phrase 2       \            */
    /*          \                       \          */
    /*            \                       \        */
    /*              \                       \      */
    /*                \                       \    */
    /*   Phrase 3       \                       \  */
    /*                    \                       \*/
	/***********************************************/

    if ( yp >= 0 && xp >= 0 ) // non-negative coords
    {
	    // Phrase 1
	    for ( i = yp; tmpY <= Y_BOUNDARY; i ++ )
		{
	    	if ( i >= mys ) return;
	    	tmpX = curX;
	        tmpY = curY;

            if ( realdstx <= mxs ) finaldstx = realdstx;
            else finaldstx = mxs;

			for ( j = xp; j <= finaldstx; j ++ )
			{
	            drawTile(j, i, tmpX, tmpY);
	            tmpX += HALF_TILE_XS;
	            tmpY += HALF_TILE_YS;
			}


	        if ( xp >= 1 )
	        {
	            curX -= TILE_XS;
	        	xp --;
	        }
	        else
	        {
		        curX -= HALF_TILE_XS;
		        curY += HALF_TILE_YS;
	        }

			realdstx ++;
		}

	    // Phrase 2
	    for ( ; curX >= 0; i ++ )
		{
	    	if ( i >= mys ) return;
	    	tmpX = curX;
	        tmpY = curY;

            if ( realdstx <= mxs ) finaldstx = realdstx;
            else finaldstx = mxs;

			for ( j = xp; j <= finaldstx; j ++ )
			{
	            drawTile(j, i, tmpX, tmpY);

	            tmpX += HALF_TILE_XS;
	            tmpY += HALF_TILE_YS;
			}


	        if ( xp >= 1 )
	        {
	            curX -= TILE_XS;
	        	xp --;
	        }
	        else
	        {
		        curX -= HALF_TILE_XS;
		        curY += HALF_TILE_YS;
	        }

	        realdstx --;
		}

	    // Phrase 3
	    for ( ; xp <= realdstx; i ++ )
		{
	    	if ( i >= mys ) return;
	    	tmpX = curX;
	        tmpY = curY;

            if ( realdstx <= mxs ) finaldstx = realdstx;
            else finaldstx = mxs;

			for ( j = xp; j <= finaldstx; j ++ )
			{
	            drawTile(j, i, tmpX, tmpY);

	            tmpX += HALF_TILE_XS;
	            tmpY += HALF_TILE_YS;
			}

	        xp ++;
	        curY += TILE_YS;

			realdstx --;
		}
    }
    else // negative coords
    {
	    // Phrase 1
	    for ( i = yp; tmpY <= Y_BOUNDARY; i ++ )
		{
	    	if ( i >= mys ) return;
	    	tmpX = curX;
	        tmpY = curY;
	        if ( i >= 0 )
	        {
		        if ( xp < 0 )
		        {
		            tmpX += multblx[-xp]; //+= -HALF_TILE_XS * xp;
		            tmpY += multbly[-xp]; //+= -HALF_TILE_YS * xp;
		            j = 0;
		        }
		        else j = xp;

	            if ( realdstx <= mxs ) finaldstx = realdstx;
	            else finaldstx = mxs;

				for ( ; j <= finaldstx; j ++ )
				{
		            drawTile(j, i, tmpX, tmpY);

		            tmpX += HALF_TILE_XS;
		            tmpY += HALF_TILE_YS;
				}
            }

	        if ( xp >= 1 )
	        {
	            curX -= TILE_XS;
	        	xp --;
	        }
	        else
	        {
    	        curX -= HALF_TILE_XS;
		        curY += HALF_TILE_YS;
	        }

			realdstx ++;
		}

	    // Phrase 2
	    for ( ; curX >= 0; i ++ )
		{
	    	if ( i >= mys ) return;
	    	tmpX = curX;
	        tmpY = curY;

	        if ( i >= 0 )
	        {
		        if ( xp < 0 )
		        {
		            tmpX += multblx[-xp]; //+= -HALF_TILE_XS * xp;
		            tmpY += multbly[-xp]; //+= -HALF_TILE_YS * xp;
		            j = 0;
		        }
		        else j = xp;

	            if ( realdstx <= mxs ) finaldstx = realdstx;
	            else finaldstx = mxs;

				for ( ; j <= finaldstx; j ++ )
				{
		            drawTile(j, i, tmpX, tmpY);

		            tmpX += HALF_TILE_XS;
		            tmpY += HALF_TILE_YS;
				}
	        }

	        if ( xp >= 1 )
	        {
	            curX -= TILE_XS;
	        	xp --;
	        }
	        else
	        {
		        curX -= HALF_TILE_XS;
		        curY += HALF_TILE_YS;
	        }

	        realdstx --;
		}

	    // Phrase 3
	    for ( ; xp <= realdstx; i ++ )
		{
	    	if ( i >= mys ) return;
	    	tmpX = curX;
	        tmpY = curY;

	        if ( i >= 0 )
	        {
		        if ( xp < 0 )
		        {
		            tmpX += multblx[-xp]; // += -HALF_TILE_XS * xp;
		            tmpY += multbly[-xp]; // += -HALF_TILE_YS * xp;
		            j = 0;
		        }
		        else j = xp;

	            if ( realdstx <= mxs ) finaldstx = realdstx;
	            else finaldstx = mxs;

				for ( ; j <= finaldstx; j ++ )
				{
		            drawTile(j, i, tmpX, tmpY);

		            tmpX += HALF_TILE_XS;
		            tmpY += HALF_TILE_YS;
				}
	        }

	        xp ++;
	        curY += TILE_YS;

			realdstx --;
		}
	}
}

static inline int getLightness(int uh, int lh, int rh, int dh)
{
    int col = (( ((rh + dh) - (uh + lh)) * TILE_HEIGHT / 2 ) + 255)/2;

    // distinguish angled flat tiles
    if ( uh + rh > dh + lh ) col -= col/10; //col -= 8;
    else if ( uh + rh < dh + lh ) col += col/10; //col += 8;

    if ( uh + lh > rh + dh ) col -= col/10; //col -= 8;
    else if ( uh + lh < rh + dh ) col += col/10; //col += 8;

    if ( col > 255-25 ) col = 255-25;
    else if ( col < 48 ) col = 48;
    return ( col );
}

inline bool MapView::clicked(int x, int y, int xp, int yp, int rx, int ry) const
{
	if ( xp < 0 || xp >= map->getXSize() || yp < 0 || yp >= map->getYSize() ) return false;

    bool result;

	int poly[8];

    int uh = map->getMapElemRef( xp, yp ).getHeight();
    int lh = map->getMapElemRef( xp, yp+1 ).getHeight();
    int rh = map->getMapElemRef( xp+1, yp ).getHeight();
    int dh = map->getMapElemRef( xp+1, yp+1 ).getHeight();

    int delta1 = uh+dh;
    int delta2 = lh+rh;

    if ( delta1 == delta2 ) // flat. no slash needed
    {
		poly[0] = poly[4] = x;
		poly[2] = x - HALF_TILE_XS;
		poly[6] = x + HALF_TILE_XS;

		poly[1] = y + deltah[ uh - MIN_MAP_HEIGHT];
		poly[3] = y+HALF_TILE_YS + deltah[ lh - MIN_MAP_HEIGHT];
	    poly[7] = y+HALF_TILE_YS + deltah[ rh - MIN_MAP_HEIGHT];
	    poly[5] = y+TILE_YS + deltah[ dh - MIN_MAP_HEIGHT];

        result = insidePolygon(4, poly, rx, ry, screen->h);
    }
    else if ( delta1 > delta2 ) // left to right slash
    {
		poly[0] = poly[6] = x;
		poly[2] = x - HALF_TILE_XS;
		poly[4] = x + HALF_TILE_XS;

		poly[1] = y + deltah[ uh - MIN_MAP_HEIGHT];
		poly[3] = y+HALF_TILE_YS + deltah[ lh - MIN_MAP_HEIGHT];
	    poly[5] = y+HALF_TILE_YS + deltah[ rh - MIN_MAP_HEIGHT];
	    poly[7] = y+TILE_YS + deltah[ dh - MIN_MAP_HEIGHT];

		result = insidePolygon(3, poly, rx, ry, screen->h) ||
                 insidePolygon(3, poly+2, rx, ry, screen->h);
    }
    else // up-to-down slash
    {
		poly[2] = poly[4] = x;
		poly[0] = x - HALF_TILE_XS;
		poly[6] = x + HALF_TILE_XS;

		poly[3] = y + deltah[ uh - MIN_MAP_HEIGHT];
		poly[1] = y+HALF_TILE_YS + deltah[ lh - MIN_MAP_HEIGHT];
	    poly[7] = y+HALF_TILE_YS + deltah[ rh - MIN_MAP_HEIGHT];
	    poly[5] = y+TILE_YS + deltah[ dh - MIN_MAP_HEIGHT];

		result = insidePolygon(3, poly, rx, ry, screen->h) ||
                 insidePolygon(3, poly+2, rx, ry, screen->h);
    }
    if ( result )
    {
    	int oy = y + deltah[ uh - MIN_MAP_HEIGHT];
    	rectfill(screen, x-1, oy-1, x+1, oy+1, 255);
    }
    return result;
}

void MapView::getMapPos(int xp, int yp, int rx, int ry, int& mx, int& my)
{
    int modx = xp % TILE_WIDTH;
    int mody = yp % TILE_WIDTH;

    int curX = screen->w + deltax[mody+TILE_WIDTH-1][modx+TILE_WIDTH-1] / DELTA_PREC;
    int curY = -HALF_TILE_YS + deltay[mody+TILE_WIDTH-1][modx+TILE_WIDTH-1] / DELTA_PREC - MIN_MAP_HEIGHT * TILE_HEIGHT;

	int i, j;
    int tmpX = 0, tmpY = curY;

    int mxs = map->getXSize() - 1;
    int mys = map->getYSize();

    xp /= TILE_WIDTH;
    yp /= TILE_WIDTH;

    for ( tmpX = curX-TILE_XS; tmpX > -TILE_XS; tmpX -= TILE_XS )
    {
    	yp++;
        xp--;
    	if ( rx >= tmpX ) break;
    }

    if ( i > -TILE_XS ) // found matches
    {
//    	tmpX += TILE_XS;
//      xp++;
//      yp--;

    	for ( ; tmpY <= Y_BOUNDARY; )
        {
        	if ( clicked(tmpX, tmpY, xp, yp, rx, ry) )
            {
                mx = xp;
                my = yp;
                return;
            }
            else if ( clicked(tmpX+TILE_XS, tmpY, xp+1, yp-1, rx, ry) )
            {
                mx = xp+1;
                my = yp-1;
                return;
            }
            else if ( clicked(tmpX+HALF_TILE_XS, tmpY+HALF_TILE_YS, xp+1, yp, rx, ry) )
            {
                mx = xp+1;
                my = yp;
                return;
            }
            xp++;
            yp++;
            tmpY += TILE_YS;
        }
    }
    mx = -1;
    my = -1;
}

inline void MapView::drawTile(int tx, int ty, int x, int y) const
{
	int poly[8];

    int uh = map->getMapElemRef( tx, ty ).getHeight();
    int lh = map->getMapElemRef( tx, ty+1 ).getHeight();
    int rh = map->getMapElemRef( tx+1, ty ).getHeight();
    int dh = map->getMapElemRef( tx+1, ty+1 ).getHeight();

    int delta1 = uh+dh;
    int delta2 = lh+rh;

    if ( delta1 == delta2 ) // flat. no slash needed
    {
		poly[0] = poly[4] = x;
		poly[2] = x - HALF_TILE_XS;
		poly[6] = x + HALF_TILE_XS;

		poly[1] = y + deltah[ uh - MIN_MAP_HEIGHT];
		poly[3] = y+HALF_TILE_YS + deltah[ lh - MIN_MAP_HEIGHT];
	    poly[7] = y+HALF_TILE_YS + deltah[ rh - MIN_MAP_HEIGHT];
	    poly[5] = y+TILE_YS + deltah[ dh - MIN_MAP_HEIGHT];

	    int col = getLightness(uh, lh, rh, dh);
	    polygon(screen, 4, poly, col);
        //polygon2d(screen, 4, poly, texture);

        if ( drawgrid )
        {
			col += 20;
			line(screen, poly[0], poly[1], poly[2], poly[3], col);

//			skip drawing some lines for the better performance
//			rightmost/downmost lines aren't drawn
//			but it doesn't seem to be ugly

//	 		line(screen, poly[2], poly[3], poly[4], poly[5], col);
//			line(screen, poly[4], poly[5], poly[6], poly[7], col);

			line(screen, poly[6], poly[7], poly[0], poly[1], col);
		}
    }
    else if ( delta1 > delta2 ) // left to right slash
    {
		poly[0] = poly[6] = x;
		poly[2] = x - HALF_TILE_XS;
		poly[4] = x + HALF_TILE_XS;

		poly[1] = y + deltah[ uh - MIN_MAP_HEIGHT];
		poly[3] = y+HALF_TILE_YS + deltah[ lh - MIN_MAP_HEIGHT];
	    poly[5] = y+HALF_TILE_YS + deltah[ rh - MIN_MAP_HEIGHT];
	    poly[7] = y+TILE_YS + deltah[ dh - MIN_MAP_HEIGHT];

        int col1 = getLightness(uh, lh, rh, rh-(uh-lh));
        int col2 = getLightness(lh+(rh-dh), lh, rh, dh);

		polygon(screen, 3, poly, col1);
        polygon(screen, 3, poly+2, col2);

        if ( drawgrid )
        {
			col1 += 20;
	        col2 += 20;
			line(screen, poly[0], poly[1], poly[2], poly[3], col1);
		    line(screen, poly[0], poly[1], poly[4], poly[5], col1);
		    line(screen, poly[2], poly[3], poly[4], poly[5], col2); // slash
//			line(screen, poly[4], poly[5], poly[6], poly[7], col2);
//			line(screen, poly[6], poly[7], poly[4], poly[5], col2);
		}
    }
    else // up-to-down slash
    {
		poly[2] = poly[4] = x;
		poly[0] = x - HALF_TILE_XS;
		poly[6] = x + HALF_TILE_XS;

		poly[3] = y + deltah[ uh - MIN_MAP_HEIGHT];
		poly[1] = y+HALF_TILE_YS + deltah[ lh - MIN_MAP_HEIGHT];
	    poly[7] = y+HALF_TILE_YS + deltah[ rh - MIN_MAP_HEIGHT];
	    poly[5] = y+TILE_YS + deltah[ dh - MIN_MAP_HEIGHT];

        int col1 = getLightness(uh, lh, dh+(uh-lh), dh);
        int col2 = getLightness(uh, uh-(rh-dh), rh, dh);

		polygon(screen, 3, poly, col1);
        polygon(screen, 3, poly+2, col2);

        if ( drawgrid )
        {
			col1 += 20;
	        col2 += 20;
			line(screen, poly[2], poly[3], poly[6], poly[7], col2);
//		    line(screen, poly[6], poly[7], poly[4], poly[5], col1);
		    line(screen, poly[2], poly[3], poly[4], poly[5], col2); // slash
			line(screen, poly[2], poly[3], poly[0], poly[1], col1);
//			line(screen, poly[0], poly[1], poly[4], poly[5], col2);
		}
    }
}
