#if !(defined __MAPVIEW_H)

#define __MAPVIEW_H

#include <allegro.h>

#include "map.h"

class MapView
{
public:
    MapView(Map& m, BITMAP* btm)
    : map(&m), screen(btm)
    {
    	MapView::initTable();
		Y_BOUNDARY = screen->h + TILE_YS + MAX_MAP_HEIGHT*TILE_HEIGHT;
        drawgrid = false;
    }

	// no copy constructor, no assignment operator needed

	static void recalcTable();
    void setGrid(bool g) { drawgrid = g; }

    void getMapPos(int xp, int yp, int rx, int ry, int& mx, int& my);

    void render(int xp, int yp) const;
    BITMAP* getBitmap() { return screen; }

    virtual ~MapView() { }

private:
	BITMAP* screen;
    Map* map;
	int Y_BOUNDARY;
    bool drawgrid;

    inline void drawTile(int tx, int ty, int x, int y) const;
    inline bool clicked(int x, int y, int xp, int yp, int rx, int ry) const;

    // look-up tables substituing '*' operators
    static int deltax[TILE_WIDTH*2-1][TILE_WIDTH*2-1];
    static int deltay[TILE_WIDTH*2-1][TILE_WIDTH*2-1];
    static int deltah[MAX_MAP_HEIGHT+MIN_MAP_HEIGHT];
	static int multblx[MAX_MAP_XS];
	static int multbly[MAX_MAP_YS];

    static void initTable();
};

#endif

