#include <iostream.h>
#include <ctype.h>
#include <stdio.h>
#include <conio.h>
#include <pc.h>
#include <time.h>
#include <values.h>

#include <allegro.h>

#include "tile.h"
#include "map.h"
#include "mapview.h"

#define MAPXS 100
#define MAPYS 100

int RESX = 640;
int RESY = 480;

Map map(MAPXS, MAPYS);
MapView* view;
BITMAP* bufscr;
BITMAP* cursor;

void setGrid()
{
	static bool grid = false;
    view->setGrid(grid);
    grid = ! grid;
}

void makePalette()
{
	static int type = 0;

    int i;
    RGB c;

    vsync();
    for ( i = 0; i < 256; i ++ )
    {
    	c.r = c.g = c.b = i/4;
        if ( type & 1 )	c.r = i/32;
        if ( type & 2 )	c.g = i/32;
        if ( type & 4 )	c.b = i/32;
    	set_color(i, &c);
    }

    type ++;
}

void initGraph()
{
	allegro_init();
    set_color_depth(8);
    if ( set_gfx_mode(GFX_AUTODETECT, RESX, RESY, 0, 0) < 0 )
    {
    	cout << "ALLEGRO: " << allegro_error << endl;
        exit(0);
    }
    bufscr = create_bitmap(RESX, RESY);
    clear(bufscr);

    view = new MapView(map, bufscr);
    setGrid();

    makePalette();
}

void initMouse()
{
	cursor = create_bitmap(17,17);

    i_love_bill = true;
    install_mouse();

    clear(cursor);
    hline(cursor, 0, 8, 16, 255);
    vline(cursor, 8, 0, 16, 255);
}

void closeGraph()
{
    set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
    delete view;
    allegro_exit();
}

void closeMouse()
{
    remove_mouse();
}

void generateMap()
{
	int i;
    int xp, yp;

    for ( yp = 0; yp < MAPYS; yp ++ )
    {
    	for ( xp = 0; xp < MAPXS; xp ++ )
        {
        	map.setHeight(xp, yp, 0);
        }
    }

    srandom(rawclock());

    for ( i = 0; i < MAPXS*MAPYS/2; i ++ )
	{
		xp = (long long)random()*(MAPXS-1)/MAXINT/2*2;
		yp = (long long)random()*(MAPYS-1)/MAXINT/2*2;
		map.raise(xp,yp);
		map.raise(xp+1,yp);
		map.raise(xp,yp+1);
		map.raise(xp+1,yp+1);
    }
}

void main(int argc, char* argv[])
{
	if ( argc >= 3 )
    {
    	RESX = atoi(argv[1]);
        RESY = atoi(argv[2]);
    }

    if ( RESX == 0 || RESY == 0 ) exit(0);

    cout << "+---------------------------------------------------+" << endl;
    cout << "| Transport-tycoon-like landscape engine by aNoriPi |" << endl;
    cout << "|      Please see around with your arrow keys.      |" << endl;
    cout << "|                  SPACEBAR: Stop                   |" << endl;
    cout << "|                O: Return to origin                |" << endl;
    cout << "|                 M: Regenerate map                 |" << endl;
    cout << "|                   C: New color                    |" << endl;
    cout << "|                  G: Grid ON/OFF                   |" << endl;
    cout << "|          Left/Right Click: Raise/deepen map       |" << endl;
    cout << "|---------------------------------------------------|" << endl;
    cout << "|         usage: test.exe [<ResX> <ResY>]           |" << endl;
    cout << "+---------------------------------------------------+" << endl;

    getch();


	initGraph();
    install_keyboard();
    initMouse();

    generateMap();

    int x = 60*20, y = 0;
    int dx = 0, dy = 0;

    char fpstext[256] = "Preparing to calculate FPS";
    float fps;
	int done = 0;
	int frame = 0;
    clock_t curclk;

    BITMAP* mybtm = view->getBitmap();
    text_mode(-1); // transparent textout

    int old_mouse_b = mouse_b;
	curclk = clock();
	while ( !done )
	{
    	clear(mybtm);
        view->render(x, y);

		frame ++;

        if ( frame % 16 == 0 )
        {
			sprintf(fpstext, "%3.2f frames/sec", (float)16*CLK_TCK/(clock()-curclk) );
            curclk = clock();
        }

        textout(mybtm, font, fpstext, 8, 8, 255);
        textprintf(mybtm, font, 8, 24, 255, "X:%4d(%+3d) Y:%4d(%+3d)", x, dx, y, dy);

        int mapx, mapy;
        view->getMapPos(x, y, mouse_x, mouse_y+HALF_TILE_YS, mapx, mapy);

        if ( mapx != -1 )
        {
        	if ( old_mouse_b & 1 && !(mouse_b & 1) ) map.raise(mapx, mapy); // left button
            if ( old_mouse_b & 2 && !(mouse_b & 2) ) map.deepen(mapx, mapy); // right button

	        textprintf(mybtm, font, 8, 40, 255, "MapX:%3d MapY:%3d Height:%d", mapx, mapy, map.getMapElem(mapx, mapy).getHeight());
        }

        old_mouse_b = mouse_b;

        draw_sprite(mybtm, cursor, mouse_x-8, mouse_y-8); // mouse cursor

        blit(mybtm, screen, 0, 0, 0, 0, RESX-1, RESY-1);

        x += dx;
        y += dy;

		if ( keypressed() )
		{
        	if ( key[KEY_UP] )
            {
				dx --;
                dy --;
            }
            if ( key[KEY_LEFT] )
            {
	           	dx --;
                dy ++;
            }
            if ( key[KEY_RIGHT] )
            {
				dx ++;
                dy --;
            }
            if ( key[KEY_DOWN] )
            {
            	dx ++;
                dy ++;
            }
            if ( key[KEY_SPACE] )
            {
				dx = 0;
				dy = 0;
            }
            if ( key[KEY_O] )
            {
                x = 60*20;
                y = 0;
            }
			if ( key[KEY_M] ) generateMap();
            if ( key[KEY_C] ) makePalette();
            if ( key[KEY_G] ) setGrid();
            if ( key[KEY_ESC] ) done = 1;
        }
	}

    closeMouse();
    remove_keyboard();
	closeGraph();
}
