#ifndef _TMDFORM_H
#define _TMDFORM_H

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned long  DWORD;
typedef signed   long  SDWORD;
typedef unsigned short WORD;
typedef signed   short SWORD;
typedef unsigned char  BYTE;

#pragma pack(1)

#define TMD_VER   0x00000041
#define FIXP_BIT  0x00000001

typedef struct {
    DWORD       id;                 // as TMD_VER
    DWORD       flag;               // FIXP_BIT (0:offset addr, 1:absolute addr)
    DWORD       n_obj;
} TmdHead;

typedef struct {
    DWORD	vertAddr;
    DWORD	nVert;
    DWORD	normAddr;
    DWORD	nNorm;
    DWORD	primAddr;
    DWORD	nPrim;
    SDWORD      scale;              // 2^scale
} TmdObject;

 // Packet_Sub : mode
#define     PK_CODE_POLYGON    (1<<5)           // tri or quad
#define     PK_CODE_LINE       (2<<5)
#define     PK_CODE_SPRITE     (3<<5)
#define     PK_CODE_MASK       (7<<5)
#define     PK_OPTION_MASK     (0x1f)

 // Packet_Sub : flag
#define     PK_FLAG_GRD  4     // 0: gradation 1: flat (only for none-textured polygon)
#define     PK_FLAG_FCE  2     // 0: single 1: double face (only for PK_CODE_POLYGON)
#define     PK_FLAG_LGT  1     // 0: light source used 1: light source unused

struct PACKET_SUB {
    BYTE        olen;
    BYTE        ilen;
    BYTE        flag;
    BYTE        mode;
};

typedef union {
    struct PACKET_SUB  w;
    DWORD       x;
} PACKET_ID ;

typedef struct {
    SWORD       vx,vy,vz;           // 16 bit integer
    WORD        dummy;
} TmdVertex;

typedef struct {
    WORD        nx,ny,nz;           // 16 bit fixed-point (1:sign,3:integral,12:decimal)
    WORD        dummy;              // so 4096 = 1.0
} TmdNormal;

///////////////////////////////// Packet Data Composition

typedef struct {
    WORD        tpage:5;            // texture page (0~31)
    WORD        abr  :2;            // transulent mode (0~3) (valid only when abe is 1)
    WORD        tpf  :2;            // color mode (0:4bit,1:8bit,2:15bit)
    WORD        dummy:7;
} PACKET_TSB;

typedef struct {
    WORD        clx  :6;            // clut x most-6bit on 10bit
    WORD        cly  :9;            // clut y 9bit
    WORD        dummy:1;
} PACKET_CBA;

///////////////////////////////// Packet Data List

// 3 vertices polygon with light calculation

typedef struct {
    PACKET_ID   id;
    BYTE        r,g,b,_20h;
    WORD        n0,p0,p1,p2;
} PACKET_20000304;                  // Flat (solid color), No-texture

typedef struct {
    PACKET_ID   id;
    BYTE        r0,g0,b0,_20h;
    BYTE        r1,g1,b1,_dummy1;
    BYTE        r2,g2,b2,_dummy2;
    WORD        n0,p0,p1,p2;
} PACKET_20040506;                  // Flat (gradation), No-texture

typedef struct {
    PACKET_ID   id;
    BYTE        u0,v0;
    PACKET_CBA  cba;
    BYTE        u1,v1;
    PACKET_TSB  tsb;
    BYTE        u2,v2;
    WORD        _dummy;
    WORD        n0,p0,p1,p2;
} PACKET_24000507;                  // Flat, Texture

typedef struct {
    PACKET_ID   id;
    BYTE        r,g,b,_30h;
    WORD        n0,p0,n1,p1,v2,p2;
} PACKET_30000406;                  // Gouraud (solid color), No Texture

typedef struct {
    PACKET_ID   id;
    BYTE        r0,g0,b0,_30h;
    BYTE        r1,g1,b1,_dummy1;
    BYTE        r2,g2,b2,_dummy2;
    WORD        n0,p0,n1,p1,n2,p2;
} PACKET_30040606;                  // Gouraud (gradation), No Texture

typedef struct {
    PACKET_ID   id;
    BYTE        u0,v0;
    PACKET_CBA  cba;
    BYTE        u1,v1;
    PACKET_TSB  tsb;
    BYTE        u2,v2,_1,_2;
    WORD        n0,p0,n1,p1,n2,p2;
} PACKET_34000609;                  // Gouraud, Texture

// 3 vertices polygon without light calculation

typedef struct {
    PACKET_ID   id;
    BYTE        r,g,b,_21h;
    WORD        p0,p1,p2,_1;
} PACKET_21010304;                  // Flat, No Texture

typedef struct {
    PACKET_ID   id;
    BYTE        u0,v0;
    PACKET_CBA  cba;
    BYTE        u1,v1;
    PACKET_TSB  tsb;
    BYTE        u2,v2,_1,_2;
    BYTE        r,g,b,_3;
    WORD        p0,p1,p2,_4;
} PACKET_25010607;                  // Flat, Texture

typedef struct {
    PACKET_ID   id;
    BYTE        r0,g0,b0,_31h;
    BYTE        r1,g1,b1,_1;
    BYTE        r2,g2,b2,_2;
    WORD        p0,p1,p2,_3;
} PACKET_31010506;                  // Gouraud, No Texture

typedef struct {
    PACKET_ID   id;
    BYTE        u0,v0;
    PACKET_CBA  cba;
    BYTE        u1,v1;
    PACKET_TSB  tsb;
    BYTE        u2,v2,_1,_2;
    BYTE        r0,g0,b0,_3;
    BYTE        r1,g1,b1,_4;
    BYTE        r2,g2,b2,_5;
    WORD        p0,p1,p2,_6;
} PACKET_35010809;                  // Gouraud, Texture

//  4 vertices polygon with light source calculation

typedef struct {
    PACKET_ID   id;
    BYTE        r,g,b,_28h;
    WORD        n0,p0,p1,p2,p3,_1;
} PACKET_28000405;                  // Flat (solid color), No Texure

typedef struct {
    PACKET_ID   id;
    BYTE        r0,g0,b0,_28h;
    BYTE        r1,g1,b1,_1;
    BYTE        r2,g2,b2,_2;
    BYTE        r3,g3,b3,_3;
    WORD        n0,p0,p1,p2,p3,_4;
} PACKET_28040708;                  // Flat (gradation), No Texture

typedef struct {
    PACKET_ID   id;
    BYTE        u0,v0;
    PACKET_CBA  cba;
    BYTE        u1,v1;
    PACKET_TSB  tsb;
    BYTE        u2,v2,_1,_2;
    BYTE        u3,v3,_3,_4;
    WORD        n0,p0,p1,p2,p3,_5;
} PACKET_2C000709;                  // Flat, Texture;

typedef struct {
    PACKET_ID   id;
    BYTE        r,g,b,_38h;
    WORD        n0,v0,n1,v1,n2,v2,n3,v3;
} PACKET_38000508;                  // Gouraud (solid color), No Texture

typedef struct {
    PACKET_ID   id;
    BYTE        r0,g0,b0,_38h;
    BYTE        r1,g1,b1,_1;
    BYTE        r2,g2,b2,_2;
    BYTE        r3,g3,b3,_3;
    WORD        n0,p0,n1,p1,n2,p2,n3,p3;
} PACKET_38040808;                  // Gouraud (gradation), No Texture

typedef struct {
    PACKET_ID   id;
    BYTE        u0,v0;
    PACKET_CBA  cba;
    BYTE        u1,v1;
    PACKET_TSB  tsb;
    BYTE        u2,v2,_1,_2;
    BYTE        u3,v3,_3,_4;
    WORD        n0,p0,n1,p1,n2,p2,n3,p3;
} PACKET_3C00080C;                  // Gouraud, Texture

// 4 vertices polygon without light source calculation

typedef struct {
    PACKET_ID   id;
    BYTE        r,g,b,_29h;
    WORD        p0,p1,p2,p3;
} PACKET_29010305;                  // Flat, No Texture

typedef struct {
    PACKET_ID   id;
    BYTE        u0,v0;
    PACKET_CBA  cba;
    BYTE        u1,v1;
    PACKET_TSB  tsb;
    BYTE        u2,v2,_1,_2;
    BYTE        u3,v3,_3,_4;
    BYTE        r,g,b,_5;
    WORD        p0,p1,p2,p3;
} PACKET_2D010709;                  // Flat, Texture

typedef struct {
    PACKET_ID   id;
    BYTE        r0,g0,b0,_39h;
    BYTE        r1,g1,b1,_1;
    BYTE        r2,g2,b2,_2;
    BYTE        r3,g3,b3,_3;
    WORD        p0,p1,p2,p3;
} PACKET_39010608;                  // Gouraud, No Texture

typedef struct {
    PACKET_ID   id;
    BYTE        u0,v0;
    PACKET_CBA  cba;
    BYTE        u1,v1;
    PACKET_TSB  tsb;
    BYTE        u2,v2,_1,_2;
    BYTE        u3,v3,_3,_4;
    BYTE        r0,g0,b0,_5;
    BYTE        r1,g1,b1,_6;
    BYTE        r2,g2,b2,_7;
    BYTE        r3,g3,b3,_8;
    WORD        p0,p1,p2,p3;
} PACKET_3D010A0C;                  // Gouraud, Texture

// Straight Line

typedef struct {
    PACKET_ID   id;
    BYTE        r,g,b,_40h;
    WORD        p0,p1;
} PACKET_40010203;                  // Gradation Off

typedef struct {
    PACKET_ID   id;
    BYTE        r0,g0,b0,_50h;
    BYTE        r1,g1,b1,_1;
    WORD        p0,p1;
} PACKET_50010304;                  // Gradation On


// 3D Sprite

typedef struct {
    PACKET_ID   id;
    WORD        p0;
    PACKET_TSB  tsb;
    BYTE        u0,v0;
    PACKET_CBA  cba;
    WORD        w,h;
} PACKET_64010305;                  // Free Size

typedef struct {
    PACKET_ID   id;
    WORD        p0;
    PACKET_TSB  tsb;
    BYTE        u0,v0;
    PACKET_CBA  cba;
} PACKET_6C010204;                  // 1x1

typedef struct {
    PACKET_ID   id;
    WORD        p0;
    PACKET_TSB  tsb;
    BYTE        u0,v0;
    PACKET_CBA  cba;
} PACKET_74010204;                  // 8x8

typedef struct {
    PACKET_ID   id;
    WORD        p0;
    PACKET_TSB  tsb;
    BYTE        u0,v0;
    PACKET_CBA  cba;
} PACKET_7C010204;                  // 16x16

#pragma pack()

#ifdef __cplusplus
};  // extern "C"
#endif

#endif  // _TMDFORM_H
