#ifndef _RENDER
#define _RENDER

#define PI      (32768)
#define DEGREE  (PI/180.0f)

inline float   Sine(unsigned angle);
inline float   Cosine(unsigned angle);

inline void    RotateMatrix_Xaxis(sMATRIX *matrix, short x_axis);
inline void    RotateMatrix_Yaxis(sMATRIX *matrix, short y_axis);
inline void    RotateMatrix_Zaxis(sMATRIX *matrix, short y_axis);
inline void    ResetMatrix(sMATRIX *matrix);
inline void    ReverseMatrix(sMATRIX *matrix, sMATRIX *twist);
inline void    MoveMatrix(sMATRIX *matrix, float x, float y, float z);
inline void    MulMatrix(sMATRIX *a, sMATRIX *b, sMATRIX *result);
inline void    ScaleMatrix(sMATRIX *matrix, float scale);
inline void    CopyMatrix(sMATRIX *target, sMATRIX *source);

    inline
    float
    Sine(unsigned angle)

{
    extern  float   *sintable;
    return sintable[angle&(PI*2-1)];
}

    inline
    float
    Cosine(unsigned angle)

{
    extern  float   *costable;
    return costable[angle&(PI*2-1)];
}

    inline
    void
    RotateMatrix_Xaxis(sMATRIX *matrix, short x_axis)

{
    float   cr = Cosine(x_axis), sr = Sine(x_axis);

    float   x2 = matrix->x2, y2 = matrix->y2, z2 = matrix->z2;
    float   x3 = matrix->x3, y3 = matrix->y3, z3 = matrix->z3;
    float   ym = matrix->ym, zm = matrix->zm;

    matrix->x2 = cr * x2 - sr * x3;
    matrix->y2 = cr * y2 - sr * y3;
    matrix->z2 = cr * z2 - sr * z3;

    matrix->x3 = sr * x2 + cr * x3;
    matrix->y3 = sr * y2 + cr * y3;
    matrix->z3 = sr * z2 + cr * z3;

    matrix->ym = cr * ym - sr * zm;
    matrix->zm = sr * ym + cr * zm;
}

    inline
    void
    RotateMatrix_Yaxis(sMATRIX *matrix, short y_axis)

{
    float   cr = Cosine(y_axis), sr = Sine(y_axis);

    float   x1 = matrix->x1, y1 = matrix->y1, z1 = matrix->z1;
    float   x3 = matrix->x3, y3 = matrix->y3, z3 = matrix->z3;
    float   xm = matrix->xm, zm = matrix->zm;

    matrix->x1 = cr * x1 - sr * x3;
    matrix->y1 = cr * y1 - sr * y3;
    matrix->z1 = cr * z1 - sr * z3;

    matrix->x3 = sr * x1 + cr * x3;
    matrix->y3 = sr * y1 + cr * y3;
    matrix->z3 = sr * z1 + cr * z3;

    matrix->xm = cr * xm - sr * zm;
    matrix->zm = sr * xm + cr * zm;
}

    inline
    void
    RotateMatrix_Zaxis(sMATRIX *matrix, short y_axis)

{
    float   cr = Cosine(y_axis), sr = Sine(y_axis);

    float   x1 = matrix->x1, y1 = matrix->y1, z1 = matrix->z1;
    float   x2 = matrix->x2, y2 = matrix->y2, z2 = matrix->z2;
    float   xm = matrix->xm, ym = matrix->zm;

    matrix->x1 = cr * x1 - sr * x2;
    matrix->y1 = cr * y1 - sr * y2;
    matrix->z1 = cr * z1 - sr * z2;

    matrix->x2 = sr * x1 + cr * x2;
    matrix->y2 = sr * y1 + cr * y2;
    matrix->z2 = sr * z1 + cr * z2;

    matrix->xm = cr * xm - sr * ym;
    matrix->ym = sr * xm + cr * ym;
}

    inline
    void
    ResetMatrix(sMATRIX *matrix)

{
    matrix->x1 = 1.0f;
    matrix->y1 = 0.0f;
    matrix->z1 = 0.0f;

    matrix->x2 = 0.0f;
    matrix->y2 = 1.0f;
    matrix->z2 = 0.0f;

    matrix->x3 = 0.0f;
    matrix->y3 = 0.0f;
    matrix->z3 = 1.0f;

    matrix->xm = 0.0f;
    matrix->ym = 0.0f;
    matrix->zm = 0.0f;
}

    inline
    void
    MoveMatrix(sMATRIX *matrix, float x, float y, float z)

{
    matrix->xm += x;
    matrix->ym += y;
    matrix->zm += z;
}

    inline
    void
    MulMatrix(sMATRIX *a, sMATRIX *b, sMATRIX *result)

{
    result->x1 = a->x1 * b->x1 + a->x2 * b->y1 + a->x3 * b->z1;
    result->y1 = a->y1 * b->x1 + a->y2 * b->y1 + a->y3 * b->z1;
    result->z1 = a->z1 * b->x1 + a->z2 * b->y1 + a->z3 * b->z1;

    result->x2 = a->x1 * b->x2 + a->x2 * b->y2 + a->x3 * b->z2;
    result->y2 = a->y1 * b->x2 + a->y2 * b->y2 + a->y3 * b->z2;
    result->z2 = a->z1 * b->x2 + a->z2 * b->y2 + a->z3 * b->z2;

    result->x3 = a->x1 * b->x3 + a->x2 * b->y3 + a->x3 * b->z3;
    result->y3 = a->y1 * b->x3 + a->y2 * b->y3 + a->y3 * b->z3;
    result->z3 = a->z1 * b->x3 + a->z2 * b->y3 + a->z3 * b->z3;

    result->xm = a->xm * b->x1 + a->ym * b->y1 + a->zm * b->z1 + b->xm;
    result->ym = a->xm * b->x2 + a->ym * b->y2 + a->zm * b->z2 + b->ym;
    result->zm = a->xm * b->x3 + a->ym * b->y3 + a->zm * b->z3 + b->zm;
}

    inline
    void
    ScaleMatrix(sMATRIX *matrix, float scale)

{
    matrix->x1 = matrix->x1*scale;
    matrix->y1 = matrix->y1*scale;
    matrix->z1 = matrix->z1*scale;

    matrix->x2 = matrix->x2*scale;
    matrix->y2 = matrix->y2*scale;
    matrix->z2 = matrix->z2*scale;

    matrix->x3 = matrix->x3*scale;
    matrix->y3 = matrix->y3*scale;
    matrix->z3 = matrix->z3*scale;

}

    inline
    void
    ReverseMatrix(sMATRIX *matrix, sMATRIX *result)

{
    result->x1 = matrix->x1, result->y1 = matrix->x2, result->z1 = matrix->x3;
    result->x2 = matrix->y1, result->y2 = matrix->y2, result->z2 = matrix->y3;
    result->x3 = matrix->z1, result->y3 = matrix->z2, result->z3 = matrix->z3;

    result->xm = -(matrix->x1 * matrix->xm + matrix->x2 * matrix->ym + matrix->x3 * matrix->zm);
    result->ym = -(matrix->y1 * matrix->xm + matrix->y2 * matrix->ym + matrix->y3 * matrix->zm);
    result->zm = -(matrix->z1 * matrix->xm + matrix->z2 * matrix->ym + matrix->z3 * matrix->zm);
}

    #include    <string.h>

    inline
    void
    CopyMatrix(sMATRIX *target, sMATRIX *source)

{
    memcpy(target, source, sizeof(sMATRIX));
}

#endif
