    #include    <windows.h>
    #include    <math.h>
    #include    <stdio.h>
    #include    "define.h"
    #include    "util.h"
    #include    "math.h"
    #include    "tmdform.h"
    #include    "resource.h"
    #include    "primlist.h"

    enum    { WM_LOAD_TMD = WM_USER, WM_RENDER, WM_PUTPOLYGON};
    enum    { MENU_LOAD, MENU_EXIT };

    struct  sPOLY
    {
        sPOINT  p1, p2, p3;
        int     z;
        short   color;
        //U08     *mapsrc;
    };

    #define HIRGB(R,G,B) ((short)((((R)>>3)<<10)+(((G)>>3)<<5)+((B)>>3)))
    #define MAXPOLY     10*10000

    int __cdecl sort_funtion(const void *a, const void *b)

{
    int     z1, z2;

    z1 = (*(sPOLY**)a)->z;
    z2 = (*(sPOLY**)b)->z;

    return (z1 > z2) ? -1 : ((z1 == z2) ? 0 : 1);
}

    float        *sintable, *costable;

    long far pascal
    WinProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)

{
    static short        *vram = NULL;
    static BITMAPINFO   *bi = NULL;
    static int          width, height, polynum;
    static BYTE         *buff = NULL;
    static float        scale = 0.0f;
    static sPOINT       *point;
    static sMATRIX      camera, matrix;
    static sPOLY        *poly, **polylist;

    switch(message)
    {
        case WM_SIZE :
        {
            if (wParam == SIZE_MINIMIZED)
                break;

            width  = (LOWORD(lParam)+3)&(~3);
            height = HIWORD(lParam);

            if (bi == NULL)
                bi = (BITMAPINFO*) new char [sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*256];

            bi->bmiHeader.biSize        = sizeof(BITMAPINFOHEADER);
            bi->bmiHeader.biWidth       = width;
            bi->bmiHeader.biHeight      = -height;
            bi->bmiHeader.biPlanes      = 1;
            bi->bmiHeader.biCompression = BI_RGB;
            bi->bmiHeader.biSizeImage   = 0;
            bi->bmiHeader.biClrUsed     = 0;
            bi->bmiHeader.biBitCount    = 16;

            if (vram != NULL)
                delete  vram;

            vram = new short [width*height];

            memset(vram, 1, width*height*sizeof(short));

            scale = (float)height;

            SendMessage(hwnd, WM_RENDER, 0, 0);

            break;
        }

        case WM_PAINT :
        {
            PAINTSTRUCT ps;

            BeginPaint(hwnd, &ps);

            SetDIBitsToDevice(ps.hdc,
                ps.rcPaint.left, ps.rcPaint.top,
                width, height,
                ps.rcPaint.left, height,
                ps.rcPaint.bottom,
                ps.rcPaint.top != 0 ? ps.rcPaint.bottom-ps.rcPaint.top : height,
                vram,
                bi,
                DIB_RGB_COLORS);

            EndPaint(hwnd, &ps);
            break;
        }

        case WM_DESTROY :
            PostQuitMessage(0);
            break;

        case WM_CREATE :
        {
            HMENU   menu, file;
            int     i;

            menu = CreateMenu();
            file = CreateMenu();

            InsertMenu(menu, 0, MF_POPUP, (DWORD)file, "&File");

            AppendMenu(file, MFT_STRING, MENU_LOAD, "&Open");
            AppendMenu(file, MFT_STRING, MENU_EXIT, "E&xit");

            SetMenu(hwnd, menu);

            sintable = new float [PI*5/2];
            costable = sintable + PI/2;
            poly     = new sPOLY [MAXPOLY];
            polylist = new sPOLY* [MAXPOLY];
            polynum  = 0;

            for (i=0; i<PI*5/2; i++)
                sintable[i] = (float)sin(i*3.14/PI);

            ResetMatrix(&camera);
            MoveMatrix(&camera, 0.0f, 0.0f, 5000.0f);

            ResetMatrix(&matrix);

            break;
        }

        case WM_COMMAND :
            switch(LOWORD(wParam))
            {
                case MENU_LOAD :
                {
                    char    filename[256] = "*.tmd";
                    OPENFILENAME    ofn;

                    filename[0] = 0;

                    ofn.lStructSize       = sizeof(ofn);
                    ofn.hwndOwner         = hwnd;
                    ofn.hInstance         = (HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE);
                    ofn.lpstrFilter       = "TMD Files(*.tmd)\0*.tmd\0All Files(*.*)\0*.*\0\0";
                    ofn.lpstrCustomFilter = NULL;
                    ofn.nFilterIndex      = 1;
                    ofn.lpstrFile         = filename;
                    ofn.nMaxFile          = 256;
                    ofn.lpstrFileTitle    = NULL;
                    ofn.lpstrInitialDir   = NULL;
                    ofn.lpstrTitle        = "File Open";
                    ofn.Flags             = OFN_FILEMUSTEXIST|OFN_EXPLORER;
                    ofn.lpstrDefExt       = NULL;

                    if (GetOpenFileName(&ofn) != FALSE)
                        SendMessage(hwnd, WM_LOAD_TMD, 0, (LPARAM)filename);

                    break;
                }

                case MENU_EXIT :
                    PostQuitMessage(1);
                    break;
            }
            break;

        case WM_CHAR :
        {
            switch(wParam)
            {
                case '8' :
                    RotateMatrix_Xaxis(&matrix, PI/45);
                    break;

                case '2' :
                    RotateMatrix_Xaxis(&matrix, -PI/45);
                    break;

                case '4' :
                    RotateMatrix_Yaxis(&matrix, PI/45);
                    break;

                case '6' :
                    RotateMatrix_Yaxis(&matrix, -PI/45);
                    break;

                case '+' :
                    ScaleMatrix(&matrix, 4.0f/3.0f);
                    break;

                case '-' :
                    ScaleMatrix(&matrix, 3.0f/4.0f);
                    break;

                default :
                    return 0;
            }

            SendMessage(hwnd, WM_RENDER, 0, 0);

            break;
        }

        case WM_RENDER :
        {
            float       x, y, z, tx, ty, tz;
            int         x1, dx1, x2, dx2;
            int         i1, i2, y1, y2;
            int         b, l, offset, i;
            TmdHead     *TH;
            TmdObject   *TO;
            BYTE        *addr;
            sPOINT      *p1, *p2, *p3;
            TmdVertex   *TmdVertexList;
            sMATRIX     mat;
            DWORD       id;
            short       c;

            if (buff == NULL)
                break;

            TH = (TmdHead*)buff;
            TO = (TmdObject*)((BYTE*)buff+sizeof(TmdHead));

            polynum = 0;
            memset(vram, 1, width*height*sizeof(short));

            MulMatrix(&matrix, &camera, &mat);

            TmdVertexList = (TmdVertex*)(((BYTE*)TO)+TO->vertAddr);

            for(i=0; i < (int)TO->nVert; i++)
            {
                x = (float)TmdVertexList[i].vx/2.0f;
                y = (float)TmdVertexList[i].vy/2.0f;
                z = (float)TmdVertexList[i].vz/2.0f;

                tx = x*mat.x1 + y*mat.y1 + z*mat.z1 + mat.xm;
                ty = x*mat.x2 + y*mat.y2 + z*mat.z2 + mat.ym;
                tz = x*mat.x3 + y*mat.y3 + z*mat.z3 + mat.zm;

                point[i].x = (int)(scale*tx/tz) + width/2;
                point[i].y = (int)(scale*ty/tz) + height/2;
                point[i].z = (int)(tz);
            }

            for(i=0; i < (int)TH->n_obj; i++)
            {
                addr = (BYTE*)TO + TO->primAddr;

                for(i=0; i < (int)TO->nPrim; i++)
                {
                    switch(id=*((DWORD*)addr))
                    {
                        case 0x20000304:
                        {
                            PACKET_20000304 *s = (PACKET_20000304*) addr;
                            sPOINT          *p[3];

                            p[0] = point + s->p0;
                            p[1] = point + s->p1;
                            p[2] = point + s->p2;

                            SendMessage(hwnd, WM_PUTPOLYGON, HIRGB(s->r, s->g, s->b), (LPARAM)p);

                            addr += sizeof(PACKET_20000304);

                            break;
                        }

                        case 0x30000406:    // GOURAUD NO TEX 3-POLY LIGHT ON
                        {
                            PACKET_30000406 *s = (PACKET_30000406*) addr;
                            sPOINT          *p[3];

                            p[0] = point + s->p0;
                            p[1] = point + s->p1;
                            p[2] = point + s->p2;

                            SendMessage(hwnd, WM_PUTPOLYGON, HIRGB(s->r, s->g, s->b), (LPARAM)p);

                            addr += sizeof(PACKET_30000406);

                            break;
                        }

                        case 0x28000405:    // FLAT NO TEX 4-POLY, Light ON
                        {
                            PACKET_28000405 *s = (PACKET_28000405*) addr;
                            sPOINT          *p[3];

                            p[0] = point + s->p0;
                            p[1] = point + s->p1;
                            p[2] = point + s->p2;

                            SendMessage(hwnd, WM_PUTPOLYGON, HIRGB(s->r, s->g, s->b), (LPARAM)p);

                            p[0] = point + s->p1;
                            p[1] = point + s->p3;
                            p[2] = point + s->p2;

                            SendMessage(hwnd, WM_PUTPOLYGON, HIRGB(s->r, s->g, s->b), (LPARAM)p);

                            addr += sizeof(PACKET_28000405);
                            break;
                        }

                        case 0x29010305:    // FLAT NO TEX 4-POLY, Light OFF
                        {
                            PACKET_29010305 *s = (PACKET_29010305*) addr;
                            sPOINT          *p[3];

                            p[0] = point + s->p0;
                            p[1] = point + s->p1;
                            p[2] = point + s->p2;

                            SendMessage(hwnd, WM_PUTPOLYGON, HIRGB(s->r, s->g, s->b), (LPARAM)p);

                            p[0] = point + s->p1;
                            p[1] = point + s->p3;
                            p[2] = point + s->p2;

                            SendMessage(hwnd, WM_PUTPOLYGON, HIRGB(s->r, s->g, s->b), (LPARAM)p);

                            addr += sizeof(PACKET_29010305);
                            break;
                        }

                        default :
                            for(i=0; i < sizeof(primList)/sizeof(*primList); i++)
                            {
                                if (primList[i].id == id)
                                {
                                    addr += primList[i].size;
                                    break;
                                }
                            }

                            if (i == sizeof(primList)/sizeof(*primList))
                            {
                                char    msg[30];

                                sprintf(msg, "Unknown polygon::ID #%x", id);

                                MessageBox(hwnd, msg, "Error", MB_OK);
                                delete  buff;
                                buff = NULL;
                                return 0;
                            }

                            break;
                    }
                }
            }

            qsort(polylist, polynum, sizeof(sPOLY*), sort_funtion);

            for(i=0; i<polynum; i++)
            {
                p1 = &polylist[i]->p1;
                p2 = &polylist[i]->p2;
                p3 = &polylist[i]->p3;
                c  = polylist[i]->color;

                for(b=0; b<2; b++)
                {
                    if (b == 0) // p1 -> p3, p1 -> p2
                    {
                        dx1 = ((p3->x - p1->x) << 8) / (p3->y - p1->y + 1);
                        x1  = (p1->x << 8) + 127;

                        dx2 = ((p2->x - p1->x) << 8) / (p2->y - p1->y + 1);
                        x2  = (p1->x << 8) + dx2 + 127;

                        y1  = p1->y;
                        y2  = p2->y;
                    }   else    // p1 -> p3, p2 -> p3
                    {
                        x2  = (p2->x << 8) + 127;
                        dx2 = ((p3->x - p2->x) << 8) / (p3->y - p2->y + 1);

                        y1  = p2->y;
                        y2  = p3->y+1;
                    }

                    if (y1 < 0)
                    {
                        l = Min(0-y1, y2-y1);

                        y1 += l;
                        x1 += dx1 * l;
                        x2 += dx2 * l;
                    }

                    if (y2 > height)
                        y2 = height;

                    for(offset=y1*width; y1<y2; y1++, x1+=dx1, x2+=dx2, offset+=width)
                    {
                        if (x1 > x2)
                        {
                            i1 = x2 >> 8;
                            i2 = x1 >> 8;
                        }   else
                        {
                            i1 = x1 >> 8;
                            i2 = x2 >> 8;
                        }

                        if (i1 < 0)
                            i1 = 0;

                        if (i2 >= width)
                            i2 = width-1;

                        for(; i1 <= i2; i1++)
                            vram[offset+i1] = c;
                    }
                }
            }

            InvalidateRect(hwnd, NULL, FALSE);
            UpdateWindow(hwnd);
            break;
        }

        case WM_PUTPOLYGON : // <short color> <sPOINT **p>
        {
            sPOINT  **p;

            p = (sPOINT**) lParam;

            if ((p[1]->x-p[0]->x)*(p[2]->y-p[0]->y) >= (p[2]->x-p[0]->x)*(p[1]->y-p[0]->y) && polynum < MAXPOLY)
            {
                if (p[0]->y > p[1]->y) Swap(p[0], p[1]);
                if (p[0]->y > p[2]->y) Swap(p[0], p[2]);
                if (p[1]->y > p[2]->y) Swap(p[1], p[2]);

                if (p[0]->y < height && p[2]->y >= 0)
                {
                    memcpy(&poly[polynum].p1, p[0], sizeof(sPOINT));
                    memcpy(&poly[polynum].p2, p[1], sizeof(sPOINT));
                    memcpy(&poly[polynum].p3, p[2], sizeof(sPOINT));

                    poly[polynum].z     = (p[0]->z + p[1]->z + p[2]->z)/3;
                    poly[polynum].color = wParam;
                    polylist[polynum]   = &poly[polynum];
                    polynum++;
                }
            }

            break;
        }

        case WM_LOAD_TMD :   // <0> <char filename[]>
        {
            FILE       *io;
            long       len;

            io = fopen((char*)lParam, "rb");
            
            if (io == NULL)
                break;

            if (buff != NULL)
            {
                delete  buff;
                delete  point;
            }
            
            fseek(io, 0, SEEK_END);
            len  = ftell(io);
            fseek(io, 0, SEEK_SET);
            buff = new BYTE [len];

            fread(buff,len,1,io);
            fclose(io);

            point = new sPOINT [((TmdObject*)((BYTE*)buff+sizeof(TmdHead)))->nVert];

            SendMessage(hwnd, WM_RENDER, 0, 0);
            break;
        }

        default :
            return DefWindowProc(hwnd, message, wParam, lParam);
    }

    return 0;
}

    int pascal
    WinMain(HINSTANCE instance, HINSTANCE previnsy, LPSTR lpszArgs, int winmode)

{
    WNDCLASS    wcl;
    MSG         msg;
    HWND        hwnd;

    wcl.style         = 0;
    wcl.lpfnWndProc   = WinProc;
    wcl.cbClsExtra    = 0;
    wcl.cbWndExtra    = 0;
    wcl.hInstance     = instance;
    wcl.hIcon         = LoadIcon(instance, MAKEINTATOM(N64_IS_BETTER_THAN_PLAYSTATION));
    wcl.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wcl.hbrBackground = (HBRUSH) GetStockObject(BLACK_BRUSH);
    wcl.lpszMenuName  = NULL;
    wcl.lpszClassName = "FuckYou";

    if (!RegisterClass(&wcl))
        PostQuitMessage(0);

    hwnd = CreateWindow (
        "FuckYou",
        "Just a viewer",
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, CW_USEDEFAULT,
        HWND_DESKTOP,
        NULL,
        instance, NULL);

    ShowWindow(hwnd, SW_RESTORE);
    UpdateWindow(hwnd);

    if (lpszArgs[0] != 0)
        SendMessage(hwnd, WM_LOAD_TMD, 0, (LPARAM)lpszArgs);

    while(1)
    {
        if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE) != 0)
        {
            if (GetMessage(&msg, NULL, 0, 0) == 0)
                break;

            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    return  msg.wParam;
}
