//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ C3D Class Library - C3D.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ C3D_Mesh Implementation ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#include <stdlib.h>
#include <time.h>
#include "C3D.h"

//////////////////////////////////////////////////////////////////////////////////
// C3D_Mesh constructor
//////////////////////////////////////////////////////////////////////////////////
C3D_Mesh::C3D_Mesh(void)
{
	m_VertexCount = 0;
	m_IndexCount = 0;
	m_Vertices = NULL;
	m_Indices = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Mesh destructor
//////////////////////////////////////////////////////////////////////////////////
C3D_Mesh::~C3D_Mesh(void)
{
	SAFEDELETE(m_Vertices);
	SAFEDELETE(m_Indices);
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Mesh SetPosition
//////////////////////////////////////////////////////////////////////////////////
void C3D_Mesh::SetPosition(float x, float y, float z)
{
	m_Position.x = x;
	m_Position.y = y;
	m_Position.z = z;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Mesh SetHeading
//////////////////////////////////////////////////////////////////////////////////
void C3D_Mesh::SetHeading(float x, float y, float z)
{
	m_Heading.x;
	m_Heading.y;
	m_Heading.z;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Mesh CreateCube
//////////////////////////////////////////////////////////////////////////////////
void C3D_Mesh::CreateCube(float l, float w, float h)
{
	m_VertexCount = 8;
	m_Vertices = new C3D_Vertex[m_VertexCount];

	m_IndexCount = 36;
	m_Indices = new WORD[m_IndexCount];

	m_Vertices[0] = C3D_Vertex(-l, +w, -h, D3DRGB(1,0,0), D3DRGB(0,0,0));
	m_Vertices[1] = C3D_Vertex(+l, +w, -h, D3DRGB(1,0,0), D3DRGB(0,0,0));
	m_Vertices[2] = C3D_Vertex(+l, -w, -h, D3DRGB(0,1,0), D3DRGB(0,0,0));
	m_Vertices[3] = C3D_Vertex(-l, -w, -h, D3DRGB(0,1,0), D3DRGB(0,0,0));
	m_Vertices[4] = C3D_Vertex(-l, +w, +h, D3DRGB(0,0,1), D3DRGB(0,0,0));
	m_Vertices[5] = C3D_Vertex(+l, +w, +h, D3DRGB(0,0,1), D3DRGB(0,0,0));
	m_Vertices[6] = C3D_Vertex(+l, -w, +h, D3DRGB(1,1,0), D3DRGB(0,0,0));
	m_Vertices[7] = C3D_Vertex(-l, -w, +h, D3DRGB(1,1,0), D3DRGB(0,0,0));

	// FRONT
	m_Indices[0] = 0; m_Indices[1] = 1; m_Indices[2] = 3;
	m_Indices[3] = 3; m_Indices[4] = 1; m_Indices[5] = 2;

	// BACK
	m_Indices[6] = 4; m_Indices[7] = 7; m_Indices[8] = 5;
	m_Indices[9] = 5; m_Indices[10] = 7; m_Indices[11] = 6;

	// TOP
	m_Indices[12] = 0; m_Indices[13] = 4; m_Indices[14] = 1;
	m_Indices[15] = 1; m_Indices[16] = 4; m_Indices[17] = 5;

	// BOTTOM
	m_Indices[18] = 3; m_Indices[19] = 2; m_Indices[20] = 7;
	m_Indices[21] = 7; m_Indices[22] = 2; m_Indices[23] = 6;

	// LEFT
	m_Indices[24] = 7; m_Indices[25] = 4; m_Indices[26] = 0;
	m_Indices[27] = 7; m_Indices[28] = 0; m_Indices[29] = 3;

	// RIGHT
	m_Indices[30] = 2; m_Indices[31] = 1; m_Indices[32] = 5;
	m_Indices[33] = 2; m_Indices[34] = 5; m_Indices[35] = 6;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Mesh CreateSphere
//////////////////////////////////////////////////////////////////////////////////
void C3D_Mesh::CreateSphere(void)
{
}

#define GRID_DEPTH 64
#define GRID_WIDTH 64

#define VERTEX_COUNT (GRID_DEPTH + 1)
#define VERTEX_SPACING 500.0f

//////////////////////////////////////////////////////////////////////////////////
// C3D_Mesh CreateTerrain
//////////////////////////////////////////////////////////////////////////////////
void C3D_Mesh::CreateTerrain(void)
{
	int i, j, loop;

	// Seed the random number generator
	srand((unsigned)time( NULL ));

	m_VertexCount = VERTEX_COUNT * VERTEX_COUNT;
	m_Vertices = new C3D_Vertex[m_VertexCount];

	m_IndexCount = GRID_DEPTH * GRID_WIDTH * 6;
	m_Indices = new WORD[m_IndexCount];

	// Create the grid vertices
	float fSize   = VERTEX_SPACING / (VERTEX_COUNT - 1.0f);
	float fOffset = VERTEX_SPACING / 2.0f;

	for(i = 0; i < VERTEX_COUNT; i++) 
	{
		for(j = 0; j < VERTEX_COUNT; j++) 
		{
			float x = i * fSize - fOffset;
			float y = -10.0f+rand()%5;
			float z = j * fSize - fOffset;

			float r = 0.0f;
			float g = 1.5f - (y / -10.0f);
			float b = 0.0f;

			C3D_Vertex v(x, y, z, D3DRGB(r,g,b), 0);
			m_Vertices[j + i * VERTEX_COUNT] = v;
		}
	}

	// Create indices into the vertex array
	loop = i = j = 0;

	for(j = 0; j < (GRID_DEPTH * GRID_WIDTH * 3); j += (GRID_DEPTH * 3))
	{
		for(i = 0; i < (GRID_DEPTH * 3); i += 3)
		{
			m_Indices[(i+j)]   = loop;
			m_Indices[(i+j)+1] = loop + 1;
			m_Indices[(i+j)+2] = loop + GRID_DEPTH + 1;
			loop++;
		}
		loop++;
	}

	i = j = 0;
	loop = 1;

	for(j = (GRID_DEPTH * GRID_WIDTH * 3); j < (GRID_DEPTH * GRID_WIDTH * 6); j += (GRID_DEPTH * 3))
	{
		for(i = 0; i < (GRID_DEPTH * 3); i += 3)
		{
			m_Indices[(i+j)]   = loop;
			m_Indices[(i+j)+1] = loop + GRID_DEPTH + 1;
			m_Indices[(i+j)+2] = loop + GRID_DEPTH;
			loop++;
		}
		loop++;
	}
}
