//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ C3D Class Library - C3D.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ C3D_Vertex Implementation ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#include "C3D.h"

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex constructor
//////////////////////////////////////////////////////////////////////////////////
C3D_Vertex::C3D_Vertex(void)
{
	x = y = z = 0.0f;
	color = specular = 0;
	tu = tv = 0.0f;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex constructor
//////////////////////////////////////////////////////////////////////////////////
C3D_Vertex::C3D_Vertex(float _x, float _y, float _z)
{
	x = _x;
	y = _y;
	z = _z;
	color = specular = 0;
	tu = tv = 0.0f;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex constructor
//////////////////////////////////////////////////////////////////////////////////
C3D_Vertex::C3D_Vertex(float _x, float _y, float _z, DWORD c, DWORD s)
{
	x = _x;
	y = _y;
	z = _z;
	color = c;
	specular = s;
	tu = tv = 0.0f;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex constructor
//////////////////////////////////////////////////////////////////////////////////
C3D_Vertex::C3D_Vertex(float _x, float _y, float _z, DWORD c, DWORD s, float _tu, float _tv)
{
	x = _x;
	y = _y;
	z = _z;
	color = c;
	specular = s;
	tu = _tu;
	tv = _tv;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex copy constructor
//////////////////////////////////////////////////////////////////////////////////
C3D_Vertex::C3D_Vertex(C3D_Vertex* vertex)
{
	x = vertex->x;
	y = vertex->y;
	z = vertex->z;
	color = vertex->color;
	specular = vertex->specular;
	tu = vertex->tu;
	tv = vertex->tv;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex = operator
//////////////////////////////////////////////////////////////////////////////////
C3D_Vertex &C3D_Vertex::operator = (const C3D_Vertex &vertex)
{
	x = vertex.x;
	y = vertex.y;
	z = vertex.z;
	color = vertex.color;
	specular = vertex.specular;
	tu = vertex.tu;
	tv = vertex.tv;

	return *this;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex + operator
//////////////////////////////////////////////////////////////////////////////////
C3D_Vertex &C3D_Vertex::operator + (const C3D_Vertex &vertex)
{
	return C3D_Vertex(x + vertex.x, y + vertex.y, z + vertex.z);
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex + operator
//////////////////////////////////////////////////////////////////////////////////
C3D_Vertex &C3D_Vertex::operator + (const C3D_Vector &vector)
{
	return C3D_Vertex(x + vector.x, y + vector.y, z + vector.z);
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex - operator
//////////////////////////////////////////////////////////////////////////////////
C3D_Vertex &C3D_Vertex::operator - (const C3D_Vertex &vertex)
{
	return C3D_Vertex(x - vertex.x, y - vertex.y, z - vertex.z);
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex Locate
//////////////////////////////////////////////////////////////////////////////////
void C3D_Vertex::Locate(float _x, float _y, float _z)
{
	x = _x;
	y = _y;
	z = _z;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex Transform
//////////////////////////////////////////////////////////////////////////////////
void C3D_Vertex::Transform(C3D_Matrix* m)
{
	x = (m->_11 * x) + (m->_21 * y) + (m->_31 * z) + m->_41;
	y = (m->_12 * x) + (m->_22 * y) + (m->_32 * z) + m->_42;
	z = (m->_13 * x) + (m->_23 * y) + (m->_33 * z) + m->_43;
}

//////////////////////////////////////////////////////////////////////////////////
// C3D_Vertex Print
//////////////////////////////////////////////////////////////////////////////////
void C3D_Vertex::Print(void)
{
	printf("x = %.5f, y = %.5f, z = %.5f\n", x, y, z);
}
