//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDI Class Library - CDI.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ CDI_Keyboard Implementation ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDI.h"

//////////////////////////////////////////////////////////////////////////////////
// CDI_Keyboard Constructor
//////////////////////////////////////////////////////////////////////////////////
CDI_Keyboard::CDI_Keyboard(void)
{
	m_Device = NULL;
	m_bActive = FALSE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Keyboard Destructor
//////////////////////////////////////////////////////////////////////////////////
CDI_Keyboard::~CDI_Keyboard(void)
{
	m_Device->Unacquire();
	RELEASE(m_Device);
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Keyboard Create
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDI_Keyboard::Create(CDI_Input* input, void* hwnd)
{
	HRESULT rval;
	LPDIRECTINPUTDEVICE lpDID = NULL;

	// Create the keyboard device
	rval = input->GetDI()->CreateDevice(GUID_SysKeyboard, &lpDID, NULL);
	if(rval == DI_OK)
	{
		rval = lpDID->QueryInterface(IID_IDirectInputDevice2, (LPVOID*)&m_Device);
		if(rval != DI_OK) return rval;

		RELEASE(lpDID);

		m_Device->SetDataFormat(&c_dfDIKeyboard);
		m_Device->SetCooperativeLevel(hwnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);

		rval = m_Device->Acquire();
		if(rval != DI_OK) return rval;

		m_bActive = TRUE;
	}

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// CDI_Keyboard Update
//////////////////////////////////////////////////////////////////////////////////
void CDI_Keyboard::Update(void)
{
	if(m_bActive)
		if(m_Device->GetDeviceState(256, &m_Keys) == (DIERR_INPUTLOST | DIERR_NOTACQUIRED))
			m_Device->Acquire();
}
