//////////////////////////////////////////////////////////////////////////////////
// Project Name:   [ CDS Class Library - CDS.lib ]
// Author:         [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:    [ CDS_3DBuffer Implementation ]
// Revision:       [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDS.h"

//////////////////////////////////////////////////////////////////////////////////
// CDS_3DBuffer Create
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDS_3DBuffer::Create(CDS_Sound* sound, char* filename, int count)
{
	HRESULT rval;
	LPVOID Audio;
	DWORD Bytes;
	UINT BytesRead;
	DSBUFFERDESC desc;
	int i;

	// Create enough space for the buffers
	m_BufferCount = count;
	m_Buffer = new LPDIRECTSOUNDBUFFER[((m_BufferCount-1) * sizeof(LPDIRECTSOUNDBUFFER))];
	if(m_Buffer == NULL) return -1;

	// Open the file and get ready to read
	m_WaveFile = new CDS_WaveFile;
	m_WaveFile->Open(filename);

	memset(&desc, 0, sizeof(DSBUFFERDESC));
	desc.dwSize = sizeof(DSBUFFERDESC);
	desc.dwFlags = DSBCAPS_STATIC | DSBCAPS_CTRL3D;
	desc.dwBufferBytes = m_WaveFile->m_mmckiData.cksize;
	desc.lpwfxFormat = m_WaveFile->m_pFormat;

	rval = sound->GetDS()->CreateSoundBuffer(&desc, &m_Buffer[0], NULL);
	if(rval != DS_OK) goto CREATE_ERROR;

	rval = m_Buffer[0]->Lock(0, 0, &Audio, &Bytes, NULL, NULL, DSBLOCK_ENTIREBUFFER);
	if(rval != DS_OK) goto CREATE_ERROR;

	// Read the data from the file into the buffer
	BytesRead = m_WaveFile->Read((BYTE*)Audio, Bytes);

	rval = m_Buffer[0]->Unlock(Audio, Bytes, NULL, 0);
	if(rval != DS_OK) goto CREATE_ERROR;

	for(i = 0; i < m_BufferCount; i++)
		rval = sound->m_DirectSound->DuplicateSoundBuffer(m_Buffer[0], &m_Buffer[i]);

	// Obtain the 3D interface
	rval = m_Buffer[0]->QueryInterface(IID_IDirectSound3DBuffer, (LPVOID*)&m_3dBuffer);
	if(rval != S_OK) goto CREATE_ERROR;

CREATE_ERROR:
	return rval;
}
