//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDS Class Library - CDS.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ CDS_Music Implementation ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDS.h"

//////////////////////////////////////////////////////////////////////////////////
// CDS_Music Constructor
//////////////////////////////////////////////////////////////////////////////////
CDS_Music::CDS_Music(void *hwnd)
{
	m_hWnd = hwnd;
}

//////////////////////////////////////////////////////////////////////////////////
// CDS_Music Play
//////////////////////////////////////////////////////////////////////////////////
BOOL CDS_Music::Play(const char *filename)
{
	if(filename == NULL) return FALSE;
	char buffer[256];

	sprintf(buffer, "open %s type sequencer alias MUSIC", filename);

	if(mciSendString("close all", NULL, 0, NULL) != 0)
		return(FALSE);

	if(mciSendString(buffer, NULL, 0, NULL) != 0)
		return(FALSE);

	if(mciSendString("play MUSIC from 0 notify", NULL, 0, m_hWnd) != 0)
		return(FALSE);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDS_Music Stop
//////////////////////////////////////////////////////////////////////////////////
CDS_Music::Stop()
{
	if(mciSendString("close all", NULL, 0, NULL) != 0)
		return(FALSE);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDS_Music Pause
//////////////////////////////////////////////////////////////////////////////////
BOOL CDS_Music::Pause(void)
{
	if(mciSendString("stop MUSIC", NULL, 0, NULL) != 0)
		return(FALSE);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDS_Music Stop
//////////////////////////////////////////////////////////////////////////////////
BOOL CDS_Music::Resume(void)
{
	if(mciSendString("play MUSIC notify", NULL, 0, m_hWnd) != 0)
		return(FALSE);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDS_Music Stop
//////////////////////////////////////////////////////////////////////////////////
BOOL CDS_Music::Restart(void)
{
	if(mciSendString("play MUSIC from 0 notify", NULL, 0, m_hWnd) != 0)
		return(FALSE);

	return TRUE;
}
