//////////////////////////////////////////////////////////////////////////////////
// Source File:  [ CDS_Sound Implementation ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDS.h"

//////////////////////////////////////////////////////////////////////////////////
// CDS_Sound Constructor
//////////////////////////////////////////////////////////////////////////////////
CDS_Sound::CDS_Sound()
{
	m_Listener = NULL;
	m_Primary = NULL;
	m_DirectSound = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// CDS_Sound Destructor
//////////////////////////////////////////////////////////////////////////////////
CDS_Sound::~CDS_Sound()
{
	SAFE_RELEASE(m_Listener);
	SAFE_RELEASE(m_Primary);
	SAFE_RELEASE(m_DirectSound);
}

//////////////////////////////////////////////////////////////////////////////////
// CDS_Sound Create
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDS_Sound::Create(void *hwnd)
{
	HRESULT rval;
	DSBUFFERDESC desc;

	rval = DirectSoundCreate(NULL, &m_DirectSound, NULL);
	if(rval != DS_OK) return rval;

	rval = m_DirectSound->SetCooperativeLevel(hwnd, DSSCL_EXCLUSIVE);
	if(rval != DS_OK) return rval;

	ZeroMemory(&desc, sizeof(DSBUFFERDESC));
	desc.dwSize = sizeof(DSBUFFERDESC);
	desc.dwFlags = DSBCAPS_CTRL3D | DSBCAPS_PRIMARYBUFFER;

	// Create the primary buffer
	rval = m_DirectSound->CreateSoundBuffer(&desc, &m_Primary, NULL);
	if(rval != DS_OK) return rval;

	// Obtain the listener interface
	rval = m_Primary->QueryInterface(IID_IDirectSound3DListener, (LPVOID*)&m_Listener);
	if(rval != DS_OK) return rval;

	return rval;
}
