//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDX Class Library - CDX.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ Main Header File ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDX_H
#define CDX_H

#include <stdio.h>
#include <ddraw.h>
#include <d3d.h>

//////////////////////////////////////////////////////////////////////////////////
// Definied Types
//////////////////////////////////////////////////////////////////////////////////

#define SAFE_RELEASE(x) if(x != NULL) { x->Release(); x = NULL; }
#define SAFE_DELETE(x) if(x != NULL) { delete x; x = NULL; }

#define CDXCREATE_FULLSCREEN   0x00000001L
#define CDXCREATE_NO_FPUSETUP  0x00000002L
#define CDXCREATE_ZBUFFER      0x00000004L
#define CDXCREATE_3D           0x00000008L

class CDX_Surface;

//////////////////////////////////////////////////////////////////////////////////
// CDX_Screen Class
//////////////////////////////////////////////////////////////////////////////////

class CDX_Screen
{
public:
	CDX_Screen(void);
	~CDX_Screen(void);

	HRESULT Create(HWND hwnd, DWORD width, DWORD height, DWORD bpp, DWORD flags);
	HRESULT Restore(void);
	HRESULT Flip(void);

	LPDIRECTDRAW4 GetDD(void) { return m_DirectDraw; }
	LPDIRECT3D3 GetD3D(void) { return m_Direct3D; }
	LPDIRECT3DDEVICE3 GetDevice(void) { return m_Device; }
	LPDIRECT3DVIEWPORT3 GetViewport(void) { return m_Viewport; }

	CDX_Surface* GetFront(void) { return m_FrontBuffer; }
	CDX_Surface* GetBack(void)  { return m_BackBuffer; }
	CDX_Surface* GetDepth(void) { return m_DepthBuffer; }

	int GetWidth(void) { return m_Width; }
	int GetHeight(void) { return m_Height; }
	int GetBpp(void) { return m_Bpp; }

public:
	void Initialise(void);
	void Finalise(void);

	HRESULT CreateDirectDraw(void);
	HRESULT CreateBuffers(void);
	HRESULT CreateZBuffer(void);
	HRESULT CreateDirect3D(void);
	HRESULT CreateDevice(void);
	HRESULT CreateViewport(void);

	LPDIRECTDRAW4 m_DirectDraw;
	LPDIRECT3D3 m_Direct3D;
	LPDIRECT3DDEVICE3 m_Device;
	LPDIRECT3DVIEWPORT3 m_Viewport;

	D3DDEVICEDESC m_DeviceDesc;
	DDPIXELFORMAT m_PixelFormat;
	DWORD m_MemoryType;

	CDX_Surface* m_FrontBuffer;
	CDX_Surface* m_BackBuffer;
	CDX_Surface* m_DepthBuffer;

	HWND  m_Hwnd;
	DWORD m_Width;
	DWORD m_Height;
	DWORD m_Bpp;
	RECT  m_ScreenRect;
	RECT  m_ViewportRect;
	BOOL  m_IsFullScreen;
	BOOL  m_Is3D;
	BOOL  m_IsFPU;
};

//////////////////////////////////////////////////////////////////////////////////
// CDX_Surface Class
//////////////////////////////////////////////////////////////////////////////////

class CDX_Surface
{
public:
	CDX_Surface();
	~CDX_Surface();

	void Initialise(void);
	void Finalise(void);

	HRESULT Create(CDX_Screen*);
	HRESULT Create(CDX_Screen*, int , int);

	HRESULT LoadBitmap(CDX_Screen*, const char*);
 	HRESULT CopyBitmap(HBITMAP, int, int, int, int);
	HRESULT Restore(void);
	HRESULT Lock(void);
	HRESULT UnLock(void);
	HRESULT GetDC(void) { return m_Surface->GetDC(&m_DC); }
	HRESULT ReleaseDC(void) { return m_Surface->ReleaseDC(m_DC); }
	HRESULT Fill(DWORD);
	HRESULT SetColorKey(COLORREF);
	HRESULT SetFont(const char*, int, int, int Attributes = FW_NORMAL);
	HRESULT TextXY(int X, int Y, COLORREF, const char*);
	virtual HRESULT Draw(CDX_Surface* Dest, DWORD Flags);
	virtual HRESULT DrawFast(int X, int Y, CDX_Surface* Dest, DWORD Flags);

	void SetSrc(int, int, int, int);
	void SetDest(int, int, int, int);
	int  GetWidth(void)  { return m_Width; }
	int  GetHeight(void) { return m_Height; }
	LPDIRECTDRAWSURFACE4 GetSurface(void) { return m_Surface; }

public:
	LPDIRECTDRAWSURFACE4 m_Surface;
	DDSURFACEDESC2 m_Desc;
	DDSCAPS2 m_Caps;

	int  m_Width;
	int  m_Height;
	RECT m_SrcRect;
	RECT m_DestRect;

	HDC m_DC;
	HFONT m_Font;
	const char* m_Filename;
};

#endif
