//////////////////////////////////////////////////////////////////////////
// Project Name: [ Page Flipping Demo ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Link:         [ cdx.lib, ddraw.lib, dxguid.lib ]
//////////////////////////////////////////////////////////////////////////
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <CDX.h>

CDX_Screen* g_Screen;
HWND g_Hwnd;
int g_Toggle = 0;

/////////////////////////////////////////////////////////////////////////////////////////////
// WinProc
/////////////////////////////////////////////////////////////////////////////////////////////
long PASCAL WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_TIMER:
		{
			if(g_Toggle)
			{
				// Fill the back buffer red
				g_Screen->GetBack()->Fill(RGB(255,0,0));
				g_Toggle = 0;
			}
			else
			{
				// Fill the back buffer blue
				g_Screen->GetBack()->Fill(RGB(0,0,255));
				g_Toggle = 1;
			}

			// Flip the back buffer to the front
			g_Screen->Flip();
		}
		return 0;

		case WM_KEYDOWN:
		switch(wParam)
		{
			// Handle mode switching
			case VK_TAB:
			{
				g_Screen->m_IsFullScreen = !g_Screen->m_IsFullScreen;
				if(g_Screen->m_IsFullScreen)
				{
					g_Screen->Finalise();
					g_Screen->Create(g_Hwnd, 640, 480, 24, CDXCREATE_FULLSCREEN);
				}
				else
				{
					g_Screen->Finalise();
					g_Screen->Create(g_Hwnd, 640, 480, 24, NULL);
				}
			}
			break;

			case VK_ESCAPE:
				PostMessage(hWnd, WM_CLOSE, 0, 0);
			return 0;
		}
		return 0;

		case WM_DESTROY:
			PostQuitMessage(0);
		return 0;

		default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////
// InitApp - Create the window and the CDX objects
/////////////////////////////////////////////////////////////////////////////////////////////
BOOL InitApp(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;
	WNDCLASS WndClass;

	WndClass.style = CS_HREDRAW | CS_VREDRAW;
	WndClass.lpfnWndProc = WinProc;
	WndClass.cbClsExtra = 0;
	WndClass.cbWndExtra = 0;
	WndClass.hInstance = hInst;
	WndClass.hIcon = LoadIcon(0, IDI_APPLICATION);
	WndClass.hCursor = LoadCursor(0, IDC_ARROW);
	WndClass.hbrBackground = GetStockObject(BLACK_BRUSH);
	WndClass.lpszMenuName = 0;
	WndClass.lpszClassName = "Flip";
	RegisterClass(&WndClass);

	hWnd = CreateWindow(
		"Flip",
		"Flip",
 		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		NULL,
		hInst,
		NULL);

	if(!hWnd) return FALSE;

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	// Create the CDXSreen object
	g_Screen = new CDX_Screen();
	g_Screen->Create(hWnd, 640, 480, 24, NULL);

	// Setup a timer for the screen flip
	SetTimer(hWnd, 1, 500, NULL);

	g_Hwnd = hWnd;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////
// WinMain
/////////////////////////////////////////////////////////////////////////////////////////////
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;

	if(!InitApp(hInst, nCmdShow)) return FALSE;

	while(GetMessage(&msg, 0, 0, 0) == TRUE)
	{
		TranslateMessage(&msg); 
		DispatchMessage(&msg);
	}

	return msg.wParam;
}
