// 3dDlg.h
//
// Copyright (c) Nigel Thompson 1996
//
// This file defines all the dialog,
// property sheet and property page classes.
// It is automatically included when you include 3dPlus.h
//

#ifndef _3DDLG_H_
#define _3DDLG_H_

////////////////////////////////////////////////////////////////////////
// callback function prototypes

// Called when a modeless dialog closes so its creator will know
typedef void (CALLBACK * ONCLOSEDLGFN)(void* pArg);

// Called to request a pointer to a 3dFrame object to manipulate
typedef C3dFrame* (CALLBACK * GET3DFRAMEFN)(void *pArg);

// Called to request a pointer to a 3dShape object to manipulate
typedef C3dShape* (CALLBACK * GET3DSHAPEFN)(void *pArg);

///////////////////////////////////////////////////////////////////////////
// Shape creation property pages

class CShapePage : public CPropertyPage
{
	DECLARE_DYNCREATE(CShapePage)
public:
	CShapePage();
	CShapePage(UINT id);
	virtual C3dShape* CreateShape();

protected:
};

class CSpherePage : public CShapePage
{
	DECLARE_DYNCREATE(CSpherePage)

// Construction
public:
	CSpherePage();
	~CSpherePage();
	virtual C3dShape* CreateShape();

// Dialog Data
	//{{AFX_DATA(CSpherePage)
	enum { IDD = _3D_IDPP_SPHERE };
	double	m_dDia;
	double	m_dX;
	double	m_dY;
	double	m_dZ;
	double	m_dRad;
	//}}AFX_DATA
	int m_iDetail;


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CSpherePage)
	public:
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CSpherePage)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CConePage : public CShapePage
{
	DECLARE_DYNCREATE(CConePage)

// Construction
public:
	CConePage();
	~CConePage();
	virtual C3dShape* CreateShape();

// Dialog Data
	//{{AFX_DATA(CConePage)
	enum { IDD = _3D_IDPP_CONE };
	BOOL	m_bBClosed;
	double	m_dBR;
	double	m_dBX;
	double	m_dBY;
	double	m_dBZ;
	BOOL	m_bTClosed;
	double	m_dTR;
	double	m_dTX;
	double	m_dTY;
	double	m_dTZ;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CConePage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CConePage)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CCubePage : public CShapePage
{
	DECLARE_DYNCREATE(CCubePage)

// Construction
public:
	CCubePage();
	~CCubePage();
	virtual C3dShape* CreateShape();

// Dialog Data
	//{{AFX_DATA(CCubePage)
	enum { IDD = _3D_IDPP_CUBOID };
	double	m_dX;
	double	m_dY;
	double	m_dZ;
	double	m_dXL;
	double	m_dYL;
	double	m_dZL;
	double	m_dXD;
	double	m_dXU;
	double	m_dYD;
	double	m_dYU;
	double	m_dZD;
	double	m_dZU;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CCubePage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CCubePage)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CObjectPage : public CShapePage
{
	DECLARE_DYNCREATE(CObjectPage)

// Construction
public:
	CObjectPage();
	~CObjectPage();
	virtual C3dShape* CreateShape();

// Dialog Data
	//{{AFX_DATA(CObjectPage)
	enum { IDD = _3D_IDPP_OBJECT };
	CString	m_strFilename;
	double	m_dX;
	double	m_dXD;
	double	m_dXU;
	double	m_dY;
	double	m_dYD;
	double	m_dYU;
	double	m_dZ;
	double	m_dZD;
	double	m_dZU;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CObjectPage)
	public:
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CObjectPage)
	afx_msg void OnBrowse();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CAirPage dialog

class CAirPage : public CShapePage
{
	DECLARE_DYNCREATE(CAirPage)

// Construction
public:
	CAirPage();
	~CAirPage();
	virtual C3dShape* CreateShape();

	// Dialog Data
	//{{AFX_DATA(CAirPage)
	enum { IDD = _3D_IDPP_AIRPLANE };
	double	m_dX;
	double	m_dY;
	double	m_dZ;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CAirPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CAirPage)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////
// Insert Shape Dialog

class CShapeDlg : public CPropertySheet
{
	DECLARE_DYNAMIC(CShapeDlg)

// Construction
public:
	CShapeDlg(LPCTSTR pszCaption, CWnd* pParentWnd = NULL);

// Attributes
public:
	C3dShape* m_pShape;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CShapeDlg)
	protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CShapeDlg();

	// Generated message map functions
protected:
	
	CSpherePage m_SpherePage;
	CCubePage m_CubePage;
	CObjectPage m_ObjectPage;
	CConePage m_ConePage;
	CAirPage m_AirPage;

	void OnOK();

	//{{AFX_MSG(CShapeDlg)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////
// Transform property pages

class CTransformDlg;

class CTransformPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CTransformPage)
public:
	CTransformPage();
	CTransformPage(UINT id);
	void AddTransform(C3dMatrix& m, D3DRMCOMBINETYPE ct);

	CTransformDlg* m_pTranDlg;
protected:
};



class CTranslatePage : public CTransformPage
{
	DECLARE_DYNCREATE(CTranslatePage)

// Construction
public:
	CTranslatePage();
	~CTranslatePage();

// Dialog Data
	//{{AFX_DATA(CTranslatePage)
	enum { IDD = _3D_IDPP_TRANSLATE };
	double	m_dX;
	double	m_dY;
	double	m_dZ;
	//}}AFX_DATA

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CTranslatePage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CTranslatePage)
	afx_msg void OnBefore();
	afx_msg void OnAfter();
	afx_msg void OnReplace();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


class CRotatePage : public CTransformPage
{
	DECLARE_DYNCREATE(CRotatePage)

// Construction
public:
	CRotatePage();
	~CRotatePage();

// Dialog Data
	//{{AFX_DATA(CRotatePage)
	enum { IDD = _3D_IDPP_ROTATE };
	double	m_dX;
	double	m_dY;
	double	m_dZ;
	//}}AFX_DATA

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CRotatePage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CRotatePage)
	afx_msg void OnBefore();
	afx_msg void OnAfter();
	afx_msg void OnReplace();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


class CScalePage : public CTransformPage
{
	DECLARE_DYNCREATE(CScalePage)

// Construction
public:
	CScalePage();
	~CScalePage();

// Dialog Data
	//{{AFX_DATA(CScalePage)
	enum { IDD = _3D_IDPP_SCALE };
	double	m_dX;
	double	m_dY;
	double	m_dZ;
	//}}AFX_DATA

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CScalePage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CScalePage)
	afx_msg void OnBefore();
	afx_msg void OnAfter();
	afx_msg void OnReplace();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////
// Transform Dialog

class CTransformDlg : public CPropertySheet
{
	DECLARE_DYNAMIC(CTransformDlg)

// Construction
public:
	CTransformDlg(LPCTSTR pszCaption, 
				  ONCLOSEDLGFN pOnCloseFn,
				  GET3DFRAMEFN pGet3dFrameFn,
				  void *pArg);
	C3dFrame* GetFrame()
		{ASSERT(m_pGet3dFrameFn); return m_pGet3dFrameFn(m_pArg);}

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTransformDlg)
	protected:
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CTransformDlg();

	// Generated message map functions
protected:
	ONCLOSEDLGFN m_pOnCloseFn;
	GET3DFRAMEFN m_pGet3dFrameFn;
	void* m_pArg;
	CTranslatePage m_TranPage;
	CRotatePage m_RotPage;
	CScalePage m_ScalePage;




	//{{AFX_MSG(CTransformDlg)
	afx_msg void OnClose();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CAxesPage dialog

class CJoyValCtl;

typedef struct _AXPGROW {
  CComboBox* pcbIn;
  CJoyValCtl* pjvIn;
  CComboBox* pcbBtn;
  int* piDead;
  double* pdScale;
  CJoyValCtl* pjvOut;
} AXPGROW;

class CAxesPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CAxesPage)

// Construction
public:
	CAxesPage();
	~CAxesPage();

// Dialog Data
	//{{AFX_DATA(CAxesPage)
	enum { IDD = _3D_IDPP_JOYAXIS };
	CComboBox	m_cbZin;
	CComboBox	m_cbYin;
	CComboBox	m_cbXin;
	CComboBox	m_cbVin;
	CComboBox	m_cbUin;
	CComboBox	m_cbRin;
	CComboBox	m_cbZbtn;
	CComboBox	m_cbYbtn;
	CComboBox	m_cbXbtn;
	CComboBox	m_cbVbtn;
	CComboBox	m_cbUbtn;
	CComboBox	m_cbRbtn;
	int		m_iRdead;
	int		m_iUdead;
	int		m_iVdead;
	int		m_iXdead;
	int		m_iYdead;
	int		m_iZdead;
	double	m_dRscale;
	double	m_dUscale;
	double	m_dVscale;
	double	m_dXscale;
	double	m_dYscale;
	double	m_dZscale;
	//}}AFX_DATA
	C3dJoyInDev* m_pDev;
	UINT m_uiTimer;
	AXPGROW m_row[6];

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CAxesPage)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnApply();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CAxesPage)
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	void SetInList(CComboBox* pcb);
	void SetBtnList(CComboBox* pcb);
	void ShowState();
};

/////////////////////////////////////////////////////////////////////////////
// CJoyValCtl window

class CJoyValCtl : public CWnd
{
// Construction
public:
	CJoyValCtl();

// Attributes
public:

// Operations
public:
    static BOOL Register();
	void SetRange(int iMin, int iMax);
	void SetDeadBand(int iMin, int iMax);
	void SetValue(int iVal);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CJoyValCtl)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CJoyValCtl();

	// Generated message map functions
protected:
	//{{AFX_MSG(CJoyValCtl)
	afx_msg void OnNcDestroy();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    static BOOL m_bRegistered;
	CRect m_rcWnd;
	int m_iMin;
	int m_iMax;
	int m_iDeadMin;
	int m_iDeadMax;
	int m_iVal;

	static LRESULT CALLBACK JoyValWndProc(HWND hWnd, UINT uiMsg, WPARAM wParam, LPARAM lParam);
};


#endif // _3DDLG_H_

