// 3dErr.cpp
//
// Copyright (c) Nigel Thompson 1996
//
// Implementation for:
// Get3dError
//

#include "stdafx.h"

// Error message table

typedef struct __3DERRMSG {
	HRESULT hr;
	const char* pszMsg;
} _3DERRMSG;

_3DERRMSG _3dErrMsg[] = {
	DD_OK,"No error.",
	DDERR_ALREADYINITIALIZED,					"This object is already initialized.",
	DDERR_BLTFASTCANTCLIP,						"If a clipper object is attached to the source surface passed into a BltFast call.",
	DDERR_CANNOTATTACHSURFACE,					"This surface can not be attached to the requested surface.",
	DDERR_CANNOTDETACHSURFACE,					"This surface can not be detached from the requested surface.",
	DDERR_CANTCREATEDC,							"Windows can not create any more DCs.",
	DDERR_CANTDUPLICATE,						"Can't duplicate primary & 3D surfaces, or surfaces that are implicitly created.",
	DDERR_CLIPPERISUSINGHWND,					"An attempt was made to set a cliplist for a clipper object that is already monitoring an hwnd.",
	DDERR_COLORKEYNOTSET,						"No src color key specified for this operation.",
	DDERR_CURRENTLYNOTAVAIL,					"Support is currently not available.",
	DDERR_DIRECTDRAWALREADYCREATED,				"A DirectDraw object representing this driver has already been created for this process.",
	DDERR_EXCEPTION,							"An exception was encountered while performing the requested operation.",
	DDERR_EXCLUSIVEMODEALREADYSET,				"An attempt was made to set the cooperative level when it was already set to exclusive.",
	DDERR_GENERIC,								"Generic failure.",
	DDERR_HEIGHTALIGN,							"Height of rectangle provided is not a multiple of reqd alignment.",
	DDERR_HWNDALREADYSET,						"The CooperativeLevel HWND has already been set. It can not be reset while the process has surfaces or palettes created.",
	DDERR_HWNDSUBCLASSED,						"HWND used by DirectDraw CooperativeLevel has been subclassed, this prevents DirectDraw from restoring state.",
	DDERR_IMPLICITLYCREATED,					"This surface can not be restored because it is an implicitly created surface.",
	DDERR_INCOMPATIBLEPRIMARY,					"Unable to match primary surface creation request with existing primary surface.",
	DDERR_INVALIDCAPS,							"One or more of the caps bits passed to the callback are incorrect.",
	DDERR_INVALIDCLIPLIST,						"DirectDraw does not support the provided cliplist.",
	DDERR_INVALIDDIRECTDRAWGUID,				"The GUID passed to DirectDrawCreate is not a valid DirectDraw driver identifier.",
	DDERR_INVALIDMODE,							"DirectDraw does not support the requested mode.",
	DDERR_INVALIDOBJECT,						"DirectDraw received a pointer that was an invalid DIRECTDRAW object.",
	DDERR_INVALIDPARAMS,						"One or more of the parameters passed to the function are incorrect.",
	DDERR_INVALIDPIXELFORMAT,					"The pixel format was invalid as specified.",
	DDERR_INVALIDPOSITION,						"Returned when the position of the overlay on the destination is no longer legal for that destination.",
	DDERR_INVALIDRECT,							"Rectangle provided was invalid.",
	DDERR_LOCKEDSURFACES,						"Operation could not be carried out because one or more surfaces are locked.",
	DDERR_NO3D,									"There is no 3D present.",
	DDERR_NOALPHAHW,							"Operation could not be carried out because there is no alpha accleration hardware present or available.",
	DDERR_NOBLTHW,								"No blitter hardware present.",
	DDERR_NOCLIPLIST,							"No cliplist available.",
	DDERR_NOCLIPPERATTACHED,					"No clipper object attached to surface object.",
	DDERR_NOCOLORCONVHW,						"Operation could not be carried out because there is no color conversion hardware present or available.",
	DDERR_NOCOLORKEY,							"Surface doesn't currently have a color key",
	DDERR_NOCOLORKEYHW,							"Operation could not be carried out because there is no hardware support of the destination color key.",
	DDERR_NOCOOPERATIVELEVELSET,				"Create function called without DirectDraw object method SetCooperativeLevel being called.",
	DDERR_NODC,									"No DC was ever created for this surface.",
	DDERR_NODDROPSHW,							"No DirectDraw ROP hardware.",
	DDERR_NODIRECTDRAWHW,						"A hardware-only DirectDraw object creation was attempted but the driver did not support any hardware.",
	DDERR_NOEMULATION,							"Software emulation not available.",
	DDERR_NOEXCLUSIVEMODE,						"Operation requires the application to have exclusive mode but the application does not have exclusive mode.",
	DDERR_NOFLIPHW,								"Flipping visible surfaces is not supported.",
	DDERR_NOGDI,								"There is no GDI present.",
	DDERR_NOHWND,								"Clipper notification requires an HWND or no HWND has previously been set as the CooperativeLevel HWND.",
	DDERR_NOMIRRORHW,							"Operation could not be carried out because there is no hardware present or available.",
	DDERR_NOOVERLAYDEST,						"Returned when GetOverlayPosition is called on an overlay that UpdateOverlay has never been called on to establish a destination.",
	DDERR_NOOVERLAYHW,							"Operation could not be carried out because there is no overlay hardware present or available.",
	DDERR_NOPALETTEATTACHED,					"No palette object attached to this surface.",
	DDERR_NOPALETTEHW,							"No hardware support for 16 or 256 color palettes.",
	DDERR_NORASTEROPHW,							"Operation could not be carried out because there is no appropriate raster op hardware present or available.",
	DDERR_NOROTATIONHW,							"Operation could not be carried out because there is no rotation hardware present or available.",
	DDERR_NOSTRETCHHW,							"Operation could not be carried out because there is no hardware support for stretching.",
	DDERR_NOT4BITCOLOR,							"DirectDrawSurface is not in 4 bit color palette and the requested operation requires 4 bit color palette.",
	DDERR_NOT4BITCOLORINDEX,					"DirectDrawSurface is not in 4 bit color index palette and the requested operation requires 4 bit color index palette.",
	DDERR_NOT8BITCOLOR,							"DirectDrawSurface is not in 8 bit color mode and the requested operation requires 8 bit color.",
	DDERR_NOTAOVERLAYSURFACE,					"Returned when an overlay member is called for a non-overlay surface.",
	DDERR_NOTEXTUREHW,							"Operation could not be carried out because there is no texture mapping hardware present or available.",
	DDERR_NOTFLIPPABLE,							"An attempt has been made to flip a surface that is not flippable.",
	DDERR_NOTFOUND,								"Requested item was not found.",
	DDERR_NOTLOCKED,							"Surface was not locked.An attempt to unlock a surface that was not locked at all, or by this process, has been attempted.",
	DDERR_NOTPALETTIZED,						"The surface being used is not a palette-based surface.",
	DDERR_NOVSYNCHW,							"Operation could not be carried out because there is no hardware support for vertical blank synchronized operations.",
	DDERR_NOZBUFFERHW,							"Operation could not be carried out because there is no hardware support for zbuffer blitting.",
	DDERR_NOZOVERLAYHW,							"Overlay surfaces could not be z layered based on their BltOrder because the hardware does not support z layering of overlays.",
	DDERR_OUTOFCAPS,							"The hardware needed for the requested operation has already been allocated.",
	DDERR_OUTOFMEMORY,							"DirectDraw does not have enough memory to perform the operation.",
	DDERR_OUTOFVIDEOMEMORY,						"DirectDraw does not have enough memory to perform the operation.",
	DDERR_OVERLAYCANTCLIP,						"The hardware does not support clipped overlays.",
	DDERR_OVERLAYCOLORKEYONLYONEACTIVE,			"Can only have ony color key active at one time for overlays.",
	DDERR_OVERLAYNOTVISIBLE,					"Returned when GetOverlayPosition is called on a hidden overlay.",
	DDERR_PALETTEBUSY,							"Access to this palette is being refused because the palette is already locked by another thread.",
	DDERR_PRIMARYSURFACEALREADYEXISTS,			"This process already has created a primary surface.",
	DDERR_REGIONTOOSMALL,						"Region passed to Clipper,,			GetClipList is too small.",
	DDERR_SURFACEALREADYATTACHED,				"This surface is already attached to the surface it is being attached to.",
	DDERR_SURFACEALREADYDEPENDENT,				"This surface is already a dependency of the surface it is being made a dependency of.",
	DDERR_SURFACEBUSY,							"Access to this surface is being refused because the surface is already locked by another thread.",
	DDERR_SURFACEISOBSCURED,					"Access to surface refused because the surface is obscured.",
	DDERR_SURFACELOST,							"Access to this surface is being refused because the surface memory is gone. The DirectDrawSurface object representing this surface should have Restore called on it.",
	DDERR_SURFACENOTATTACHED,					"The requested surface is not attached.",
	DDERR_TOOBIGHEIGHT,							"Height requested by DirectDraw is too large.",
	DDERR_TOOBIGSIZE,							"Size requested by DirectDraw is too large, but the individual height and width are OK.",
	DDERR_TOOBIGWIDTH,							"Width requested by DirectDraw is too large.",
	DDERR_UNSUPPORTED,							"Action not supported.",
	DDERR_UNSUPPORTEDFORMAT,					"FOURCC format requested is unsupported by DirectDraw.",
	DDERR_UNSUPPORTEDMASK,						"Bitmask in the pixel format requested is unsupported by DirectDraw.",
	DDERR_VERTICALBLANKINPROGRESS,				"Vertical blank is in progress.",
	DDERR_WASSTILLDRAWING,						"Informs DirectDraw that the previous Blt which is transfering information to or from this Surface is incomplete.",
	DDERR_WRONGMODE,							"This surface can not be restored because it was created in a different mode.",
	DDERR_XALIGN,								"Rectangle provided was not horizontally aligned on required boundary.",
	D3DERR_BADMAJORVERSION,						"D3DERR_BADMAJORVERSION",
	D3DERR_BADMINORVERSION,						"D3DERR_BADMINORVERSION",
	D3DERR_EXECUTE_LOCKED,						"D3DERR_EXECUTE_LOCKED",
	D3DERR_EXECUTE_NOT_LOCKED,					"D3DERR_EXECUTE_NOT_LOCKED",
	D3DERR_EXECUTE_CREATE_FAILED,				"D3DERR_EXECUTE_CREATE_FAILED",
	D3DERR_EXECUTE_DESTROY_FAILED,				"D3DERR_EXECUTE_DESTROY_FAILED",
	D3DERR_EXECUTE_LOCK_FAILED,					"D3DERR_EXECUTE_LOCK_FAILED",
	D3DERR_EXECUTE_UNLOCK_FAILED,				"D3DERR_EXECUTE_UNLOCK_FAILED",
	D3DERR_EXECUTE_FAILED,						"D3DERR_EXECUTE_FAILED",
	D3DERR_EXECUTE_CLIPPED_FAILED,				"D3DERR_EXECUTE_CLIPPED_FAILED",
	D3DERR_TEXTURE_NO_SUPPORT,					"D3DERR_TEXTURE_NO_SUPPORT",
	D3DERR_TEXTURE_NOT_LOCKED,					"D3DERR_TEXTURE_NOT_LOCKED",
	D3DERR_TEXTURE_LOCKED,						"D3DERR_TEXTURELOCKED",
	D3DERR_TEXTURE_CREATE_FAILED,				"D3DERR_TEXTURE_CREATE_FAILED",
	D3DERR_TEXTURE_DESTROY_FAILED,				"D3DERR_TEXTURE_DESTROY_FAILED",
	D3DERR_TEXTURE_LOCK_FAILED,					"D3DERR_TEXTURE_LOCK_FAILED",
	D3DERR_TEXTURE_UNLOCK_FAILED,				"D3DERR_TEXTURE_UNLOCK_FAILED",
	D3DERR_TEXTURE_LOAD_FAILED,					"D3DERR_TEXTURE_LOAD_FAILED",
	D3DERR_MATRIX_CREATE_FAILED,				"D3DERR_MATRIX_CREATE_FAILED",
	D3DERR_MATRIX_DESTROY_FAILED,				"D3DERR_MATRIX_DESTROY_FAILED",
	D3DERR_MATRIX_SETDATA_FAILED,				"D3DERR_MATRIX_SETDATA_FAILED",
	D3DERR_SETVIEWPORTDATA_FAILED,				"D3DERR_SETVIEWPORTDATA_FAILED",
	D3DERR_MATERIAL_CREATE_FAILED,				"D3DERR_MATERIAL_CREATE_FAILED",
	D3DERR_MATERIAL_DESTROY_FAILED,				"D3DERR_MATERIAL_DESTROY_FAILED",
	D3DERR_MATERIAL_SETDATA_FAILED,				"D3DERR_MATERIAL_SETDATA_FAILED",
	D3DERR_LIGHT_SET_FAILED,					"D3DERR_LIGHT_SET_FAILED",
	// Reality Lab error values
	D3DRMERR_BADOBJECT,							"Bad object",
	D3DRMERR_BADTYPE,								"Bad type",
	D3DRMERR_BADALLOC,								"Bad alloc",
	D3DRMERR_FACEUSED,								"Face used",
	D3DRMERR_NOTFOUND,								"Not found",
	D3DRMERR_NOTDONEYET,							"Not done yet",
	D3DRMERR_FILENOTFOUND,							"File not found",
	D3DRMERR_BADFILE,								"Bad file",
	D3DRMERR_BADDEVICE,							"Bad device",
	D3DRMERR_BADVALUE,								"Bad value",
	D3DRMERR_BADMAJORVERSION,						"Bad major version",
	D3DRMERR_BADMINORVERSION,						"Bad minor version",
	D3DRMERR_UNABLETOEXECUTE,						"Unable to execute",

	0, NULL
};

// global helper function
CString Get3dError(HRESULT hr)
{
	CString str;

	// Search the msg table
	_3DERRMSG* pErr = _3dErrMsg;
	while (pErr->pszMsg) {
		if (pErr->hr == hr) {
			str = pErr->pszMsg;
			return str;
		}
		pErr++;
	}

	// Try for a system error message (common HRESULT)
	char* pBuf = str.GetBufferSetLength(256);
	DWORD dw = ::FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM,
							   NULL,
							   hr,
							   0,
							   pBuf,
							   256,
							   NULL);

	if (dw == 0) {
		sprintf(pBuf, "Unknown error: %8.8lXH", hr);
	}

	str.ReleaseBuffer();

	return str;
}

