// 3dLight.cpp
//
// Copyright (c) Nigel Thompson 1996
//
// Implementation for:
// C3dLight, C3dAmbLight, C3dDirLight
//

#include "stdafx.h"
#include "3dplus.h"

//////////////////////////////////////////////////////////////////
// C3dLight

IMPLEMENT_DYNAMIC(C3dLight, C3dFrame)

C3dLight::C3dLight()
{
    m_pILight = NULL;
}

C3dLight::~C3dLight()
{
    if (m_pILight) m_pILight->Release();
}

BOOL C3dLight::Create(D3DRMLIGHTTYPE type, double r, double g, double b)
{
    // Create the frame that holds the light
    if (!C3dFrame::Create(NULL)) return FALSE;

    // Create the light object
    ASSERT(m_pILight == NULL);
    if (!the3dEngine.CreateLight(type, r, g, b, &m_pILight)) {
        return FALSE;
    }
    ASSERT(m_pILight);

    // add the light to its frame
    ASSERT(m_pIFrame);
    m_hr = m_pIFrame->AddLight(m_pILight);
    if (FAILED(m_hr)) return FALSE;

    return TRUE;
}


BOOL C3dLight::SetColor(double r, double g, double b)
{
    ASSERT(m_pILight);
    m_hr = m_pILight->SetColorRGB(D3DVAL(r),
                               D3DVAL(g),
                               D3DVAL(b));
    return SUCCEEDED(m_hr);
}

void C3dLight::GetColor(double& r, double& g, double& b)
{
    ASSERT(m_pILight);
	D3DCOLOR clr = m_pILight->GetColor();
	r = D3DRMColorGetRed(clr);
	g = D3DRMColorGetGreen(clr);
	b = D3DRMColorGetBlue(clr);
}

void C3dLight::GetAttenuation(double& c, double& l, double& q)
{
    ASSERT(m_pILight);
	c = m_pILight->GetConstantAttenuation();
	l = m_pILight->GetLinearAttenuation();
	q = m_pILight->GetQuadraticAttenuation();
}

double C3dLight::GetRange()
{
    ASSERT(m_pILight);
	return m_pILight->GetRange();
}
 
void C3dLight::SetAttenuation(double c, double l, double q)
{
    ASSERT(m_pILight);
	m_hr = m_pILight->SetConstantAttenuation(c);
	ASSERT(SUCCEEDED(m_hr));
	m_hr = m_pILight->SetLinearAttenuation(l);
	ASSERT(SUCCEEDED(m_hr));
	m_hr = m_pILight->SetQuadraticAttenuation(q);
	ASSERT(SUCCEEDED(m_hr));
}

void C3dLight::SetRange(double r)
{
    ASSERT(m_pILight);
	m_hr = m_pILight->SetRange(r);
	ASSERT(SUCCEEDED(m_hr));
}

//////////////////////////////////////////////////////////////////
// C3dAmbLight

IMPLEMENT_DYNAMIC(C3dAmbLight, C3dLight)

BOOL C3dAmbLight::Create(double r, double g, double b)
{
    return C3dLight::Create(D3DRMLIGHT_AMBIENT, r, g, b);
}

//////////////////////////////////////////////////////////////////
// C3dDirLight

IMPLEMENT_DYNAMIC(C3dDirLight, C3dLight)

BOOL C3dDirLight::Create(double r, double g, double b)
{
    return C3dLight::Create(D3DRMLIGHT_DIRECTIONAL, r, g, b);
}

//////////////////////////////////////////////////////////////////
// C3dParPtLight

IMPLEMENT_DYNAMIC(C3dParPtLight, C3dLight)

BOOL C3dParPtLight::Create(double r, double g, double b)
{
    return C3dLight::Create(D3DRMLIGHT_PARALLELPOINT, r, g, b);
}

//////////////////////////////////////////////////////////////////
// C3dPtLight

IMPLEMENT_DYNAMIC(C3dPtLight, C3dLight)

BOOL C3dPtLight::Create(double r, double g, double b)
{
    return C3dLight::Create(D3DRMLIGHT_POINT, r, g, b);
}

//////////////////////////////////////////////////////////////////
// C3dSpotLight

IMPLEMENT_DYNAMIC(C3dSpotLight, C3dLight)

BOOL C3dSpotLight::Create(double r, double g, double b)
{
    return C3dLight::Create(D3DRMLIGHT_SPOT, r, g, b);
}

