// 3dMat.cpp
//
// Copyright (c) Nigel Thompson 1996
//
// Implementation for:
// C3dMaterial
//

#include "stdafx.h"
#include "3dplus.h"

IMPLEMENT_DYNAMIC(C3dMaterial, C3dObject)

C3dMaterial::C3dMaterial()
{
	m_pIMat = NULL;
	the3dEngine.CreateMaterial(5, &m_pIMat);
	ASSERT(m_pIMat);
}

C3dMaterial::~C3dMaterial()
{
	ASSERT(m_pIMat);
	m_pIMat->Release();
}

void C3dMaterial::SetEmissiveColor(double r, double g, double b)
{
	ASSERT(m_pIMat);
	m_hr = m_pIMat->SetEmissive(D3DVAL(r), D3DVAL(g), D3DVAL(b));
	ASSERT(SUCCEEDED(m_hr));
}

void C3dMaterial::SetSpecularPower(double p)
{
	ASSERT(m_pIMat);
	m_hr = m_pIMat->SetPower(D3DVAL(p));
	ASSERT(SUCCEEDED(m_hr));
}

void C3dMaterial::SetSpecularColor(double r, double g, double b)
{
	ASSERT(m_pIMat);
	m_hr = m_pIMat->SetSpecular(D3DVAL(r), D3DVAL(g), D3DVAL(b));
	ASSERT(SUCCEEDED(m_hr));
}

