// 3dScene.cpp
//
// Copyright (c) Nigel Thompson 1996
//
// Implementation for:
// C3dEngine, C3dObject, C3dVisual, C3dScene
//

#include "stdafx.h"
#include "3dplus.h"

//////////////////////////////////////////////////////////////////
// C3dScene

IMPLEMENT_DYNAMIC(C3dScene, C3dFrame)


C3dScene::C3dScene()
: m_vCamPos(0, 0, -10), m_vCamDir(0, 0, 1), m_vCamUp(0, 1, 0),
m_dCamField(0.5)
{
	m_clrBkgnd = D3DRMCreateColorRGB(0, 0, 0);
	m_pBkgndImg = NULL;
	m_pStage = NULL;
}

C3dScene::~C3dScene()
{
	m_ShapeList.DeleteAll();
	m_ImgList.DeleteAll();
}

// Create the initial scene
BOOL C3dScene::Create()
{
    ASSERT(m_pIFrame == NULL); // only once

	// Create the scene. This is a frame with no parent
    if (!C3dFrame::Create(NULL)) {
        return FALSE;
    }
	ASSERT(m_pIFrame);

    // Set the initial ambient light level
    m_AmbLight.Create(0.5, 0.5, 0.5);

    // Add the light to the scene
    AddLight(&m_AmbLight);

    return TRUE;
}

BOOL C3dScene::AddLight(C3dLight* pLight)
{
    ASSERT(pLight);
    return AddChild(pLight);
}

void C3dScene::Move(double delta)
{
    if (m_pIFrame) {
        m_pIFrame->Move(D3DVAL(delta));
    }
}

void C3dScene::SetBackground(double r, double g, double b)
{
	m_clrBkgnd = D3DRMCreateColorRGB(r, g, b);
	if (m_pStage) {
		m_pStage->SetBackground(this);
	}
}

void C3dScene::SetBackground(C3dImage* pImage)
{
	m_pBkgndImg = pImage;
	if (m_pStage) {
		m_pStage->SetBackground(this);
	}
}	
	
void C3dScene::SetCameraPosition(D3DVECTOR& p)
{
	m_vCamPos = p;
	if (m_pStage) {
		m_pStage->GetCamera()->SetPosition(p, m_pStage);
	}
}

void C3dScene::SetCameraDirection(D3DVECTOR& d)
{
	C3dVector u = C3dVector(d).GenerateUp();
	SetCameraDirection(d, u);
}

void C3dScene::SetCameraDirection(D3DVECTOR& d, D3DVECTOR& u)
{
	m_vCamDir = d;
	m_vCamUp = u;
	if (m_pStage) {
		m_pStage->GetCamera()->SetDirection(d, u, m_pStage);
	}
}

void C3dScene::SetCameraField(double f)
{
	m_dCamField = f;
	if (m_pStage) {
		m_pStage->GetViewport()->SetFieldOfView(f);
	}
}
	
	

