// 3dSprite.cpp
//
// Copyright (c) Nigel Thompson 1996
//
// Implementation for:
// C3dSprite
//

#include "stdafx.h"
#include "3dplus.h"

////////////////////////////////////////////////////////////////////////////
// C3dSprite

IMPLEMENT_DYNAMIC(C3dSprite, C3dFrame)


C3dSprite::C3dSprite()
{
}

// virtual 
C3dSprite::~C3dSprite()
{
}

BOOL C3dSprite::Create(C3dScene* pScene,
						double x, double y, double z,
						double scale,
						UINT uiIDBitmap,
						int iPhases)
{
	ASSERT(pScene);
	ASSERT(iPhases > 0);
	ASSERT(uiIDBitmap);

	// Create the frame	and add it to the scene list
	C3dFrame::Create(pScene);
	pScene->m_ShapeList.Append(this);

	// Put it in the requested position
	SetPosition(x, y, z);

	// Load the texture map	image
	if (!m_Tex.C3dImage::Load(uiIDBitmap)) {
		TRACE("Failed to load texture image\n");
		return FALSE;
	}

	// Set the number of phases
	m_Tex.C3dImage::SetNumPhases(iPhases);

	// Create the texture map from the image
	m_Tex.Create();

	// Set the properties
	IDirect3DRMTexture* pITex = m_Tex.GetInterface();
	ASSERT(pITex);
	
	// Enable depth scaling
	m_hr = pITex->SetDecalScale(TRUE);
	ASSERT(SUCCEEDED(m_hr));

	// Set the initial size
	double a = (double)m_Tex.GetWidth()
			 / (double)m_Tex.GetHeight();
	m_hr = pITex->SetDecalSize(scale * a, scale);
	ASSERT(SUCCEEDED(m_hr));

	// Turn on transparency
	m_hr = pITex->SetDecalTransparency(TRUE);
	ASSERT(SUCCEEDED(m_hr));

	// Set the transparency color to black
	m_hr = pITex->SetDecalTransparentColor(RGB_MAKE(0, 0, 0));
 	ASSERT(SUCCEEDED(m_hr));

	// Set the center of the bottom of the image to map
	// to the frame origin
	m_hr = pITex->SetDecalOrigin(m_Tex.GetWidth()/2,
								 m_Tex.GetHeight()-1);
	ASSERT(SUCCEEDED(m_hr));

	// Add the texture as a visual
	return AddVisual(&m_Tex);
}

BOOL C3dSprite::SetPhase(int iPhase)
{
	return m_Tex.SetPhase(iPhase);
}

