// 3dplus.cpp
//
// Copyright (c) Nigel Thompson 1996
//
// Implementation for:
// C3dEngine, C3dObject, C3dVisual, C3dScene
//

#define INITGUID   // force one-time construction of GUID values
#include "stdafx.h"
#include <ddraw.h>
#include <d3d.h>
#include "3dplus.h"

//////////////////////////////////////////////////////////////////
// C3dObject

IMPLEMENT_DYNAMIC(C3dObject, CObject)

C3dObject::C3dObject()
{
	m_hr = 0;
}

C3dObject::~C3dObject()
{
}

//////////////////////////////////////////////////////////////////
// C3dEngine

// global one-time initialization mechanism
IDirect3DRM* C3dEngine::s_pRL = NULL;
BOOL C3dEngine::s_bInitialized = Initialize();

IMPLEMENT_DYNAMIC(C3dEngine, C3dObject)

C3dEngine::C3dEngine()
{
	m_pIRM = NULL;
    ASSERT(s_pRL);

	// Get a pointer to the WinRealityLab interface
    // if this fails then you probably don't have the
    // #define INITGUID line at the top of this file :)
	m_hr = s_pRL->QueryInterface(IID_IDirect3DRM, (void**)&m_pIRM);
	ASSERT(SUCCEEDED(m_hr));
	ASSERT(m_pIRM);
}

C3dEngine::~C3dEngine()
{
    // release any interfaces we have
	if (m_pIRM) m_pIRM->Release();
}

// static
// This function is called once when the classes are first loaded
BOOL C3dEngine::Initialize()
{
    // make sure the object hasn't already been created
    if(s_bInitialized) return FALSE;

    // attempt to create the main object and get
	// a pointer to its interface
    HRESULT hr = Direct3DRMCreate(&s_pRL);
    if (FAILED(hr)) {
        TRACE("Failed to create RL object");
        s_pRL = NULL;
        return FALSE;
    }
    ASSERT(s_pRL);

    return TRUE;
}

BOOL C3dEngine::CreateFrame(IDirect3DRMFrame* pIParentFrame, IDirect3DRMFrame** pIFrame)
{
    ASSERT(m_pIRM);
    ASSERT(pIFrame);
    
    m_hr = m_pIRM->CreateFrame(pIParentFrame, pIFrame);
    if (FAILED(m_hr)) {
        *pIFrame = NULL;
        return FALSE;
    }
    ASSERT(*pIFrame);
    return TRUE;

}

BOOL C3dEngine::CreateViewport(C3dDevice* pDevice,
						       C3dCamera* pCamera,
						       int x, int y,
						       int cx, int cy,
						       IDirect3DRMViewport** pIViewport)
{
    ASSERT(pDevice);
    ASSERT(pCamera);
    ASSERT(pIViewport);
    ASSERT(m_pIRM);

    m_hr = m_pIRM->CreateViewport(pDevice->GetInterface(),
                                pCamera->GetInterface(),
                                x, y,
                                cx, cy,
                                pIViewport);
    if (FAILED(m_hr)) return FALSE;
    ASSERT(*pIViewport);

    return TRUE;
}

BOOL C3dEngine::CreateLight(D3DRMLIGHTTYPE type,
                            double r, double g, double b,
                            IDirect3DRMLight** pILight)
{
    ASSERT(m_pIRM);
    ASSERT(pILight);

    m_hr = m_pIRM->CreateLightRGB(type,
                                D3DVAL(r),
                                D3DVAL(g),
                                D3DVAL(b),
                                pILight);
    if (FAILED(m_hr)) return FALSE;
    ASSERT(*pILight);

    return TRUE;
}

BOOL C3dEngine::CreateMeshBuilder(IDirect3DRMMeshBuilder** pIBld)
{
    ASSERT(m_pIRM);
    ASSERT(pIBld);

    m_hr = m_pIRM->CreateMeshBuilder(pIBld);
    if (FAILED(m_hr)) return FALSE;
    ASSERT(*pIBld);

    return TRUE;
}

BOOL C3dEngine::CreateTexture(D3DRMIMAGE* pIImage, IDirect3DRMTexture** pITexture)
{
    ASSERT(pIImage);
    ASSERT(pITexture);

    m_hr = m_pIRM->CreateTexture(pIImage, pITexture);
    if (FAILED(m_hr)) return FALSE;
    ASSERT(*pITexture);

    return TRUE;
}

BOOL C3dEngine::CreateWrap(D3DRMWRAPTYPE type,
                            IDirect3DRMFrame* pIRefFrame,
                            double ox, double oy, double oz,
                            double dx, double dy, double dz,
                            double ux, double uy, double uz,
                            double ou, double ov,
                            double su, double sv,
                            IDirect3DRMWrap** pIWrap)
{
    ASSERT(pIWrap);

    m_hr = m_pIRM->CreateWrap(type,
                            pIRefFrame,
                            D3DVAL(ox), D3DVAL(oy), D3DVAL(oz),
                            D3DVAL(dx), D3DVAL(dy), D3DVAL(dz),
                            D3DVAL(ux), D3DVAL(uy), D3DVAL(uz),
                            D3DVAL(ou), D3DVAL(ov),
                            D3DVAL(su), D3DVAL(sv),
                            pIWrap);
    if (FAILED(m_hr)) return FALSE;
    ASSERT(*pIWrap);

    return TRUE;
}

BOOL C3dEngine::CreateMaterial(double sharp, IDirect3DRMMaterial** pIMat)
{
	m_hr = s_pRL->CreateMaterial(D3DVAL(sharp), pIMat);
	return SUCCEEDED(m_hr);
}


// the one and only 3dEngine
C3dEngine the3dEngine;

//////////////////////////////////////////////////////////////////
// C3dVisual

IMPLEMENT_DYNAMIC(C3dVisual, C3dObject)

C3dVisual::C3dVisual()
{
	m_strName = "3D Visual";
}

