// AirPage.cpp : implementation file
//

#include "stdafx.h"
#include "3dPlus.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAirPage property page

IMPLEMENT_DYNCREATE(CAirPage, CShapePage)

CAirPage::CAirPage() : CShapePage(CAirPage::IDD)
{
	//{{AFX_DATA_INIT(CAirPage)
	m_dX = 0.0;
	m_dY = 0.0;
	m_dZ = 0.0;
	//}}AFX_DATA_INIT
}

CAirPage::~CAirPage()
{
}

void CAirPage::DoDataExchange(CDataExchange* pDX)
{
	CShapePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAirPage)
	DDX_Text(pDX, _3D_IDC_X, m_dX);
	DDX_Text(pDX, _3D_IDC_Y, m_dY);
	DDX_Text(pDX, _3D_IDC_Z, m_dZ);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAirPage, CShapePage)
	//{{AFX_MSG_MAP(CAirPage)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAirPage message handlers

// virtual 
C3dShape* CAirPage::CreateShape()
{
	UpdateData(TRUE);
	C3dShape* pShape = new C3dShape();

    D3DVECTOR vlistP[] = {
        {-0.5,  0.0, -0.3},
        { 0.0,  0.1, -0.3},
        { 0.5,  0.0, -0.3},
        { 0.0,  0.0,  0.7},
        {-0.1,  0.0, -0.3},
        { 0.1,  0.0, -0.3},
        { 0.0,  0.3, -0.3},
        { 0.0,  0.0,  0.1}
    };
    int iPVectors = sizeof(vlistP) / sizeof(D3DVECTOR);
    int iPFaces[] = {3, 0, 3, 1, // 0 left wing top
                     3, 1, 3, 2, // 1 right wing top
                     3, 2, 3, 0, // 2 wing underside
                     3, 0, 1, 2, // 3 wing aft face
                     3, 4, 6, 5, // 4 tail aft face
                     3, 5, 6, 7, // 5 tail right side
                     3, 7, 6, 4, // 6 tail left side
                     0};

    pShape->Create(vlistP, iPVectors, iPFaces);

	pShape->SetPosition(m_dX, m_dY, m_dZ);
	pShape->SetName("Airplane");
	return pShape;
}

