// JoyValCt.cpp : implementation file
//
// This is a custom control for displaying the value of a
// joystick axis

#include "stdafx.h"
#include "3dplus.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// static class initialization
BOOL CJoyValCtl::m_bRegistered = Register();

// static
BOOL CJoyValCtl::Register()
{
    // Register the window class of the control
    WNDCLASS wc;
    wc.style = CS_GLOBALCLASS
             | CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = JoyValWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = NULL;
    wc.hIcon = NULL;
    wc.hCursor = ::LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName = NULL;
    wc.lpszClassName = "JoyVal";

    if (!::RegisterClass(&wc)) {
        ASSERT(0);
        return FALSE;
    } 
    return TRUE;
}

// static
LRESULT CJoyValCtl::JoyValWndProc(HWND hWnd, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
    switch (uiMsg) {
    case WM_NCCREATE: {

        // Create a C++ object to handle the messages
        CJoyValCtl* pCtl = new CJoyValCtl;
        ASSERT(pCtl);

        // Attach the window handle to the new object
        BOOL b = pCtl->SubclassWindow(hWnd);
        ASSERT(b);
        return b;
        } break;

    default:
        return ::DefWindowProc(hWnd, uiMsg, wParam, lParam);
    }
}


/////////////////////////////////////////////////////////////////////////////
// CJoyValCtl

CJoyValCtl::CJoyValCtl()
{
	m_iMin = 0;
	m_iMax = 65535;
	m_iDeadMin = 0;
	m_iDeadMax = 0;
	m_iVal = 0;
}

CJoyValCtl::~CJoyValCtl()
{
}


BEGIN_MESSAGE_MAP(CJoyValCtl, CWnd)
	//{{AFX_MSG_MAP(CJoyValCtl)
	ON_WM_NCDESTROY()
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CJoyValCtl message handlers

void CJoyValCtl::OnNcDestroy() 
{
    CWnd::OnNcDestroy();

    // Make sure the window was destroyed
    ASSERT(m_hWnd == NULL);

    // Destroy this object since it won't be destroyed otherwise
    delete this;
}

void CJoyValCtl::OnSize(UINT nType, int cx, int cy) 
{
	GetClientRect(&m_rcWnd);	
}

BOOL CJoyValCtl::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE; // Say we handled it
}

void CJoyValCtl::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	// Paint the background
	CBrush brbk(RGB(128, 128, 128));
	dc.FillRect(&m_rcWnd, &brbk);

	int r = m_iMax - m_iMin;
	int wd = m_iDeadMax - m_iDeadMin;
	if (wd > 0) {

		// draw the dead zone area
		int x1 = m_rcWnd.left + (m_iDeadMin - m_iMin) * m_rcWnd.Width() / r;
		int x2 = m_rcWnd.left + (m_iDeadMax - m_iMin) * m_rcWnd.Width() / r;
		CRect rcd(x1, m_rcWnd.top, x2, m_rcWnd.bottom);
		CBrush brd(RGB(64, 64, 64));
		dc.FillRect(&rcd, &brd);
	}

	// draw the current value as a red line
	CPen penLine;
	penLine.CreatePen(PS_SOLID, 1, RGB(255, 0, 0));

	// compute the value
	int xpos = m_rcWnd.left + (m_iVal - m_iMin) * m_rcWnd.Width() / r;

	// draw the value line
	CPen* pOldPen = dc.SelectObject(&penLine);
	dc.MoveTo(xpos, m_rcWnd.top);
	dc.LineTo(xpos, m_rcWnd.bottom);
	dc.SelectObject(pOldPen);
}

void CJoyValCtl::SetRange(int iMin, int iMax)
{
	ASSERT((iMin >= 0) && (iMax <= 65535) && (iMax > iMin));
	m_iMin = iMin;
	m_iMax = iMax;
	SetDeadBand(m_iDeadMin, m_iDeadMax);
	SetValue(m_iVal);
}

void CJoyValCtl::SetDeadBand(int iMin, int iMax)
{
	if ((iMin < m_iMin) 
	|| (iMin >= m_iMax)
	|| (iMax <= m_iMin)
	|| (iMax > m_iMax)
	|| (iMax > iMax)) {
		m_iDeadMin = 0;
		m_iDeadMax = 0;
	} else {
		m_iDeadMin = iMin;
		m_iDeadMax = iMax;
	}
	Invalidate(NULL);
}

void CJoyValCtl::SetValue(int iVal)
{
	if (iVal < m_iMin) {
		m_iVal = m_iMin;
	} else if (iVal > m_iMax) {
		m_iVal = m_iMax;
	} else {
		m_iVal = iVal;
	}
	Invalidate(NULL);
}

