// ObjPage.cpp : implementation file
//

#include "stdafx.h"
#include "3dPlus.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CObjectPage property page

IMPLEMENT_DYNCREATE(CObjectPage, CShapePage)

CObjectPage::CObjectPage() : CShapePage(CObjectPage::IDD)
{
	//{{AFX_DATA_INIT(CObjectPage)
	m_strFilename = _T("");
	m_dX = 0.0;
	m_dY = 0.0;
	m_dZ = 0.0;
	m_dXD = 0.0;
	m_dYD = 0.0;
	m_dZD = 1.0;
	m_dXU = 0.0;
	m_dYU = 1.0;
	m_dZU = 0.0;
	//}}AFX_DATA_INIT
}

CObjectPage::~CObjectPage()
{
}

void CObjectPage::DoDataExchange(CDataExchange* pDX)
{
	CShapePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CObjectPage)
	DDX_Text(pDX, _3D_IDC_FILENAME, m_strFilename);
	DDX_Text(pDX, _3D_IDC_X, m_dX);
	DDX_Text(pDX, _3D_IDC_XD, m_dXD);
	DDX_Text(pDX, _3D_IDC_XU, m_dXU);
	DDX_Text(pDX, _3D_IDC_Y, m_dY);
	DDX_Text(pDX, _3D_IDC_YD, m_dYD);
	DDX_Text(pDX, _3D_IDC_YU, m_dYU);
	DDX_Text(pDX, _3D_IDC_Z, m_dZ);
	DDX_Text(pDX, _3D_IDC_ZD, m_dZD);
	DDX_Text(pDX, _3D_IDC_ZU, m_dZU);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CObjectPage, CShapePage)
	//{{AFX_MSG_MAP(CObjectPage)
	ON_BN_CLICKED(_3D_IDC_BROWSE, OnBrowse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CObjectPage message handlers

BOOL CObjectPage::OnSetActive() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CShapePage::OnSetActive();
}

void CObjectPage::OnBrowse() 
{
	// Show a file open dialog
	CFileDialog dlg(TRUE,
			        NULL,
					NULL,
					OFN_HIDEREADONLY,
					_3DOBJ_LOADFILTER,
					NULL);
	if (dlg.DoModal() != IDOK) return;

	// get the file path
	m_strFilename = dlg.m_ofn.lpstrFile;
	UpdateData(FALSE);
}

// virtual 
C3dShape* CObjectPage::CreateShape()
{
	UpdateData(TRUE);
	C3dShape* pShape = new C3dShape();
	if (!pShape->Load(m_strFilename)) {
		delete pShape;
		return NULL;
	}
	pShape->SetPosition(m_dX, m_dY, m_dZ);
	pShape->SetDirection(m_dXD, m_dYD, m_dZD, m_dXU, m_dYU, m_dZU);
	return pShape;
}

