// RotPage.cpp : implementation file
//

#include "stdafx.h"
#include "3dPlus.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRotatePage property page

IMPLEMENT_DYNCREATE(CRotatePage, CTransformPage)

CRotatePage::CRotatePage() : CTransformPage(CRotatePage::IDD)
{
	//{{AFX_DATA_INIT(CRotatePage)
	m_dX = 0.0;
	m_dY = 0.0;
	m_dZ = 0.0;
	//}}AFX_DATA_INIT
}

CRotatePage::~CRotatePage()
{
}

void CRotatePage::DoDataExchange(CDataExchange* pDX)
{
	CTransformPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRotatePage)
	DDX_Text(pDX, _3D_IDC_X, m_dX);
	DDX_Text(pDX, _3D_IDC_Y, m_dY);
	DDX_Text(pDX, _3D_IDC_Z, m_dZ);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRotatePage, CTransformPage)
	//{{AFX_MSG_MAP(CRotatePage)
	ON_BN_CLICKED(_3D_IDC_BEFORE, OnBefore)
	ON_BN_CLICKED(_3D_IDC_AFTER, OnAfter)
	ON_BN_CLICKED(_3D_IDC_REPLACE, OnReplace)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRotatePage message handlers

void CRotatePage::OnBefore() 
{
	UpdateData(TRUE);
	C3dMatrix m;
	m.Rotate(m_dX, m_dY, m_dZ);
	AddTransform(m, D3DRMCOMBINE_BEFORE);
}

void CRotatePage::OnAfter() 
{
	UpdateData(TRUE);
	C3dMatrix m;
	m.Rotate(m_dX, m_dY, m_dZ);
	AddTransform(m, D3DRMCOMBINE_AFTER);
}

void CRotatePage::OnReplace() 
{
	UpdateData(TRUE);
	C3dMatrix m;
	m.Rotate(m_dX, m_dY, m_dZ);
	AddTransform(m, D3DRMCOMBINE_REPLACE);
}
