// ScalPage.cpp : implementation file
//

#include "stdafx.h"
#include "3dPlus.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScalePage property page

IMPLEMENT_DYNCREATE(CScalePage, CTransformPage)

CScalePage::CScalePage() : CTransformPage(CScalePage::IDD)
{
	//{{AFX_DATA_INIT(CScalePage)
	m_dX = 1.0;
	m_dY = 1.0;
	m_dZ = 1.0;
	//}}AFX_DATA_INIT
}

CScalePage::~CScalePage()
{
}

void CScalePage::DoDataExchange(CDataExchange* pDX)
{
	CTransformPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CScalePage)
	DDX_Text(pDX, _3D_IDC_X, m_dX);
	DDX_Text(pDX, _3D_IDC_Y, m_dY);
	DDX_Text(pDX, _3D_IDC_Z, m_dZ);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CScalePage, CTransformPage)
	//{{AFX_MSG_MAP(CScalePage)
	ON_BN_CLICKED(_3D_IDC_BEFORE, OnBefore)
	ON_BN_CLICKED(_3D_IDC_AFTER, OnAfter)
	ON_BN_CLICKED(_3D_IDC_REPLACE, OnReplace)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScalePage message handlers

void CScalePage::OnBefore() 
{
	UpdateData(TRUE);
	C3dMatrix m;
	m.Scale(m_dX, m_dY, m_dZ);
	AddTransform(m, D3DRMCOMBINE_BEFORE);
}

void CScalePage::OnAfter() 
{
	UpdateData(TRUE);
	C3dMatrix m;
	m.Scale(m_dX, m_dY, m_dZ);
	AddTransform(m, D3DRMCOMBINE_AFTER);
}

void CScalePage::OnReplace() 
{
	UpdateData(TRUE);
	C3dMatrix m;
	m.Scale(m_dX, m_dY, m_dZ);
	AddTransform(m, D3DRMCOMBINE_REPLACE);
}
