// ShapeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "3dPlus.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CShapeDlg

IMPLEMENT_DYNAMIC(CShapeDlg, CPropertySheet)

CShapeDlg::CShapeDlg(LPCTSTR pszCaption, CWnd* pParentWnd)
	:CPropertySheet(pszCaption, pParentWnd, 0)
{
	m_pShape = NULL;

	// Add the pages
	AddPage(&m_SpherePage);
	AddPage(&m_CubePage);
	AddPage(&m_ConePage);
	AddPage(&m_AirPage);
	AddPage(&m_ObjectPage);
}

CShapeDlg::~CShapeDlg()
{
}


BEGIN_MESSAGE_MAP(CShapeDlg, CPropertySheet)
	//{{AFX_MSG_MAP(CShapeDlg)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShapeDlg message handlers

// Handle the OK button
void CShapeDlg::OnOK()
{
	// get the active page

	CShapePage* pPage = (CShapePage*) GetActivePage();
	if (pPage) {

		ASSERT(pPage->IsKindOf(RUNTIME_CLASS(CShapePage)));
		m_pShape = pPage->CreateShape();
		if (m_pShape) {
			EndDialog(TRUE);
		} else {
			AfxMessageBox("Failed to create shape");
		}
	}
}

BOOL CShapeDlg::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	if (LOWORD(wParam) == IDOK) {
		OnOK();
		return TRUE;
	}
	
	return CPropertySheet::OnCommand(wParam, lParam);
}
