// SphPage.cpp : implementation file
//

#include "stdafx.h"
#include "3dPlus.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSpherePage property page

IMPLEMENT_DYNCREATE(CSpherePage, CShapePage)

CSpherePage::CSpherePage() : CShapePage(CSpherePage::IDD)
{
	//{{AFX_DATA_INIT(CSpherePage)
	m_dX = 0.0;
	m_dY = 0.0;
	m_dZ = 0.0;
	m_dRad = 1.0;
	//}}AFX_DATA_INIT
	m_iDetail = 1;
}

CSpherePage::~CSpherePage()
{
}

void CSpherePage::DoDataExchange(CDataExchange* pDX)
{
	CShapePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSpherePage)
	DDX_Text(pDX, _3D_IDC_X, m_dX);
	DDX_Text(pDX, _3D_IDC_Y, m_dY);
	DDX_Text(pDX, _3D_IDC_Z, m_dZ);
	DDX_Text(pDX, _3D_IDC_RADIUS, m_dRad);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSpherePage, CShapePage)
	//{{AFX_MSG_MAP(CSpherePage)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSpherePage message handlers

// virtual 
C3dShape* CSpherePage::CreateShape()
{
	UpdateData(TRUE);
	int iBands;
	if (IsDlgButtonChecked(_3D_IDC_RADIO1)) {
		m_iDetail = 0;
		iBands = 4;
	} else if (IsDlgButtonChecked(_3D_IDC_RADIO2)) {
		m_iDetail = 1;
		iBands = 16;
	} else {
		m_iDetail = 2;
		iBands = 64;
	}
	C3dShape* pShape = new C3dShape();
	pShape->CreateSphere(m_dRad, iBands);
	pShape->SetPosition(m_dX, m_dY, m_dZ);
	return pShape;
}


BOOL CSpherePage::OnSetActive() 
{
	switch(m_iDetail) {
	case 0:
		CheckRadioButton(_3D_IDC_RADIO1, _3D_IDC_RADIO3, _3D_IDC_RADIO1);
		break;

	case 1:
		CheckRadioButton(_3D_IDC_RADIO1, _3D_IDC_RADIO3, _3D_IDC_RADIO2);
		break;

	default:
		CheckRadioButton(_3D_IDC_RADIO1, _3D_IDC_RADIO3, _3D_IDC_RADIO3);
		break;
	}

	return CShapePage::OnSetActive();
}
