// TranPage.cpp : implementation file
//

#include "stdafx.h"
#include "3dPlus.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTranslatePage property page

IMPLEMENT_DYNCREATE(CTranslatePage, CTransformPage)

CTranslatePage::CTranslatePage() : CTransformPage(CTranslatePage::IDD)
{
	//{{AFX_DATA_INIT(CTranslatePage)
	m_dX = 0.0;
	m_dY = 0.0;
	m_dZ = 0.0;
	//}}AFX_DATA_INIT
}

CTranslatePage::~CTranslatePage()
{
}

void CTranslatePage::DoDataExchange(CDataExchange* pDX)
{
	CTransformPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTranslatePage)
	DDX_Text(pDX, _3D_IDC_X, m_dX);
	DDX_Text(pDX, _3D_IDC_Y, m_dY);
	DDX_Text(pDX, _3D_IDC_Z, m_dZ);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTranslatePage, CTransformPage)
	//{{AFX_MSG_MAP(CTranslatePage)
	ON_BN_CLICKED(_3D_IDC_BEFORE, OnBefore)
	ON_BN_CLICKED(_3D_IDC_AFTER, OnAfter)
	ON_BN_CLICKED(_3D_IDC_REPLACE, OnReplace)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTranslatePage message handlers

void CTranslatePage::OnBefore() 
{
	UpdateData(TRUE);
	C3dMatrix m;
	m.Translate(m_dX, m_dY, m_dZ);
	AddTransform(m, D3DRMCOMBINE_BEFORE);
}

void CTranslatePage::OnAfter() 
{
	UpdateData(TRUE);
	C3dMatrix m;
	m.Translate(m_dX, m_dY, m_dZ);
	AddTransform(m, D3DRMCOMBINE_AFTER);
}

void CTranslatePage::OnReplace() 
{
	UpdateData(TRUE);
	C3dMatrix m;
	m.Translate(m_dX, m_dY, m_dZ);
	AddTransform(m, D3DRMCOMBINE_REPLACE);
}
