// axespage.cpp : implementation file
//

#include "stdafx.h"
#include "3dPlus.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// an instance of the control is included here to force the linker
// to include the JoyValCtl module in any application which uses this
// library which it won't other wise do	because there are no direct 
// references to it
static CJoyValCtl jvc;

/////////////////////////////////////////////////////////////////////////////
// CAxesPage property page

IMPLEMENT_DYNCREATE(CAxesPage, CPropertyPage)

CAxesPage::CAxesPage() : CPropertyPage(CAxesPage::IDD)
{
	//{{AFX_DATA_INIT(CAxesPage)
	m_iRdead = 0;
	m_iUdead = 0;
	m_iVdead = 0;
	m_iXdead = 0;
	m_iYdead = 0;
	m_iZdead = 0;
	m_dRscale = 0.0;
	m_dUscale = 0.0;
	m_dVscale = 0.0;
	m_dXscale = 0.0;
	m_dYscale = 0.0;
	m_dZscale = 0.0;
	//}}AFX_DATA_INIT
	m_pDev = NULL;
	m_uiTimer = 0;
}

CAxesPage::~CAxesPage()
{
	if (m_uiTimer) {
		KillTimer(1);
		m_uiTimer = 0;
	}
}

void CAxesPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAxesPage)
	DDX_Control(pDX, _3D_IDC_ZIN, m_cbZin);
	DDX_Control(pDX, _3D_IDC_YIN, m_cbYin);
	DDX_Control(pDX, _3D_IDC_XIN, m_cbXin);
	DDX_Control(pDX, _3D_IDC_VIN, m_cbVin);
	DDX_Control(pDX, _3D_IDC_UIN, m_cbUin);
	DDX_Control(pDX, _3D_IDC_RIN, m_cbRin);
	DDX_Control(pDX, _3D_IDC_ZBTN, m_cbZbtn);
	DDX_Control(pDX, _3D_IDC_YBTN, m_cbYbtn);
	DDX_Control(pDX, _3D_IDC_XBTN, m_cbXbtn);
	DDX_Control(pDX, _3D_IDC_VBTN, m_cbVbtn);
	DDX_Control(pDX, _3D_IDC_UBTN, m_cbUbtn);
	DDX_Control(pDX, _3D_IDC_RBTN, m_cbRbtn);
	DDX_Text(pDX, _3D_IDC_RDEAD, m_iRdead);
	DDX_Text(pDX, _3D_IDC_UDEAD, m_iUdead);
	DDX_Text(pDX, _3D_IDC_VDEAD, m_iVdead);
	DDX_Text(pDX, _3D_IDC_XDEAD, m_iXdead);
	DDX_Text(pDX, _3D_IDC_YDEAD, m_iYdead);
	DDX_Text(pDX, _3D_IDC_ZDEAD, m_iZdead);
	DDX_Text(pDX, _3D_IDC_RSCALE, m_dRscale);
	DDX_Text(pDX, _3D_IDC_USCALE, m_dUscale);
	DDX_Text(pDX, _3D_IDC_VSCALE, m_dVscale);
	DDX_Text(pDX, _3D_IDC_XSCALE, m_dXscale);
	DDX_Text(pDX, _3D_IDC_YSCALE, m_dYscale);
	DDX_Text(pDX, _3D_IDC_ZSCALE, m_dZscale);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAxesPage, CPropertyPage)
	//{{AFX_MSG_MAP(CAxesPage)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAxesPage message handlers

void CAxesPage::SetInList(CComboBox* pcb)
{
	pcb->ResetContent();
	pcb->AddString("X");
	pcb->AddString("Y");
	pcb->AddString("Z");
	pcb->AddString("R");
	pcb->AddString("U");
	pcb->AddString("V");
}

void CAxesPage::SetBtnList(CComboBox* pcb)
{
	pcb->ResetContent();
	pcb->AddString("-");
	pcb->AddString("1");
	pcb->AddString("2");
	pcb->AddString("3");
	pcb->AddString("4");
}

BOOL CAxesPage::OnSetActive() 
{
	ASSERT(m_pDev);

	// initialize the row array
	m_row[0].pcbIn = &m_cbXin;
	m_row[0].pjvIn = (CJoyValCtl*) GetDlgItem(_3D_IDC_XINVAL);
	m_row[0].pcbBtn = &m_cbXbtn;
	m_row[0].piDead = &m_iXdead;
	m_row[0].pdScale = &m_dXscale;
	m_row[0].pjvOut = (CJoyValCtl*) GetDlgItem(_3D_IDC_XOUTVAL);
	
	m_row[1].pcbIn = &m_cbYin;
	m_row[1].pjvIn = (CJoyValCtl*) GetDlgItem(_3D_IDC_YINVAL);
	m_row[1].pcbBtn = &m_cbYbtn;
	m_row[1].piDead = &m_iYdead;
	m_row[1].pdScale = &m_dYscale;
	m_row[1].pjvOut = (CJoyValCtl*) GetDlgItem(_3D_IDC_YOUTVAL);
	
	m_row[2].pcbIn = &m_cbZin;
	m_row[2].pjvIn = (CJoyValCtl*) GetDlgItem(_3D_IDC_ZINVAL);
	m_row[2].pcbBtn = &m_cbZbtn;
	m_row[2].piDead = &m_iZdead;
	m_row[2].pdScale = &m_dZscale;
	m_row[2].pjvOut = (CJoyValCtl*) GetDlgItem(_3D_IDC_ZOUTVAL);
	
	m_row[3].pcbIn = &m_cbRin;
	m_row[3].pjvIn = (CJoyValCtl*) GetDlgItem(_3D_IDC_RINVAL);
	m_row[3].pcbBtn = &m_cbRbtn;
	m_row[3].piDead = &m_iRdead;
	m_row[3].pdScale = &m_dRscale;
	m_row[3].pjvOut = (CJoyValCtl*) GetDlgItem(_3D_IDC_ROUTVAL);
	
	m_row[4].pcbIn = &m_cbUin;
	m_row[4].pjvIn = (CJoyValCtl*) GetDlgItem(_3D_IDC_UINVAL);
	m_row[4].pcbBtn = &m_cbUbtn;
	m_row[4].piDead = &m_iUdead;
	m_row[4].pdScale = &m_dUscale;
	m_row[4].pjvOut = (CJoyValCtl*) GetDlgItem(_3D_IDC_UOUTVAL);
	
	m_row[5].pcbIn = &m_cbVin;
	m_row[5].pjvIn = (CJoyValCtl*) GetDlgItem(_3D_IDC_VINVAL);
	m_row[5].pcbBtn = &m_cbVbtn;
	m_row[5].piDead = &m_iVdead;
	m_row[5].pdScale = &m_dVscale;
	m_row[5].pjvOut = (CJoyValCtl*) GetDlgItem(_3D_IDC_VOUTVAL);
	
	// Set up the input selection lists	and button lists
	for (int i = 0; i < 6; i++) {
		int iIn = m_pDev->GetConfig()->axis[i].iInput;
		SetInList(m_row[i].pcbIn);
		m_row[i].pcbIn->SetCurSel(iIn);
		SetBtnList(m_row[i].pcbBtn);
		m_row[i].pcbBtn->SetCurSel(m_pDev->GetConfig()->axis[i].iButton);
		m_row[i].pjvIn->SetRange(0, 65535);
		m_row[i].pjvOut->SetRange(0, 65535);
		*(m_row[i].piDead) = m_pDev->GetConfig()->axis[i].iDead;
		*(m_row[i].pdScale) = m_pDev->GetConfig()->axis[i].dSens;
	}


	UpdateData(FALSE);

	// Start the update timer
	ShowState();
	SetTimer(1, 100, NULL); 

	return CPropertyPage::OnSetActive();
}

BOOL CAxesPage::OnKillActive() 
{
	if (m_uiTimer) {
		KillTimer(1);
		m_uiTimer = 0;
	}
	
	return CPropertyPage::OnKillActive();
}


void CAxesPage::OnTimer(UINT nIDEvent) 
{
	// Show the current state
	ShowState();
}

void CAxesPage::ShowState()
{
	// grab the current dialog values
	UpdateData(TRUE);

	// read the joystick data
	int iVal[6];
	JOYINFOEX* pInfo = m_pDev->GetInfo();
	iVal[0] = pInfo->dwXpos;
	iVal[1] = pInfo->dwYpos;
	iVal[2] = pInfo->dwZpos;
	iVal[3] = pInfo->dwRpos;
	iVal[4] = pInfo->dwUpos;
	iVal[5] = pInfo->dwVpos;
	
	int iMin = 0;
	int iMax = 65535; // assume these for now

	// get the set of buttons used for qualifying outputs
	DWORD dwQualBtn = 0;
	for (int i = 0; i < 6; i++) {
		int iBtn = m_row[i].pcbBtn->GetCurSel();
		DWORD dwBtnMask = 0;
		if (iBtn > 0) {
			dwBtnMask = 1 << (iBtn - 1);
			dwQualBtn |= dwBtnMask;
		}
	}
	
	for (i = 0; i < 6; i++) {
		// get the input channel
		int iSel = m_row[i].pcbIn->GetCurSel();
		if (iSel < 0) iSel = 0;
		int iInCh = iSel;

		// get the qualifier button
		int iBtn = m_row[i].pcbBtn->GetCurSel();
		DWORD dwBtnMask = 0;
		if (iBtn > 0) {
			dwBtnMask = 1 << (iBtn - 1);
		}

		// Set the deadband value
		int iDeadRange = (iMax - iMin) * *(m_row[i].piDead) / 100;
		int iDeadMin = (iMax - iMin - iDeadRange) / 2;
		int iDeadMax = iDeadMin + iDeadRange;
		m_row[i].pjvIn->SetDeadBand(iDeadMin, iDeadMax);

		// set the value of the input
		int iInVal = iVal[iInCh];
		m_row[i].pjvIn->SetValue(iInVal);

		int iOut = (iMin + iMax) / 2;

		// see if we require a qualifying button
		if (((dwBtnMask == 0) && !(pInfo->dwButtons & dwQualBtn))
		|| (pInfo->dwButtons & dwBtnMask)) {
				
			// compute the output value given the dead band and range
			double dscale = *(m_row[i].pdScale);
			if (iInVal < iDeadMin) {
				iOut -= (int)((iDeadMin - iInVal) * dscale); 
			} else if (iInVal > iDeadMax) {
				iOut += (int)((iInVal - iDeadMax) * dscale); 
			}
		}
		m_row[i].pjvOut->SetValue(iOut);
	}
}

BOOL CAxesPage::OnApply() 
{
	UpdateData(TRUE);

	// Save the current dialog values
	JOYCONFIG* pcfg = m_pDev->GetConfig();

	for (int i = 0; i < 6; i++) {
		int iSel = m_row[i].pcbIn->GetCurSel();
		if (iSel < 0) iSel = 0;
		pcfg->axis[i].iInput = iSel;
		pcfg->axis[i].iButton = m_row[i].pcbBtn->GetCurSel();
		pcfg->axis[i].iDead = *(m_row[i].piDead);
		double dscale = *(m_row[i].pdScale);
		pcfg->axis[i].dSens = dscale;
	}
	
	return CPropertyPage::OnApply();
}

