#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <graphics.h>
#define MAX_X 640
#define MAX_Y 480
#define TEX_X 100
#define TEX_Y 100
static unsigned char tex_map[TEX_Y][TEX_X];
class CEnd {
public:
	float x; // x co-ordinates
	int side; //for texture mapping
	float xi;// location rate for interpolation
	CEnd(void) {x=0.; side=-1;}
	CEnd(float x2,int xi2,int side2) {x=x2,xi=xi2,side=side2;}
};
CEnd edge[MAX_Y][2];

//does it
void check_boundary(float sx,float sy, float ex,float ey,int side) {
	float tmpx,tmpy;
	float addx,x,y;
	float in,dis;//for interpolation
	//swap
	if (ey<sy) {
	tmpx=sx;
	tmpy=sy;

	sx=ex,sy=ey;
	ex=tmpx, ey=tmpy;
	}

	//check
	dis=sqrt(pow(ex-sx,2)+ pow(ey-sy,2) ); //the distance

	addx=(ex-sx)/(ey-sy); //set up
	x=sx,y=sy;

	for (y=sy;y<ey;y++) {
	x+=addx;

	//compare
	in= sqrt(pow(x-sx,2) + pow( y- sy,2))/ dis;
	if (x<edge[y][0].x) edge[y][0]=CEnd(x,in,side); //starting point
	if (x>edge[y][1].x) edge[y][1]=CEnd(x,in,side); //ending point
	}

}
void drawline(CEnd s, CEnd e, int y) {

	float tsx,tsy;
	float tex,tey;
	float xp,yp;//texture map pointer
	float xin; //x location rate
	//set texture map pointer
	if (s.side==0) {tsx=s.xi; tsy=0;}
	else if (s.side==1) {tsx=0; tsy=s.xi;}
	else if (s.side==2) {tsx=s.xi; tsy=1;}
	else if (s.side==3) {tsx=1; tsy=s.xi;}

	if (e.side==0) {tex=e.xi; tey=0;}
	else if (e.side==1) {tex=0; tey=e.xi;}
	else if (e.side==2) {tex=e.xi; tey=1;}
	else if (e.side==3) {tex=1; tey=e.xi;}

	float x;
	unsigned char color;
	for (x=s.x; x<=e.x; x++) {
	xin=(x-s.x)/(e.x-s.x); //unit value
	xp=(tex-tsx)*xin+tsx;
	yp=(tey-tsy)*xin+tsy;
	color=tex_map[yp*TEX_Y][xp*TEX_X];
	if (color) putpixel(x,y,15 );
	}
}
void polygon(float p[4][2])
{
	int i;

	//initialize edge
	for (i=0;i<MAX_Y;i++) {
	edge[i][0]=CEnd(MAX_X,-1,-1); //left end
	edge[i][1]=CEnd(-1,  -1, -1);//right end
	}

	//check
	for (i=0;i<4;i++ ) {
	check_boundary(p[i][0], p[i][1], p[(i+1)%4][0],p[(i+1)%4][1],i);
	}

	//draw
	for (i=0;i<MAX_Y;i++) {
	if (edge[i][0].x< edge[i][1].x)
	{
	drawline(edge[i][0],edge[i][1],i );
	}//end of if
	}//end of for

}
void main(void)
{
	int card=VGA,mode=VGAHI;
	initgraph(&card,&mode,"");
	float point[4][2]={100,50, 200,10, 180,100, 120, 150};
	//set up
	{
	int i,j;
	for (j=0;j<TEX_Y;j++)
	for (i=0;i<TEX_X;i++)
	tex_map[j][i]=0; //clear texture map
	for(i=0;i<TEX_X;i++) {
	tex_map[i][i]=0;
	}
	}

	polygon(point);
	getch();
	closegraph();
}