
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <graphics.h>
#include <stdarg.h>


int log(char* fmt, ...)
{
	static char buffer[200];
	int cnt;
	va_list argptr;
	va_start(argptr,fmt);
	cnt=vsprintf(buffer,fmt,argptr);
	va_end(argptr);

	FILE* f;
	f=fopen("log.txt","at");
	fprintf(f,"%s",buffer);
	fclose(f);
	return cnt;
}

#define MAX_X 640
#define MAX_Y 480

#define MAX_TEXTURE_X 200
#define MAX_TEXTURE_Y 200
unsigned char tex_map[MAX_TEXTURE_Y][MAX_TEXTURE_X];
int tex_sizex=100;
int tex_sizey=100;
char* tex_name="texture.pcx";

template <class T> class CVector {
public:
	float x,y,z;
	CVector(T x2, T y2) {x=x2,y=y2;}
	CVector(T x2, T y2, T z2) {x=x2,y=y2,z=z2;}
	CVector(void) {x=y=z=(T)0;}
	CVector operator + (CVector a) {
	CVector<T> ret(x+a.x, y+a.y, z+a.z);
	return ret;
	}
	CVector operator - (CVector a) {
	CVector<T> ret(x-a.x, y-a.y, z-a.z);
	return ret;
	}
	CVector operator * (CVector a) {
	CVector<T> ret(x*a.x, y*a.y, z*a.z);
	return ret;
	}
	CVector operator / (CVector a) {
	CVector<T> ret(x/a.x, y/a.y, z/a.z);
	return ret;
	}

	void print(void) {cout<<"x\t"<<x<<"\ty\t"<<y<<"\tz\t"<<z<<endl;}
};

class CEnd {
public:
	float x; //scan-line interpolation
	CVector<float> t; //texture pointer
	CEnd(void) {x=0.; }
	CEnd(float x2) {x=x2;}
};
CEnd edge[MAX_Y][2];

//does it
void check_boundary(CVector<float> s,CVector<float> e,
CVector<float> ts, CVector<float> te) {
	CVector<float> tmp;
	CVector<float> cur;
	CVector<float> add;
	CVector<float> tcur;
	CVector<float> tadd;
	//swap
	if (e.y<s.y) {
	tmp=s;
	s=e; e=tmp;
		   //bug fix.. you must swap texture pointers,too..
	tmp=ts;
	ts=te, te=tmp;

	}

	if (s.y>=e.y) return;

	//prepare for interpolation
	add=CVector<float>( (e.x-s.x)/(e.y-s.y),1);
	cur=s;

	//prepare for texturemap interpolation
	tadd.x=(te.x-ts.x) / (e.y- s.y);
	tadd.y=(te.y-ts.y) / (e.y- s.y);
	tcur=ts;

	//interpolate
	int i;
	for (i= s.y;i < e.y; i++) {
	//interpolate
	cur = cur + add;
	tcur= tcur+ tadd;

	//compare
	if (cur.x<edge[i][0].x) {edge[i][0].x=cur.x;edge[i][0].t=tcur;

	} //starting point
	if (cur.x>edge[i][1].x) {edge[i][1].x=cur.x;edge[i][1].t=tcur;
	} //ending point

	}//end of for

}
void polygon(CVector<float> p[4])
{
	int i;

	//initialize edge
	for (i=0;i<MAX_Y;i++) {
	edge[i][0]=CEnd(MAX_X); //left end
	edge[i][1]=CEnd(-1  );//right end
	}

	//texture map
	CVector<float> t[4];
	t[0]=CVector<float> (0,0);
	t[1]=CVector<float> (tex_sizex,0);
	t[2]=CVector<float> (tex_sizex,tex_sizey);
	t[3]=CVector<float> (0,tex_sizey);

	//check
	check_boundary(p[0] , p[1], t[0], t[1]);
	check_boundary(p[1] , p[2], t[1], t[2]);
	check_boundary(p[2] , p[3], t[2], t[3]);
	check_boundary(p[3] , p[0], t[3], t[0]);

	//draw
	for (i=0;i<MAX_Y;i++) {
	if (edge[i][0].x< edge[i][1].x ) {
	//draw texture
	//line(edge[i][0].x, i, edge[i][1].x,i );
	float x,sx=edge[i][0].x, ex=edge[i][1].x;
	CVector<float> ts=edge[i][0].t;
	CVector<float> te=edge[i][1].t;
	CVector<float> tcur=ts;
	CVector<float> tadd(0.,0.);
	if (ex-sx>=1. )                {


      tadd.x=(te.x-ts.x)/(ex-sx);
      tadd.y=(te.y-ts.y)/(ex-sx);

	for (x=sx;x<ex;x++) {
	  tcur = tcur + tadd;
	putpixel(x,i, tex_map[((int)tcur.y)%tex_sizey][((int)tcur.x)%tex_sizex]);
	}//end of for

	}//end of if



	}//end of if

	}//end of for

}
void make_texture(unsigned char map[MAX_TEXTURE_Y][MAX_TEXTURE_X], int sx,int sy) {
//clear
	int i,j;
	for (j=0;j<sy;j++)
	for (i=0;i<sx;i++) {
	map[j][i]=0;
	}

	//make
	for (i=0;i<100;i++) {
	for (j=0;j<10;j++) {
	map[i][j+0]=1;
	map[i][j+90]=1;
	map[j+0][i]=1;
	map[j+90][i]=1;
	}

	}

	//show texture
	setcolor(WHITE);
	rectangle(400-1,300-1,400+tex_sizex,300+tex_sizey);
	for (j=0;j<tex_sizey;j++) {
	for (i=0;i<tex_sizex;i++) {
	putpixel(i+400,j+300,tex_map[j][i]);
	}
	}
}
void main(void)
{
	int card=VGA,mode=VGAHI;
	initgraph(&card,&mode,"");
	CVector<float> point[4];
	point[0]=CVector<float>(100,50);
	point[1]=CVector<float>(200,10);
	point[2]=CVector<float>(180,100);
	point[3]=CVector<float>(120,150);
	//set up
	make_texture(tex_map,tex_sizex,tex_sizey);

	polygon(point);
	getch();
	closegraph();
}
void main2(void)
{
	CVector<float> a(1,2,3);
	CVector<float> b(2,3,4);
	CVector<float> c;
	c=(a-b)/b;
	c.print();
}
