extern "C" {
#include "pgk.h"
int expandPCX(unsigned char * pcxfn,int xp,int yp,int *xsize,int *ysize,
unsigned char ** imgptr,unsigned char* pal,int flag);
};
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#include <math.h>
#include <graphics.h>

#define putpixel(x,y,c) pSetP(x,y,c)

void polygon_test(void);
void make_texture(char* name);
void poly(int x0,int y0,
	  int x1,int y1,
	  int x2,int y2,
	  int x3,int y3);


class Matrix {
public:
float buf[4][4];
public:
Matrix(void);
void Matrix::convert(float x,float y,float z,float* x2,float *y2);
Matrix(float a00,float a01,float a02,float a03,
	       float a10,float a11,float a12,float a13,
	       float a20,float a21,float a22,float a23,
	       float a30,float a31,float a32,float a33);
Matrix(float a00,float a01,float a02);
void line(float sx,float sy,float sz,float ex,float ey,float ez);
void moveto(float x, float y, float z);
void lineto(float x, float y, float z);
void putpixel3d(float x, float y, float z,int color);
Matrix operator * (Matrix a);
void unit(void);
void print(void);
};




Matrix::Matrix(void)
{
	buf[0][0]=1.0, buf[0][1]=0.0, buf[0][2]=0.0, buf[0][3]=0.0;
	buf[1][0]=0.0, buf[1][1]=1.0, buf[1][2]=0.0, buf[1][3]=0.0;
	buf[2][0]=0.0, buf[2][1]=0.0, buf[2][2]=1.0, buf[2][3]=0.0;
	buf[3][0]=0.0, buf[3][1]=0.0, buf[3][2]=0.0, buf[3][3]=1.0;
}

Matrix::Matrix(float a00,float a01,float a02,float a03,
	       float a10,float a11,float a12,float a13,
	       float a20,float a21,float a22,float a23,
	       float a30,float a31,float a32,float a33)
{
	buf[0][0]=a00,buf[0][1]=a01, buf[0][2]=a02, buf[0][3]=a03;
	buf[1][0]=a10, buf[1][1]=a11, buf[1][2]=a12, buf[1][3]=a13;
	buf[2][0]=a20, buf[2][1]=a21, buf[2][2]=a22, buf[2][3]=a23;
	buf[3][0]=a30, buf[3][1]=a31, buf[3][2]=a32, buf[3][3]=a33;

}

Matrix::Matrix(float a00,float a01,float a02)
{
	buf[0][0]=a00,buf[0][1]=a01, buf[0][2]=a02, buf[0][3]=1.0;
	buf[1][0]=0.0, buf[1][1]=0.0, buf[1][2]=0.0, buf[1][3]=0.0;
	buf[2][0]=0.0, buf[2][1]=0.0, buf[2][2]=0.0, buf[2][3]=0.0;
	buf[3][0]=0.0, buf[3][1]=0.0, buf[3][2]=0.0, buf[3][3]=0.0;
}
void Matrix::unit(void)
{
	float a=buf[0][3];
	int i;
	for (i=0;i<=3;i++) buf[0][i]/=a;
}

void Matrix::print(void)
{
        int i,j;
	for (j=0;j<=3;j++) {
		for (i=0;i<=3;i++) {
		printf("%5.3f  ",buf[j][i]);
		}
	printf("\n");
	}
}

Matrix Matrix::operator * (Matrix a)
{
	int i,j,k;
	Matrix r;
	for (j=0;j<=3;j++) {  //row matrix of first
		for(i=0;i<=3;i++) { //column matrix of second
			r.buf[j][i]=0.0;
			for (k=0;k<=3;k++) {
			r.buf[j][i]+= buf[j][k] * a.buf[k][i];
			}

		}
	}
	return r;

}

void Matrix::convert(float x,float y,float z,float* x2,float *y2) {
	Matrix p,p2;
	p.buf[0][0]=x, p.buf[0][1]=y, p.buf[0][2]=z, p.buf[0][3]=1.0;
	p2=p*(*this);

	*x2=p2.buf[0][0]+320.0/2.0;
	*y2=-p2.buf[0][1]+200.0/2.0;
}
void Matrix::putpixel3d(float x, float y, float z,int color) {
	float x2,y2;
	Matrix p,p2;
	p.buf[0][0]=x, p.buf[0][1]=y, p.buf[0][2]=z, p.buf[0][3]=1.0;
        p2=p*(*this);
	p2.unit();

	x2=p2.buf[0][0]+640.0/2.0;
        y2=-p2.buf[0][1]+480.0/2.0;
	putpixel(x2,y2,color);

}
void Matrix::moveto(float x, float y, float z) {
	float x2,y2;
	Matrix p,p2;
	p.buf[0][0]=x, p.buf[0][1]=y, p.buf[0][2]=z, p.buf[0][3]=1.0;
	p2=p*(*this);
	p2.unit();

	x2=p2.buf[0][0]+640.0/2.0;
	y2=-p2.buf[0][1]+480.0/2.0;

	::moveto(x2,y2);

}
void Matrix::lineto(float x, float y, float z) {
	float x2,y2;
	Matrix p,p2;
	p.buf[0][0]=x, p.buf[0][1]=y, p.buf[0][2]=z, p.buf[0][3]=1.0;
	p2=p*(*this);
	p2.unit();
	x2=p2.buf[0][0]+640.0/2.0;
	y2=-p2.buf[0][1]+480.0/2.0;
	::lineto(x2,y2);

}
void Matrix::line(float sx,float sy,float sz,float ex,float ey,float ez)
{
	moveto(sx,sy,sz);
	lineto(ex,ey,ez);
}
void draw(void)
{
		float zoom =7.0;  //magnify
	float mx=0.0; //camera's location x,y,z
	float my=0.0;
	float mz=0.0;

	//tx 30  ty -30  tz -18
	float tx=30.0*M_PI/180.0; //rotating angel around x axis
	float ty=-45.0*M_PI/180.0;
	float tz=-18.0*M_PI/180.0;
	float zcp= 270.0; //projection screen's location (or height)
	//it it is too short, image will be distorted..
	Matrix sca=Matrix(zoom*1.0, 0.0, 0.0, 0.0,
                          0.0, zoom*1.0, 0.0, 0.0,
			  0.0, 0.0, zoom*1.0, 0.0,
                          0.0,  0.0,  0.0,  1.0);

	Matrix mov=Matrix(1.0, 0.0, 0.0, 0.0,
			  0.0, 1.0, 0.0, 0.0,
			  0.0, 0.0, 1.0, 0.0,
			  mx,  my,  mz,  1.0);
	Matrix zr=Matrix(cos(tz),sin(tz), 0.0, 0.0,
                         -sin(tz),cos(tz), 0.0, 0.0,
			 0.0, 0.0, 1.0, 0.0,
			 0.0, 0.0, 0.0, 1.0);
	Matrix yr=Matrix(cos(ty), 0.0, -sin(ty), 0.0,
			 0.0, 1.0, 0.0, 0.0,
			 sin(ty), 0.0, cos(ty), 0.0,
			 0.0, 0.0, 0.0, 1.0);
	Matrix xr=Matrix(1.0, 0.0, 0.0, 0.0,
			0.0, cos(tx), sin(tx), 0.0,
			0.0, -sin(tx), cos(tx), 0.0,
			0.0, 0.0, 0.0, 1.0);
	Matrix pro= Matrix( 1.0, 0.0, 0.0, 0.0,  //projection
			   0.0, 1.0, 0.0, 0.0,
			   0.0, 0.0, 0.0, 0.0,
			   0.0, 0.0, 0.0, 1.0);
	Matrix per= Matrix( 1.0, 0.0, 0.0, 0.0,  //perspective
			   0.0, 1.0, 0.0, 0.0,
                           0.0, 0.0, 1.0, -1.0/(zcp),
			   0.0, 0.0, 0.0, 1.0);
	//zoom in -> translate->rotate(for the camera)
	//->perspective (zoom) -> projection to (screen's x y )
	Matrix s=sca*mov*yr*xr*per*pro;

	setfillstyle(SOLID_FILL,WHITE);
	bar(0,0,639,479);


	setlinestyle(DOTTED_LINE,0,1);
	int i,j;
	setcolor(BLUE);
		for (i=0;i<=20;i++) {   //xy
        s.moveto(0,i,0);
	s.lineto(20,i,0);

        }

        setcolor(RED);
        for (i=0;i<=20;i++) {  //xz
	s.moveto(0,0,i);
	s.lineto(20,0,i);

        }

                setcolor(GREEN);
                        for (i=0;i<=20;i++) { //yz
	s.moveto(0,i,0);
	s.lineto(0,i,20);

	}

	setlinestyle(SOLID_LINE,0,3);

	settextstyle(0,0,3);
        setcolor(BLACK);
        s.moveto(0,0,0);
        s.lineto(0,0,20);setcolor(RED);outtext("z");setcolor(BLACK);

        s.moveto(0,0,0);
        s.lineto(20,0,0);setcolor(RED);outtext("x");setcolor(BLACK);

        s.moveto(0,0,0);
        s.lineto(0,20,0);setcolor(RED);outtext("y");setcolor(BLACK);

        setcolor(RED);
        s.moveto(0,0,0);
	s.lineto(5,0,0);
	s.lineto(1,3,2);
	s.lineto(0,0,0);


	Matrix rr(
        1.0, 0.0, 0.0, 0.0,
	0.0, 0.55, -8.33, 0.0,
	0.0, -0.833, 0.55, 0.0,
	0.0, 0.0, 0.0, 1.0
	);
	Matrix s2=rr*s;
	setcolor(BLUE);
	s2.moveto(0,0,0);
	s2.lineto(5,0,0);
	s2.lineto(1,3,2);
	s2.lineto(0,0,0);



}

Matrix set_matrix(void)
{
	float zoom =10.0;  //magnify
	float mx=0.0; //camera's location x,y,z
	float my=0.0;
	float mz=0.0;

        //tx 30  ty -30  tz -18
        float tx=30.0*M_PI/180.0; //rotating angel around x axis
        float ty=-30.0*M_PI/180.0;
        float tz=-18.0*M_PI/180.0;
        float zcp= 270.0; //projection screen's location (or height)
	//it it is too short, image will be distorted..
        Matrix sca=Matrix(zoom*1.0, 0.0, 0.0, 0.0,
                          0.0, zoom*1.0, 0.0, 0.0,
			  0.0, 0.0, zoom*1.0, 0.0,
                          0.0,  0.0,  0.0,  1.0);

	Matrix mov=Matrix(1.0, 0.0, 0.0, 0.0,
			  0.0, 1.0, 0.0, 0.0,
			  0.0, 0.0, 1.0, 0.0,
			  mx,  my,  mz,  1.0);
	Matrix zr=Matrix(cos(tz),sin(tz), 0.0, 0.0,
			 -sin(tz),cos(tz), 0.0, 0.0,
			 0.0, 0.0, 1.0, 0.0,
			 0.0, 0.0, 0.0, 1.0);
	Matrix yr=Matrix(cos(ty), 0.0, -sin(ty), 0.0,
			 0.0, 1.0, 0.0, 0.0,
			 sin(ty), 0.0, cos(ty), 0.0,
			 0.0, 0.0, 0.0, 1.0);
	Matrix xr=Matrix(1.0, 0.0, 0.0, 0.0,
			0.0, cos(tx), sin(tx), 0.0,
			0.0, -sin(tx), cos(tx), 0.0,
			0.0, 0.0, 0.0, 1.0);
	Matrix pro= Matrix( 1.0, 0.0, 0.0, 0.0,  //projection
			   0.0, 1.0, 0.0, 0.0,
			   0.0, 0.0, 0.0, 0.0,
			   0.0, 0.0, 0.0, 1.0);
	Matrix per= Matrix( 1.0, 0.0, 0.0, 0.0,  //perspective
			   0.0, 1.0, 0.0, 0.0,
			   0.0, 0.0, 1.0, -1.0/(zcp),
			   0.0, 0.0, 0.0, 1.0);
	//zoom in -> translate->rotate(for the camera)
	//->perspective (zoom) -> projection to (screen's x y )
	Matrix s=sca*mov*xr*yr*zr*per*pro;

	return s;
}


void line3d(float sx,float sy, float sz,
	    float ex,float ey, float ez,Matrix m, int color=15)
{

	    float sx2,sy2;
	    float ex2,ey2;
	    m.convert(sx,sy,sz, &sx2, &sy2);
	    m.convert(ex,ey,ez, &ex2, &ey2);


		pCLine(sx2,sy2, ex2,ey2,color);
}
void poly3d(float x0,float y0, float z0,
	    float x1,float y1, float z1,
	    float x2,float y2, float z2,
	    float x3,float y3, float z3,
	    Matrix m)
{

	    float px0,py0;
	    float px1,py1;
	    float px2,py2;
	    float px3,py3;
	    m.convert(x0,y0,z0, &px0, &py0);
	    m.convert(x1,y1,z1, &px1, &py1);
	    m.convert(x2,y2,z2, &px2, &py2);
	    m.convert(x3,y3,z3, &px3, &py3);
	poly(px0,py0, px1,py1, px2,py2, px3,py3);
}


//////////////////////////////////////
unsigned char * FontPtr;
Matrix Space;



void main(void)
{
   vga320Mode() ; /* aa aϢea aa. */
   FontPtr = (unsigned char *)(*((unsigned char **)(0x43*4))) ;
   pClrScr(0);
   Space=set_matrix();
   make_texture("texture.pcx");

   workPage(0);
   viewPage(0);
   line3d(0,0,0, 20,0,0, Space);  //x
   line3d(0,0,0, 0,10,0, Space); //y
   line3d(0,0,0, 0,0,20, Space); //Z
   poly3d(0,0,0,
	  0,0,10,
	  10,0,10,
	  10,0,0,Space);
	  poly3d(0,0,0,
	  0,10,0,
	  10,10,0,
	  10,0,0,Space);
	  poly3d(0,0,0,
	  0,10,0,
	  0,10,10,
	  0,0,10,Space);



   getch();
   vgaTextMode() ; /* Baa a aa. */
}

//texture map
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <graphics.h>
#include <stdarg.h>


int log(char* fmt, ...)
{
	static char buffer[200];
	int cnt;
	va_list argptr;
	va_start(argptr,fmt);
	cnt=vsprintf(buffer,fmt,argptr);
	va_end(argptr);

	FILE* f;
	f=fopen("log.txt","at");
	fprintf(f,"%s",buffer);
	fclose(f);
	return cnt;
}

#define MAX_X 320
#define MAX_Y 200

#define MAX_TEXTURE_X 200
#define MAX_TEXTURE_Y 200
unsigned char tex_map[MAX_TEXTURE_Y][MAX_TEXTURE_X];
int tex_sizex=100;
int tex_sizey=100;
char* tex_name="texture.pcx";

template <class T> class CVector {
public:
	float x,y,z;
	CVector(T x2, T y2) {x=x2,y=y2;}
	CVector(T x2, T y2, T z2) {x=x2,y=y2,z=z2;}
	CVector(void) {x=y=z=(T)0;}
	CVector operator + (CVector a) {
	CVector<T> ret(x+a.x, y+a.y, z+a.z);
	return ret;
	}
	CVector operator - (CVector a) {
	CVector<T> ret(x-a.x, y-a.y, z-a.z);
	return ret;
	}
	CVector operator * (CVector a) {
	CVector<T> ret(x*a.x, y*a.y, z*a.z);
	return ret;
	}
	CVector operator / (CVector a) {
	CVector<T> ret(x/a.x, y/a.y, z/a.z);
	return ret;
	}

	void print(void) {cout<<"x\t"<<x<<"\ty\t"<<y<<"\tz\t"<<z<<endl;}
};

class CEnd {
public:
	float x; //scan-line interpolation
	CVector<float> t; //texture pointer
	CEnd(void) {x=0.; }
	CEnd(float x2) {x=x2;}
};
CEnd edge[MAX_Y][2];

//does it
void check_boundary(CVector<float> s,CVector<float> e,
CVector<float> ts, CVector<float> te) {
	CVector<float> tmp;
	CVector<float> cur;
	CVector<float> add;
	CVector<float> tcur;
	CVector<float> tadd;
	//swap
	if (e.y<s.y) {
	tmp=s;
	s=e; e=tmp;
		   //bug fix.. you must swap texture pointers,too..
	tmp=ts;
	ts=te, te=tmp;

	}

	if (s.y>=e.y) return;

	//prepare for interpolation
	add=CVector<float>( (e.x-s.x)/(e.y-s.y),1);
	cur=s;

	//prepare for texturemap interpolation
	tadd.x=(te.x-ts.x) / (e.y- s.y);
	tadd.y=(te.y-ts.y) / (e.y- s.y);
	tcur=ts;

	//interpolate
	int i;
	for (i= s.y;i < e.y; i++) {
	//interpolate
	cur = cur + add;
	tcur= tcur+ tadd;

	//compare
	if (cur.x<edge[i][0].x) {edge[i][0].x=cur.x;edge[i][0].t=tcur;

	} //starting point
	if (cur.x>edge[i][1].x) {edge[i][1].x=cur.x;edge[i][1].t=tcur;
	} //ending point

	}//end of for

}
void polygon(CVector<float> p[4])
{
	int i;

	//initialize edge
	for (i=0;i<MAX_Y;i++) {
	edge[i][0]=CEnd(MAX_X); //left end
	edge[i][1]=CEnd(-1  );//right end
	}

	//texture map
	CVector<float> t[4];
	t[0]=CVector<float> (0,0);
	t[1]=CVector<float> (tex_sizex,0);
	t[2]=CVector<float> (tex_sizex,tex_sizey);
	t[3]=CVector<float> (0,tex_sizey);

	//check
	check_boundary(p[0] , p[1], t[0], t[1]);
	check_boundary(p[1] , p[2], t[1], t[2]);
	check_boundary(p[2] , p[3], t[2], t[3]);
	check_boundary(p[3] , p[0], t[3], t[0]);

	//draw
	for (i=0;i<MAX_Y;i++) {
	if (edge[i][0].x< edge[i][1].x ) {
	//draw texture
	//line(edge[i][0].x, i, edge[i][1].x,i );
	float x,sx=edge[i][0].x, ex=edge[i][1].x;
	CVector<float> ts=edge[i][0].t;
	CVector<float> te=edge[i][1].t;
	CVector<float> tcur=ts;
	CVector<float> tadd(0.,0.);
	if (ex-sx>=1. )                {


      tadd.x=(te.x-ts.x)/(ex-sx);
      tadd.y=(te.y-ts.y)/(ex-sx);

	for (x=sx;x<ex;x++) {
	  tcur = tcur + tadd;
	putpixel(x,i, tex_map[((int)tcur.y)%tex_sizey][((int)tcur.x)%tex_sizex]);
	}//end of for

	}//end of if



	}//end of if

	}//end of for

}

void make_texture(char* name)
{
   int x,y,c,xs,ys,m ;
   unsigned char *spritePtr ;
   x=100,y=100;

   spritePtr=NULL ;
   if (expandPCX(name,0,0,&xs,&ys,&spritePtr,NULL,0x6)<0)
   {
     sprintf(0,0,"kenface.pcx File Not Found !!",255,0) ;
     return ;
   } ;
   tex_sizex=xs;
   tex_sizey=ys;
   workPage(1);
   pClrPage(1,0);
   pCPutSpr(0,0,spritePtr,xs,ys,0) ;
   int i,j;
   for (j=0;j<tex_sizey;j++)
   for (i=0;i<tex_sizex;i++) {
   tex_map[j][i]=pGetP(i,j);
   pSetP(i,j,255-pGetP(i,j));
   }//end of for
   workPage(0);


   //memcpy(tex_map, spritePtr, xs*ys);
   //	make_texture(tex_map,tex_sizex,tex_sizey);

}
void polygon_test(void)
{
	CVector<float> point[4];
	point[0]=CVector<float>(100,50);
	point[1]=CVector<float>(200,10);
	point[2]=CVector<float>(180,100);
	point[3]=CVector<float>(120,150);
	//set up
	make_texture("texture.pcx");

  polygon(point);
}
void poly(int x0,int y0,
	  int x1,int y1,
	  int x2,int y2,
	  int x3,int y3)
{
	CVector<float> point[4];
	point[0]=CVector<float>(x0,y0);
	point[1]=CVector<float>(x1,y1);
	point[2]=CVector<float>(x2,y2);
	point[3]=CVector<float>(x3,y3);
	//set up
	make_texture("texture.pcx");

  polygon(point);
}
void main2(void)
{
	CVector<float> a(1,2,3);
	CVector<float> b(2,3,4);
	CVector<float> c;
	c=(a-b)/b;
	c.print();
}
