#include <stdlib.h>
#include <stdio.h>
#include <alloc.h>

#include "pgk.h"

/*
   PCX Graphic File Processing Module
*/

/*
   PCX Header Structure
*/

typedef struct
{
   char maker,version,code,bpp ;
   int x1,y1,x2,y2,hres,vres   ;
   char index[16][3],vmode,nplanes ;
   int bpl,palinfo,shres,svres ;
   char dumy[54] ;
} PCXHEADER ;

/*
   pcxfn : PCX File Name
   xp,yp : draw X,Y position
   *xsize,*ysize : PCX data File x,y size
   **imgptr : expand pcx file restore pointer
   pal[256][3] : pcx output palette
   flag : PCX Management Flag
     bit 0 : if bit 0 is 1 , draw PCX File
     bit 1 : allcate memory & copy PCX file to imgptr
     bit 2 : change Palette
     bit 3 : get Palette
*/

expandPCX(pcxfn,xp,yp,xsize,ysize,imgptr,pal,flag)
unsigned char *pcxfn,**imgptr,*pal ;
int xp,yp,*xsize,*ysize,flag ;
{
   PCXHEADER pcx ;
   unsigned char tag,data,len,*ptr,tmpPal[768] ;
   long l,hres,vres,rhres,total ;
   int i,x,y ;
   FILE *fp ;

   fp=fopen(pcxfn,"rb") ;
   if (fp==NULL) return(-1) ;
   fread(&pcx,sizeof(PCXHEADER),1,fp) ;

   vres = pcx.y2 - pcx.y1 + 1 ;
   rhres = pcx.x2 - pcx.x1 + 1 ;
   hres = pcx.bpl ;
   total = hres * vres ;

   if ((flag&0x2) && (*imgptr)==NULL)
   {
     ptr = malloc(rhres*vres) ;
     if (ptr==NULL) flag &= 0xD ;
     *imgptr = ptr ;
   }

   *xsize = rhres ; *ysize = vres  ;

   if (pcx.code)
   for ( l=0 ; l<total ; )
   {
     tag=fgetc(fp) ;

     if ((tag&0xc0)==0xc0) { len=tag&0x3f ; data=fgetc(fp) ; }
           else            { len=1 ; data=tag ; }

     for ( i=0 ; i<len ; i++,l++)
     {
       x=l%hres ; y=l/hres ;
       if (x>=rhres) continue ;
       if (flag&0x1) pCSetP(xp+x,yp+y,data) ;
       if (flag&0x2) *(ptr++) = data ;
     }
   }
   else
   for ( l=0 ; l<vres*hres ; l++ )
   {
     data=fgetc(fp) ;
     x=l%hres ; y=l/hres ;
     if (x>=rhres) continue ;
     if (flag&0x1) pCSetP(xp+x,yp+y,data) ;
     if (flag&0x2) *(ptr++) = data ;
   }

   fgetc(fp) ;
   fread(tmpPal,3,256,fp) ;
   fclose(fp) ;

   for ( i=0 ; i<768 ; i++ ) tmpPal[i] >>= 2 ;
   if (flag&0x8)
     for ( i=0 ; i<768 ; i++ ) pal[i] = tmpPal[i] ;

   if (flag&0x4) syncSetNRGB(0,256,tmpPal) ;
   return(0) ;
}
