#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <malloc.h>
#include <mem.h>
#include <graph.h>
#include <fcntl.h>
#include "multikey.h"
#include "getopt.h"
#include "svga.h"
#include "pmode.h"

typedef unsigned char      U8;
typedef signed char 	   S8;
typedef unsigned short	  U16;
typedef signed short	  S16;
typedef unsigned long int U32;
typedef signed long int   S32;

U8 *p320;
U8 *pcxptr640;
U8 *filebuf;
U8 palette[256*3];
U8 *pcxsaveptr;
U16 pcxxlen, pcxylen;
U8 buf[4];
U8 pcxfname[15];


#define OFF 0
#define ON	1

// 
// videos...

bool	linearBuffer;
float	lineTime;
long	numLines;
float	linesPerSec;
float	clearTime;
long	numClears;
float	clearsPerSec;
float	clearsMbPerSec;
float	clearSysMbPerSec;
float	bitBltTime;
long	numBitBlts;
float	bitBltsPerSec;
float	bitBltsMbPerSec;
float	copySysMbPerSec;
bool	thrashCache = false;


// 


struct pcx_header
{
    U8 maker;
    U8 ver;
    U8 code;
    U8 bit;
    U16 x1, y1, x2, y2, mx, my;
    U8 palette[48], mode, plane;
    U16 nubi, info, hres, vres;
    U8 extra[54];
} header;


// 


void _cdecl bltImage(U8 *image, U32 numBanks,U32 lastBytes);
void _cdecl bltImageLin(U8 *ptr640, U32 numByte);

void _cdecl getColor(U32 xxx, U32 yyy);
void _cdecl bltImageLinXY(U8 *image, U32 xxx, U32 xlen, U32 yyy, U32 ylen);

void _cdecl bltImageLinXY2XY(U8 *image, U32 xxx, U32 xlen, U32 yyy, U32 ylen, U32 srcx, U32 srcy);


// 

void get_palette(U8 *data)
{
    U16 i;

    outp(0x3c7,0);
    for(i=0;i<768;i++) data[i] = inp(0x3c9);
}


void set_header()
{
    header.maker=10;
    header.ver=5;
    header.code=1;
    header.bit=8;
    header.x1=0;
    header.y1=0;
    header.x2=319;
    header.y2=199;
    header.mx=320;
    header.my=200;
    header.mode=0;
    header.plane=1;
    header.nubi=320;
    header.info=0;
    header.hres=0;
    header.vres=0;
    memset( header.extra, 0, 54);
    memset( header.palette, 0, 48);
}


void set_header640()
{
    header.maker=10;
    header.ver=5;
    header.code=1;
    header.bit=8;
    header.x1=0;
    header.y1=0;
    header.x2=639;
    header.y2=399;
    header.mx=640;
    header.my=400;
    header.mode=0;
    header.plane=1;
    header.nubi=640;
    header.info=0;
    header.hres=0;
    header.vres=0;
    memset( header.extra, 0, 54);
    memset( header.palette, 0, 48);
}


void Save_PCX_picture(U8 *name)
{
    FILE *fp;
    U8 da1, da2, count;
    U16 i,m,x=0,y=0;
    U32 size=0;

    pcxsaveptr=malloc(320*200);

    memset(pcxsaveptr,0,320*200);

    while(y<200)
    {
        count=1;
        da1=p320[(y*320)+x++];

        if (da1>=192)
        {
            pcxsaveptr[size++] = 0xc1;
            pcxsaveptr[size++] = da1;
            if (x>319) { x=0; y++;}
        }
        else
        {
            for(m=0;m<62;m++)
            {
                da2=p320[(y*320)+x++];
                if(x>320) {x=0;y++;break;}
                if(da1==da2) count++;else{x--;break;}
            }
            if (count>1) pcxsaveptr[size++]=192+count;
            pcxsaveptr[size++]=da1;
        }
    }

    set_header();
    get_palette(palette);

    for(i=0;i<768;i++) palette[i] <<=2;

    fp=fopen(name, "wb");
    fwrite(&header,128,1,fp);
    fwrite(pcxsaveptr,size,1,fp);
    fputc(0x0c,fp);
    fwrite(palette,768,1,fp);
    fclose(fp);
    free(pcxsaveptr);
}



void Save_PCX_picture640(U8 *name)
{
    FILE *fp;
    U8 da1, da2, count;
    U16 i,m,x=0,y=0;
    U32 size=0;

    pcxsaveptr=malloc(640*400);

    memset(pcxsaveptr,0,640*400);

    while(y<400)
    {
        count=1;
        da1=pcxptr640[(y*640)+x++];

        if (da1>=192)
        {
            pcxsaveptr[size++] = 0xc1;
            pcxsaveptr[size++] = da1;
            if (x>639) { x=0; y++;}
        }
        else
        {
            for(m=0;m<62;m++)
            {
                da2=pcxptr640[(y*640)+x++];
                if(x>640) {x=0;y++;break;}
                if(da1==da2) count++;else{x--;break;}
            }
            if (count>1) pcxsaveptr[size++]=192+count;
            pcxsaveptr[size++]=da1;
        }
    }

    set_header640();
    get_palette(palette);

    for(i=0;i<768;i++) palette[i] <<=2;

    fp=fopen(name, "wb");
    fwrite(&header,128,1,fp);
    fwrite(pcxsaveptr,size,1,fp);
    fputc(0x0c,fp);
    fwrite(palette,768,1,fp);
    fclose(fp);
    free(pcxsaveptr);
}




void ScrnMode(U8 mode)
{
    union REGS r;

    r.h.al =  mode;
    int386(0x10, &r, &r);
}


// 


void main(U32 argc, U8 *argv[])
{
   FILE *fp;
   U8 pixel;
   U32 xp,yp,flen;
   S32 handle;
   U32 xxx,yyy,i,zzz,zptr,vxsize=128,pagesize;
   U16 fnum=0,val=0;
   U8 ascn[]={"0000"};

   U32 numBanks, lastBytes, imageSize;

   char    systemName[80];
   int vbever=0;

   int mode=0x100; // 0x4100  <- 640*400*256 mode

   imageSize = 640*400;



   numBanks = imageSize / 0x10000;
   lastBytes = imageSize % 0x10000;

   if (SV_queryCpu() < SV_cpu386)
   {
        printf("This program contains '386 specific instructions, and will not work on\n");
		printf("this machine - sorry\n");
		exit(1);
   }

   vbever=SV_init();

   if (vbever < 0x200) {
		printf("This program requires a VESA VBE 2.0 or higher compatible SuperVGA. Try\n");
		printf("installing the Universal VESA VBE for your video card, or contact your\n");
		printf("video card vendor and ask for a suitable TSR\n\n");
		exit(1);
		}


   if(argc<=1)
   {
       printf("Usage : e.exe ?.?\n");
       exit(0);
   }


   handle=open(argv[1], O_CREAT);
   flen=filelength(handle);
   close(handle);


   fp=fopen(argv[1],"rb");

   if(fp==NULL)
   {
       printf("%s not found!!!\n",argv[1]);
       exit(1);
   }




   filebuf=malloc(flen);
   if (filebuf==NULL)
   {
       ScrnMode(0x03);
       printf("File %s is too long... Free more memory!!!\n",argv[1]);
       exit(1);
   }


   fread(filebuf, flen, 1, fp);
   fclose(fp);

   zzz=0;
   pagesize=vxsize*400;

if (SV_setMode(mode))
{
	SV_restoreMode();

	linearBuffer = (mode & vbeLinearBuffer) || virtualBuffer;

//	  mode+=vbeLinearBuffer;

//    getVideoModes();

    printf("linearBuffer=%xh  vbeLinearBuffer=%xh  virtualBuffer=%xh\n",linearBuffer, vbeLinearBuffer, virtualBuffer);
	if (mode>=0x4000) printf("executing program in hardware linear buffer mode.\n");
	if ((virtualBuffer==1) && (mode<0x4000)) printf("executing program in virtual linear buffer mode.\n");

	printf("press a key.\n");
	getch();
}



if (SV_setMode(mode) )
{

   Set_Intr();

   pcxptr640=(U8 *)malloc(640*400);

   memset(pcxptr640, 0, 640*400);

   while(!Ret_Scancode(ESC,M))
   {
       zptr=0;
       for(yyy=0;yyy<=399;yyy++)
       for(xxx=0;xxx<vxsize;xxx++)
       {
           pixel=filebuf[zzz+zptr++];
           pcxptr640[xxx*2+1+yyy*640]=(pixel>>4)+16;
           pcxptr640[xxx*2+yyy*640]=(pixel&0x0f)+16;
       }

       if (vxsize<160)
       {
           for(yyy=0;yyy<=399;yyy++)
           for(xxx=0;xxx<vxsize;xxx++)
           {
               pixel=filebuf[zzz+zptr++];
               pcxptr640[xxx*2+1+yyy*640+320]=(pixel>>4)+16;
               pcxptr640[xxx*2+yyy*640+320]=(pixel&0x0f)+16;
           }
       }

       //bltImageLin(pcxptr640, 640*400);
       bltImage(pcxptr640, numBanks, lastBytes);


       if(Ret_Scancode(UP,M) && zzz>vxsize) zzz-=vxsize;
       if(Ret_Scancode(UP,S) && Ret_Scancode(ALT,S) && zzz>vxsize) zzz-=vxsize;
       if(Ret_Scancode(DOWN,M) && (zzz+vxsize)<flen) zzz+=vxsize;
       if(Ret_Scancode(DOWN,S) && Ret_Scancode(ALT,S) && (zzz+vxsize)<flen) zzz+=vxsize;

       if(Ret_Scancode(LEFT,M) && vxsize!=8) vxsize--;
       if(Ret_Scancode(LEFT,S) && Ret_Scancode(ALT,S) && vxsize!=8) vxsize--;
       if(Ret_Scancode(RIGHT,M) && vxsize<160*4) vxsize++;
       if(Ret_Scancode(RIGHT,S) && Ret_Scancode(ALT,S) && vxsize<160*4) vxsize++;

       if(Ret_Scancode(PGUP,M) && zzz>(pagesize/2)) zzz-=pagesize/2;
       if(Ret_Scancode(PGUP,S) && Ret_Scancode(ALT,S) && zzz>(pagesize/2)) zzz-=pagesize/2;
       if(Ret_Scancode(PGDOWN,M) && (zzz+pagesize/2)<flen) zzz+=pagesize/2;
       if(Ret_Scancode(PGDOWN,S) && Ret_Scancode(ALT,S) && (zzz+pagesize/2)<flen) zzz+=pagesize/2;

       if(Ret_Scancode(ENTER,M))
       {
           val=fnum;
           buf[3]=val;
           val>>=4;
           buf[2]=val;
           val>>=4;
           buf[1]=val;
           val>>=4;
           buf[0]=val;
           val>>=4;
           for(i=0;i<=3;i++) utoa(buf[i],ascn,10);
           strcpy(pcxfname,"temp");
           strncat(pcxfname,ascn,4);
           strncat(pcxfname,".pcx",4);
           Save_PCX_picture640(pcxfname);

           fnum++;
       }
   }

   SV_restoreMode();
   Recover_Intr();

   printf("You have saved %d PCX images..\n", fnum);

}
else printf("Could not set specified video mode\n");


}
