/////////////////////////////////////////////////////////////////////////////////////////////
// CDX example 5 - Sprite lists, resources and timing
// You must link to cdx.lib, ddraw.lib, dinput, dxguid and winmm.lib

//                  cdx.lib ddraw.lib dxguid.lib winmm.lib cdi.lib dinput.lib cdc.lib 

/////////////////////////////////////////////////////////////////////////////////////////////
#include <windows.h>
#include <windowsx.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <CDX.h>
#include <CDI.h>
#include <ksock.h>
#include "cha.h"
////////////////////////////////////
///////////////////////////////////

// The sprite types
enum
{
	SPR_BUG,
	SPR_MOUTH,
	SPR_CHOMPER,
	SPR_PLAYER,
};

CDXScreen* Screen; // The screen object
//CDI_Input* Input; // The input device object
//CDI_Keyboard Key_Check;

// The sprite bitmaps
CDXTile* Bug;
CDXTile* Mouth;
CDXTile* Chomper;
CDXTile* Player;

//CDXSpriteList Sprites; // The sprite list object//  Ŭ   
												// OBJET Ŭ ü .


BOOL bActive = TRUE; // Is the program running?

// Frame rate counters
DWORD LastTime = 0;
DWORD CurTime = 0;
DWORD FpsTime = 0;
DWORD DeltaTime = 0;
DWORD FramesRendered = 0;
DWORD Fps = 0;

// Resource bitmap files
char BUG[] = "BUG";
char MOUTH[] = "MOUTH";
char CHOMPER[] = "CHOMPER";
char PLAYER[] = "PLAYER";


ccc *c ;




/////////////////////////////////////////////////////////////////////////////////////////////
// UpdateSprites
/////////////////////////////////////////////////////////////////////////////////////////////
//HINSTANCE hInst2;
//HWND hWnd2;
/////////////////////////////////////////////////////////////////////////////////////////////
// WinProc - Handle Windows messages
/////////////////////////////////////////////////////////////////////////////////////////////
long PASCAL WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message) 
	{
		case WM_ACTIVATEAPP:
      bActive = wParam; 
			break;

		case WM_KEYDOWN: 
			switch(wParam)
			{
				case VK_ESCAPE:
		
//					Screen->GetBack()->ReleaseDC();
//					delete msock;
					PostMessage(hWnd, WM_CLOSE, 0, 0);
				break;
			}
		break;
		case WM_DESTROY:
				delete Player; 
				delete Chomper;
				delete Mouth;
				delete Bug;
				delete Screen;
			OBJECT::Reset(); 
			PostQuitMessage(0);
		break; 
	}
 
	return DefWindowProc(hWnd, message, wParam, lParam);
} 
 
/////////////////////////////////////////////////////////////////////////////////////////////
// InitApp - Create the window and the CDX objects
/////////////////////////////////////////////////////////////////////////////////////////////
BOOL InitApp(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;
	WNDCLASS WndClass; 

	WndClass.style = CS_DBLCLKS;
	WndClass.lpfnWndProc = WinProc;
	WndClass.cbClsExtra = 0;
	WndClass.cbWndExtra = 0;
	WndClass.hInstance = hInst;
	WndClass.hIcon = LoadIcon(0, IDI_APPLICATION);
	WndClass.hCursor = LoadCursor(0, IDC_ARROW);
	WndClass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	WndClass.lpszMenuName = 0;
	WndClass.lpszClassName = "Example 5";
	RegisterClass(&WndClass);

	hWnd = CreateWindowEx(
		WS_EX_TOPMOST,
		"Example 5",
		"Example 5",
		WS_POPUP,
		0,0,
		GetSystemMetrics(SM_CXSCREEN),
		GetSystemMetrics(SM_CYSCREEN),
		NULL,
		NULL,
		hInst,
		NULL);

	if(!hWnd) return FALSE;



	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);




	// Create the CDXScreen object
	Screen = new CDXScreen();
	Screen->Create(hWnd, 640, 480, 8, CDXCREATE_FULLSCREEN);
	Screen->LoadPalette(BUG);

	
	// Load the bitmaps
	Bug     = new CDXTile(Screen, BUG, 84, 80, 1);
	Mouth   = new CDXTile(Screen, MOUTH, 39, 36, 3);
	Chomper = new CDXTile(Screen, CHOMPER, 38, 34, 5);
	Player  = new CDXTile(Screen, PLAYER, 38, 36, 3);

	// Set the bitmap transparent color
	DDSetColorKey(Bug->m_Surface,RGB(171, 0, 0));
	DDSetColorKey(Mouth->m_Surface,RGB(171, 0, 0));
	DDSetColorKey(Chomper->m_Surface,RGB(171, 0, 0));
	DDSetColorKey(Player->m_Surface,RGB(171, 0, 0));
/*
	Bug->SetColorKey(8);
	Mouth->SetColorKey(8);
	Chomper->SetColorKey(8);
	Player->SetColorKey(8);

  */
	// Seed the random-number generator with current time
	srand((unsigned)time(NULL));

	// Change the default font
	Screen->GetBack()->SetFont("Comic Sans MS", 0, 18);
	c = new ccc(Bug,1,1,0	,0,hInst,hWnd);	
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////
// WinMain - The main program loop
/////////////////////////////////////////////////////////////////////////////////////////////
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg; 
 
	if(!InitApp(hInst, nCmdShow)) return FALSE;
//	c = new ccc(Bug,1,1,0	,0);	
	
	while(1)
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if(bActive)
		{
		
///////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
 
						 
		OBJECT::Process();
		
			  

			
		Screen->GetBack()->Fill(0);


		OBJECT::DisplayAll();

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

			// Frame rate calculations
			CurTime   = timeGetTime();
			DeltaTime = CurTime - LastTime;
			LastTime  = CurTime;
			FpsTime  += DeltaTime;

			FramesRendered++;

			if (FpsTime > 1000)
			{
				Fps = FramesRendered;
				FramesRendered  = 0;
				FpsTime = 0;
			}

			char str[12];
			sprintf(str, "FPS: %d", Fps);

			// Print the frame rate to the screen
			Screen->GetBack()->GetDC();
//	
			Screen->GetBack()->TextXY(5, 5, 255, str);
//			Screen->GetBack()->TextXY(5, 20, 255, "INSERT - ADD SPRITE");
//			Screen->GetBack()->TextXY(5, 35, 255, "DELETE - DEL SPRITE");
			Screen->GetBack()->ReleaseDC();

			// Display the back buffer 
			Screen->Flip();
		} 
		else WaitMessage();  
	}
}
