//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDS Class Library - CDS.lib ]
// Author:       [ Dan Farley - 97308096@brookes.ac.uk ]
// Source File:  [ Main Header File ]
// Revision:     [ 1.6 ]
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDS_H
#define CDS_H

#include <windows.h>
#include <mmsystem.h>
#include <dsound.h>

//////////////////////////////////////////////////////////////////////////////////
// Definied Types
//////////////////////////////////////////////////////////////////////////////////

#define SAFE_RELEASE(x) if(x != NULL) { x->Release(); x = NULL; }
#define SAFE_DELETE(x) if(x != NULL) { delete x; x = NULL; }

typedef BOOL (*TIMERCALLBACK)(DWORD);

//////////////////////////////////////////////////////////////////////////////////
// CDS_Sound Class
//////////////////////////////////////////////////////////////////////////////////

class CDS_Sound
{
public:
	CDS_Sound(void);
	~CDS_Sound(void);

	HRESULT Create(void *hwnd);

	LPDIRECTSOUND GetDS(void) { return m_DirectSound; }
	LPDIRECTSOUNDBUFFER GetPrimary(void) { return m_Primary; }
	LPDIRECTSOUND3DLISTENER GetListener(void) { return m_Listener; }

public:
	LPDIRECTSOUND m_DirectSound;
	LPDIRECTSOUNDBUFFER m_Primary;
	LPDIRECTSOUND3DLISTENER m_Listener;
};

//////////////////////////////////////////////////////////////////////////////////
// CDS_WaveFile Class
//////////////////////////////////////////////////////////////////////////////////

class CDS_WaveFile
{
public:
	CDS_WaveFile(void);
	~CDS_WaveFile(void);

	BOOL Open(LPSTR pszFilename);
	BOOL Cue(void);
	UINT Read(BYTE* pbDest, UINT cbSize);

	UINT GetNumBytesRemaining(void) { return (m_nDataSize - m_nBytesPlayed); }
	UINT GetAvgDataRate(void)       { return (m_nAvgDataRate); }
	UINT GetDataSize(void)          { return (m_nDataSize); }
	UINT GetNumBytesPlayed(void)    { return (m_nBytesPlayed); }
	UINT GetDuration(void)          { return (m_nDuration); }
	BYTE GetSilenceData(void);

public:
	WAVEFORMATEX* m_pFormat;
	HMMIO m_hmmio;
	MMRESULT m_mmr;
	MMCKINFO m_mmckiRiff;
	MMCKINFO m_mmckiFmt;
	MMCKINFO m_mmckiData;
	UINT m_nDuration;
	UINT m_nBlockAlign;
	UINT m_nAvgDataRate;
	UINT m_nDataSize;
	UINT m_nBytesPlayed;
};

//////////////////////////////////////////////////////////////////////////////////
// CDS_Buffer Class
//////////////////////////////////////////////////////////////////////////////////

class CDS_Buffer
{
public:
	CDS_Buffer(void);
	~CDS_Buffer(void);

	virtual HRESULT Create(CDS_Sound* sound, char* filename, int count);

	HRESULT Play(DWORD flags);
	HRESULT Stop(void);
	LPDIRECTSOUNDBUFFER GetFreeBuffer(void);

public:
	int m_BufferCount;
	CDS_WaveFile* m_WaveFile;
	LPDIRECTSOUNDBUFFER *m_Buffer;
};

//////////////////////////////////////////////////////////////////////////////////
// CDS_3DBuffer Class
//////////////////////////////////////////////////////////////////////////////////

class CDS_3DBuffer : public CDS_Buffer
{
public:
	HRESULT Create(CDS_Sound* sound, char* filename, int count);
	LPDIRECTSOUND3DBUFFER m_3dBuffer;
};

//////////////////////////////////////////////////////////////////////////////////
// CDS_Timer Class
//////////////////////////////////////////////////////////////////////////////////

class CDS_Timer
{
public:
	CDS_Timer(void);
	~CDS_Timer(void);

	BOOL Create(
		UINT nPeriod,
		UINT nRes,
		DWORD dwUser,
		TIMERCALLBACK pfnCallback);

protected:
	static void CALLBACK TimeProc(
		UINT uID,
		UINT uMsg,
		DWORD dwUser,
		DWORD dw1,
		DWORD dw2);

	TIMERCALLBACK m_pfnCallback;
	DWORD m_dwUser;
	UINT m_nPeriod;
	UINT m_nRes;
	UINT m_nIDTimer;
};

//////////////////////////////////////////////////////////////////////////////////
// CDS_Stream Class
//////////////////////////////////////////////////////////////////////////////////

class CDS_Stream
{
public:
	CDS_Stream(void);
	~CDS_Stream(void);

	BOOL Create(CDS_Sound* pass, LPSTR pszFilename);
	BOOL Destroy(void);
	void Play(void);
	void Stop(void);

public:
	void Cue(void);
	BOOL WriteWaveData(UINT cbSize);
	BOOL WriteSilence(UINT cbSize);
	BOOL ServiceBuffer(void);
	DWORD GetMaxWriteSize(void);
	static BOOL TimerCallback(DWORD dwUser);

	CDS_Sound* m_pass;
	CDS_WaveFile* m_pwavefile;
	CDS_Timer* m_ptimer;

	LPDIRECTSOUNDBUFFER m_pdsb;
	DSBUFFERDESC m_dsbd;
	BOOL m_fCued;
	BOOL m_fPlaying;
	LONG m_lInService;
	UINT m_cbBufOffset;
	UINT m_nBufLength;
	UINT m_cbBufSize;
	UINT m_nBufService;
	UINT m_nDuration;
	UINT m_nTimeStarted;
	UINT m_nTimeElapsed;
};

class CDS_Music
{
public:
	CDS_Music(void *hwnd);
	BOOL Play(const char *filename);
	BOOL Stop(void);
	BOOL Pause(void);
	BOOL Resume(void);
	BOOL Restart(void);
	HWND m_hWnd;
};
#endif
