//////////////////////////////////////////////////////////////////////////////////
// CDS_Timer Implementation
//////////////////////////////////////////////////////////////////////////////////
#include "CDS.h"

//////////////////////////////////////////////////////////////////////////////////
// Constructor
//////////////////////////////////////////////////////////////////////////////////
CDS_Timer::CDS_Timer(void)
{
	m_nIDTimer = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// Destructor
//////////////////////////////////////////////////////////////////////////////////
CDS_Timer::~CDS_Timer(void)
{
	if(m_nIDTimer) timeKillEvent(m_nIDTimer);
}

//////////////////////////////////////////////////////////////////////////////////
// Create
//////////////////////////////////////////////////////////////////////////////////
BOOL CDS_Timer::Create(UINT nPeriod, UINT nRes, DWORD dwUser, TIMERCALLBACK pfnCallback)
{
	BOOL bRtn = TRUE;

	m_nPeriod = nPeriod;
	m_nRes = nRes;
	m_dwUser = dwUser;
	m_pfnCallback = pfnCallback;

	m_nIDTimer = timeSetEvent(m_nPeriod, m_nRes, TimeProc, (DWORD)this, TIME_PERIODIC);
	if(m_nIDTimer == NULL)
	{
		bRtn = FALSE;
	}

	return bRtn;
}

//////////////////////////////////////////////////////////////////////////////////
// TimeProc
//////////////////////////////////////////////////////////////////////////////////
void CALLBACK CDS_Timer::TimeProc(UINT uID, UINT uMsg, DWORD dwUser, DWORD dw1, DWORD dw2)
{
	// dwUser contains ptr to CDS_Timer object
	CDS_Timer* ptimer = (CDS_Timer*) dwUser;

	// Call user-specified callback and pass back user specified data
	(ptimer->m_pfnCallback) (ptimer->m_dwUser);
}
